/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dom.ib;
import ro.sync.ecss.dom.wrappers.AuthorTextHolderNodeDomWrapper;
import ro.sync.ecss.extensions.api.Content;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public class AuthorTextNodeDomWrapper
extends AuthorTextHolderNodeDomWrapper {
    private static final Logger logger = LoggerFactory.getLogger(AuthorTextNodeDomWrapper.class);
    private Position start = null;
    private Position end = null;

    public AuthorTextNodeDomWrapper(Node node, AuthorNode authorNode, int n2, boolean bl) {
        super(node, authorNode, n2, bl);
        if (authorNode != null) {
            try {
                int n3 = authorNode.getStartOffset();
                int n4 = authorNode.getEndOffset();
                if (bl) {
                    Content content = ((ib)authorNode).b();
                    this.start = content.createPosition(n3);
                    this.end = content.createPosition(n4);
                }
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
    }

    @Override
    protected String getTextInternal() throws BadLocationException {
        if (this.updatableModel) {
            Content content = ((ib)this.currentNode).b();
            return content.getString(this.start.getOffset(), this.end.getOffset() - this.start.getOffset() + 1);
        }
        return super.getTextInternal();
    }

    public AuthorTextNodeDomWrapper(Node node, String string, boolean bl) {
        super(node, null, -1, bl);
        this.text = string;
        if (this.text == null) {
            this.text = "";
        }
    }

    @Override
    public NodeList getChildNodes() {
        return EMPTY_NODE_LIST;
    }

    public int getStart() {
        return this.updatableModel ? this.start.getOffset() : this.currentNode.getStartOffset();
    }

    public int getEnd() {
        return this.updatableModel ? this.end.getOffset() : this.currentNode.getEndOffset();
    }

    @Override
    public String toString() {
        return "\"" + this.getNodeValue() + "\"" + super.toString();
    }
}

