/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dita.reference.mediatab.workingset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.exml.editor.finders.WorkingSetEntryPO;
import ro.sync.exml.editor.finders.WorkingSetPO;
import ro.sync.exml.editor.finders.gb;
import ro.sync.exml.editor.finders.x;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.SerializableList;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class MediaWorkingSetPO
implements WorkingSetPO {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MediaWorkingSetPO.class.getName());
    private SerializableList<WorkingSetEntryPO> workingSetEntries = new SerializableList();
    private String wSetName;
    private boolean isSelected;

    public MediaWorkingSetPO() {
    }

    public MediaWorkingSetPO(String string) {
        this(string, null, false);
    }

    public MediaWorkingSetPO(String string, boolean bl) {
        this(string, null, bl);
    }

    public MediaWorkingSetPO(String string, List<WorkingSetEntryPO> list, boolean bl) {
        this.wSetName = string;
        this.workingSetEntries = new SerializableList();
        this.isSelected = bl;
        if (list != null) {
            this.workingSetEntries.addAll(list);
            Collections.sort(this.workingSetEntries, new gb._b());
        }
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.wSetName == null) {
            throw new InvalidPersistentObjException("Working set must have a valid, non-null name");
        }
        if (this.workingSetEntries == null) {
            throw new InvalidPersistentObjException("Working set " + this.wSetName + " must have a valid list of entries");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public String getName() {
        return this.wSetName;
    }

    @Override
    public List<WorkingSetEntryPO> getEntries() {
        return this.workingSetEntries;
    }

    @Override
    public WorkingSetEntryPO[] addEntries(WorkingSetEntryPO ... workingSetEntryPOArray) {
        ArrayList<WorkingSetEntryPO> arrayList = new ArrayList<WorkingSetEntryPO>();
        for (int i2 = 0; i2 < workingSetEntryPOArray.length; ++i2) {
            if (this.workingSetEntries.contains(workingSetEntryPOArray[i2])) continue;
            this.workingSetEntries.add(workingSetEntryPOArray[i2]);
            arrayList.add(workingSetEntryPOArray[i2]);
        }
        Collections.sort(this.workingSetEntries, new gb._b());
        return arrayList.toArray(new WorkingSetEntryPO[0]);
    }

    @Override
    public Object clone() {
        MediaWorkingSetPO mediaWorkingSetPO = null;
        try {
            mediaWorkingSetPO = (MediaWorkingSetPO)super.clone();
            if (this.workingSetEntries != null) {
                mediaWorkingSetPO.workingSetEntries = (SerializableList)this.workingSetEntries.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOGGER.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return mediaWorkingSetPO;
    }

    @Override
    public void setName(String string) {
        this.wSetName = string;
    }

    public void setActive(boolean bl) {
        this.isSelected = bl;
    }

    public boolean isActive() {
        return this.isSelected;
    }

    @Override
    public x getType() {
        return x.b;
    }

    public String toString() {
        return "[Media WS: '" + this.getName() + "' is active: " + this.isActive() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.isSelected, this.wSetName, this.workingSetEntries);
    }

    public boolean equals(Object object) {
        if (object instanceof MediaWorkingSetPO) {
            MediaWorkingSetPO mediaWorkingSetPO = (MediaWorkingSetPO)object;
            if (this.isSelected == mediaWorkingSetPO.isSelected && this.wSetName.equals(mediaWorkingSetPO.getName())) {
                return Equaler.verifyListEquals(this.workingSetEntries, mediaWorkingSetPO.getEntries());
            }
        }
        return false;
    }
}

