/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Style;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.component.editor.b.b;
import ro.sync.ecss.component.editor.b.e;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.component.editor.fb;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.exml.rb;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.ui.application.i;
import ro.sync.ui.e.g;
import ro.sync.xml.l;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class HtmlContentEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
fb,
g {
    private static final Logger pty = LoggerFactory.getLogger((String)HtmlContentEditor.class.getName());
    private static final String tty = "<div id=\"divId\">Could not render the HTML content!</div>";
    private i sty;
    private HyperlinkListener rty;
    private StyleSheet oty = null;
    private ro.sync.ui.e.b qty = new ro.sync.ui.e.b(this, true, false){
        private StyleSheet i;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StyleSheet getStyleSheet() {
            if (this.i == null) {
                this.i = new StyleSheet();
                InputStream inputStream = this.g("default.css");
                if (inputStream != null) {
                    Reader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.ISO_8859_1));
                        this.i.loadRules(reader, null);
                    }
                    catch (Throwable throwable) {
                        if (pty.isDebugEnabled()) {
                            pty.debug((Object)throwable, throwable);
                        }
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            } else {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return this.i;
        }

        private InputStream g(String string) {
            return HTMLEditorKit.class.getResourceAsStream(string);
        }
    };

    public HtmlContentEditor() {
        this.sty = new i("text/html", "", false);
        this.sty.setEditorKit(this.qty);
        this.sty.setOpaque(false);
        this.sty.setEditable(false);
        this.rty = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                URL uRL;
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (uRL = l.b(null, hyperlinkEvent.getURL().toExternalForm(), false, true)) != null) {
                    rb.d(uRL, true);
                }
            }
        };
        this.sty.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                HtmlContentEditor.this.cancelEditing();
            }
        });
        this.sty.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                HtmlContentEditor.this.cancelEditing();
            }
        });
    }

    private void ryp(AuthorInplaceContext authorInplaceContext) {
        Object object;
        Map<String, Object> map = authorInplaceContext.getArguments();
        String string = (String)map.get("href");
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("content");
        String string4 = null;
        StyleSheet styleSheet = null;
        if (string3 != null) {
            string4 = string3;
            styleSheet = e.v().w();
        } else {
            object = e.v().d(authorInplaceContext.getAuthorAccess().getEditorAccess().getEditorLocation().toString(), string, string2);
            string4 = ((b)object).e();
            styleSheet = (StyleSheet)((b)object).c();
        }
        object = (HTMLEditorKit)this.sty.getEditorKit();
        StyleSheet styleSheet2 = ((HTMLEditorKit)object).getStyleSheet();
        if (this.oty != null && this.oty != styleSheet) {
            styleSheet2.removeStyleSheet(this.oty);
        }
        if (styleSheet != null && styleSheet != this.oty) {
            styleSheet2.addStyleSheet(styleSheet);
        }
        this.oty = styleSheet;
        if (string4 == null) {
            string4 = tty;
        }
        HTMLDocument hTMLDocument = (HTMLDocument)this.sty.getDocument();
        hTMLDocument.setBase(null);
        String string5 = (String)authorInplaceContext.getArguments().get("oxy_htmlcontent_base_url");
        if (string5 != null) {
            try {
                hTMLDocument.setBase(new URL(string5));
            }
            catch (MalformedURLException malformedURLException) {
                pty.error((Object)malformedURLException, (Throwable)malformedURLException);
            }
        }
        this.sty.setText(string4);
        this.sty.addHyperlinkListener(this.rty);
        ro.sync.exml.view.graphics.Dimension dimension = HtmlContentEditor.syp(this.sty, authorInplaceContext);
        this.sty.setPreferredSize(new Dimension(dimension.width, dimension.height));
        this.sty.setSize(new Dimension(dimension.width, dimension.height));
        this.sty.doLayout();
    }

    private static ro.sync.exml.view.graphics.Dimension syp(i i2, AuthorInplaceContext authorInplaceContext) {
        Cloneable cloneable;
        boolean bl;
        i2.setPreferredSize(null);
        i2.setSize(0, 0);
        int n2 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(authorInplaceContext.getArguments(), authorInplaceContext.getStyles().getFont().getSize());
        boolean bl2 = bl = n2 > 0;
        if (bl) {
            cloneable = i2.getInsets();
            i2.setSize(n2 + cloneable.left + cloneable.right, Integer.MAX_VALUE);
        }
        cloneable = db.c(i2, (Container)authorInplaceContext.getParentHost());
        int n3 = ((Dimension)cloneable).width;
        return new ro.sync.exml.view.graphics.Dimension(bl ? n2 : n3, ((Dimension)cloneable).height);
    }

    @Override
    public String getDescription() {
        return "A form control able to render HTML content.";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.ryp(authorInplaceContext);
        return this.sty;
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.ryp(authorInplaceContext);
        return this.sty;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.sty.requestFocus();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void stopEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void commitValue() {
        this.fireEditingCanceled();
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.ryp(authorInplaceContext);
        MouseEvent mouseEvent = new MouseEvent(this.sty, 503, System.currentTimeMillis(), 0, n2, n3, 0, false);
        this.sty.dispatchEvent(mouseEvent);
        CursorType cursorType = CursorType.CURSOR_NORMAL;
        int n4 = this.sty.getCursor().getType();
        if (n4 == 12) {
            cursorType = CursorType.CURSOR_HAND;
        }
        return cursorType;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.ryp(authorInplaceContext);
        return null;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.ryp(authorInplaceContext);
        Dimension dimension = this.sty.getPreferredSize();
        return new RendererLayoutInfo(db.b(this.sty, dimension.width, dimension.height), new ro.sync.exml.view.graphics.Dimension(dimension.width, dimension.height));
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.ryp(authorInplaceContext);
        stringBuilder.append(this.sty.getText());
        StyleSheet styleSheet = ((HTMLEditorKit)this.sty.getEditorKit()).getStyleSheet();
        for (StyleSheet styleSheet2 : styleSheet.getStyleSheets()) {
            Style style = styleSheet2.getRule("div");
            Enumeration<?> enumeration = style.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (!obj.toString().equals("resolver")) continue;
                String string = style.getAttribute(obj).toString();
                String[] stringArray = null;
                if (string.contains("{") && string.contains(",")) {
                    string = string.substring(string.indexOf(123) + 1, string.lastIndexOf(44));
                    stringArray = string.split(",");
                } else {
                    stringArray = string.split(" ");
                }
                List<String> list = Arrays.asList(stringArray);
                stringBuilder.append("\n").append(obj).append(" -> ");
                Collections.sort(list);
                for (String string2 : list) {
                    stringBuilder.append(string2).append(',');
                }
            }
        }
    }

    @Override
    public void customizeView(View view) {
        if (view instanceof ImageView) {
            ((ImageView)view).setLoadsSynchronously(true);
        }
    }
}

