/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.document.hc;
import ro.sync.document.q;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.component.editor.fb;
import ro.sync.ecss.component.editor.lb;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Dimension;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.workspace.api.standalone.ui.Button;
import ro.sync.i18n.c;
import ro.sync.i18n.r;
import ro.sync.ui.calendar.d;
import ro.sync.ui.calendar.f;
import ro.sync.ui.jb;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DatePickerEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
fb {
    private static final Logger lty = LoggerFactory.getLogger((String)DatePickerEditor.class.getName());
    protected static final c messages = r.m();
    private String gty = "custom";
    private String jty;
    private d ety;
    private f kty;
    private java.awt.Font dty;
    private String ity;
    private DocumentListener nty = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }
    };
    private KeyAdapter mty;
    private Color hty;
    private boolean fty = true;

    public DatePickerEditor() {
        final KeyStroke keyStroke = hc.f();
        this.kty = new f(null){

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke2, KeyEvent keyEvent, int n2, boolean bl) {
                boolean bl2 = true;
                if (keyStroke.equals(keyStroke2)) {
                    q q2 = hc.e(this.getDocument());
                    bl2 = ((UndoManager)q2).canUndo();
                }
                return bl2 ? super.processKeyBinding(keyStroke2, keyEvent, n2, bl) : false;
            }
        };
        this.ety = new d(null, null, null, this.kty, null);
        ArrayList<Component> arrayList = new ArrayList<Component>(1);
        arrayList.add(this.kty);
        this.ety.setFocusTraversalPolicy(new jb(this.ety, arrayList, this.kty, false));
        this.ety.setFocusTraversalPolicyProvider(true);
        this.mty = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    DatePickerEditor.this.cancelEditing();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    DatePickerEditor.this.jyp(false, true);
                }
            }
        };
        this.dty = this.ety.getFont();
        this.hty = this.kty.j();
    }

    @Override
    public String getDescription() {
        return "A date picker.";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.pyp(authorInplaceContext, true);
        return this.ety;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.kty.requestFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() {
        String string = "";
        Date date = this.ety.b();
        if (date != null) {
            if ("xs:date".equals(this.gty)) {
                return new SimpleDateFormat("yyyy-MM-dd").format(date);
            }
            if ("xs:dateTime".equals(this.gty)) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date);
            }
            java.util.Date date2 = new java.util.Date(date.getTime());
            try {
                return new SimpleDateFormat(this.jty).format(date2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!lty.isDebugEnabled()) return string;
                lty.debug((Object)illegalArgumentException, (Throwable)illegalArgumentException);
            }
            return string;
        } else {
            if (this.fty) return string;
            return this.kty.getText();
        }
    }

    private void jyp(boolean bl, boolean bl2) {
        this.ety.g();
        this.ety.removeKeyListener(this.mty);
        this.kty.getDocument().removeDocumentListener(this.nty);
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void stopEditing() {
        this.jyp(true, false);
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    @Override
    public void cancelEditing() {
        this.ety.g();
        this.ety.removeKeyListener(this.mty);
        this.kty.getDocument().removeDocumentListener(this.nty);
        this.fireEditingCanceled();
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.pyp(authorInplaceContext, false);
        return this.ety;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.pyp(authorInplaceContext, false);
        if (this.ity != null) {
            return this.ity;
        }
        Component component = this.lyp(this.ety, n2, n3);
        if (component instanceof Button) {
            return messages.getString("Click_to_edit");
        }
        return this.kty.getText();
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.pyp(authorInplaceContext, false);
        Dimension dimension = InplaceEditorUtil.getPreferredSize(this.ety, authorInplaceContext);
        return new RendererLayoutInfo(db.b(this.kty, dimension.width, dimension.height), dimension);
    }

    private void pyp(AuthorInplaceContext authorInplaceContext, boolean bl) {
        this.ity = null;
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            this.ety.setFont(new java.awt.Font(font.getName(), font.getStyle(), font.getSize()));
        } else {
            this.ety.setFont(this.dty);
        }
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.kty.g(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.kty.g(this.hty);
        }
        this.ety.setOpaque(false);
        String string = (String)authorInplaceContext.getArguments().get("validateInput");
        boolean bl2 = this.fty = string == null ? true : Boolean.valueOf(string);
        if (this.fty) {
            this.kty.b(true);
        } else {
            this.kty.b(false);
        }
        this.gty = lb.b(authorInplaceContext);
        this.jty = (String)authorInplaceContext.getArguments().get("format");
        String string2 = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.kty.getLocale())).toPattern();
        if (this.jty == null) {
            this.jty = string2;
        }
        this.nyp(authorInplaceContext);
        if (bl) {
            this.kty.getDocument().addDocumentListener(this.nty);
            this.kty.addKeyListener(this.mty);
            this.kty.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DatePickerEditor.this.ety.g();
                }
            });
        }
        this.kty.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!DatePickerEditor.this.ety.h()) {
                    DatePickerEditor.this.fireCommitValue(new EditingEvent((String)DatePickerEditor.this.getValue()));
                }
            }
        });
        Dimension dimension = InplaceEditorUtil.getPreferredSize(this.ety, authorInplaceContext);
        this.ety.setBounds(0, 0, dimension.width, dimension.height);
        this.kty.doLayout();
        if (!bl) {
            int n2;
            int n3;
            Component component;
            JButton jButton = this.ety.d();
            ButtonModel buttonModel = jButton.getModel();
            buttonModel.setRollover(false);
            buttonModel.setSelected(false);
            Point point = authorInplaceContext.getRelativeMouseLocation();
            if (point != null && (component = this.lyp(this.ety, n3 = point.x, n2 = point.y)) instanceof Button) {
                buttonModel.setRollover(true);
                buttonModel.setSelected(true);
            }
        }
    }

    private Component lyp(Component component, int n2, int n3) {
        Component component2 = component.getComponentAt(n2, n3);
        while (component2 != null && component2 != component) {
            component = component2;
            component2 = component.getComponentAt(n2 -= component2.getX(), n3 -= component2.getY());
        }
        return component2;
    }

    private void nyp(AuthorInplaceContext authorInplaceContext) {
        String string = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.kty.getLocale())).toPattern();
        Object object = authorInplaceContext.getArguments().get("format");
        String string2 = (String)authorInplaceContext.getArguments().get("initial_value");
        Long l2 = null;
        if ("custom".equals(this.gty)) {
            block17: {
                if (string2 != null) {
                    try {
                        java.util.Date date = new SimpleDateFormat(this.jty).parse(string2);
                        l2 = date.getTime();
                    }
                    catch (Exception exception) {
                        this.ity = exception.getMessage() + ". Expected \"" + this.jty + "\" format.";
                        if (!lty.isDebugEnabled()) break block17;
                        lty.debug((Object)exception, (Throwable)exception);
                    }
                }
            }
            this.kty.setDateFormatString(this.jty);
        } else if ("xs:date".equals(this.gty)) {
            if (string2 != null) {
                try {
                    Calendar calendar = DatatypeConverter.parseDate((String)string2);
                    l2 = calendar.getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.ity = "Invalid date: " + illegalArgumentException.getMessage() + ". Expected the xs:date format.";
                }
            }
            this.kty.setDateFormatString(object != null ? (String)object : string);
        } else if ("xs:dateTime".equals(this.gty)) {
            Object object2;
            if (string2 != null) {
                try {
                    object2 = DatatypeConverter.parseDateTime((String)string2);
                    l2 = ((Calendar)object2).getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.ity = "Invalid date-time: " + illegalArgumentException.getMessage() + ". Expected the xs:dateTime format.";
                }
            }
            object2 = ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3)).toPattern();
            this.kty.setDateFormatString((String)(object != null ? (String)object : object2));
        }
        if (l2 != null) {
            this.ety.i(new Date(l2));
        } else {
            this.ety.i(null);
        }
        if (this.ity != null && string2 != null) {
            this.kty.setText(string2);
        }
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.pyp(authorInplaceContext, false);
        stringBuilder.append("value:'").append(this.kty.getText()).append("'");
        stringBuilder.append("color:'").append(this.kty.getForeground()).append("'");
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.nyp(authorInplaceContext);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        try {
            this.kty.getDocument().insertString(this.kty.getCaretPosition(), string, null);
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            lty.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

