/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIValue;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.component.editor.fb;
import ro.sync.ecss.css.RelativeLength;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.workspace.api.Platform;
import ro.sync.ui.application.p;
import ro.sync.ui.e.f;
import ro.sync.ui.kd;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CheckBoxEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
fb {
    private static final Logger psy = LoggerFactory.getLogger((String)CheckBoxEditor.class.getName());
    private JPanel isy;
    private java.awt.Font hsy;
    private List<JCheckBox> jsy;
    private List<CIValue> osy;
    private List<CIValue> nsy;
    private String ksy;
    private boolean lsy = false;
    private List<String> msy;

    private void wxp(AuthorInplaceContext authorInplaceContext, boolean bl) {
        Serializable serializable;
        boolean bl2 = true;
        if (authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null) {
            bl2 = Platform.STANDALONE.equals((Object)authorInplaceContext.getAuthorAccess().getWorkspaceAccess().getPlatform());
        }
        KeyAdapter keyAdapter = null;
        FocusAdapter focusAdapter = null;
        ActionListener actionListener = null;
        if (!bl) {
            keyAdapter = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        keyEvent.consume();
                        CheckBoxEditor.this.cancelEditing();
                    }
                }
            };
            focusAdapter = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!CheckBoxEditor.this.jsy.contains(focusEvent.getOppositeComponent())) {
                        CheckBoxEditor.this.vxp(focusEvent.getOppositeComponent() == null);
                    }
                }
            };
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CheckBoxEditor.this.fireEditingOccured();
                    if (CheckBoxEditor.this.lsy) {
                        CheckBoxEditor.this.stopEditing();
                    } else {
                        CheckBoxEditor.this.fireCommitValue(new EditingEvent((String)CheckBoxEditor.this.getValue()));
                    }
                }
            };
        }
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("bg_color");
        Color color2 = null;
        if (color != null) {
            color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        this.isy = new JPanel();
        if (!bl2 && color2 != null) {
            this.isy.setBackground(color2);
            this.isy.setOpaque(true);
        } else {
            this.isy.setOpaque(false);
        }
        this.isy.setBorder(p.b());
        this.osy = (List)authorInplaceContext.getArguments().get("values");
        this.nsy = (List)authorInplaceContext.getArguments().get("uncheckedValues");
        this.msy = (List)authorInplaceContext.getArguments().get("labels");
        this.ksy = (String)authorInplaceContext.getArguments().get("resultSeparator");
        if (this.ksy == null) {
            this.ksy = " ";
        }
        LayoutManager layoutManager = new kd(0, 0, 0);
        Integer n2 = (Integer)authorInplaceContext.getArguments().get("columns");
        if (n2 != null && n2 > 0) {
            layoutManager = new GridLayout(0, Math.min(n2, this.osy.size()));
        }
        this.isy.setLayout(layoutManager);
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        Color color3 = null;
        if (color != null) {
            color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        if (psy.isDebugEnabled()) {
            psy.debug("initialValue " + string);
        }
        List<String> list = this.xxp(string);
        String string2 = (String)authorInplaceContext.getArguments().get("default_value");
        if (psy.isDebugEnabled()) {
            psy.debug("defaultValue " + string2);
        }
        List<String> list2 = this.xxp(string2);
        this.jsy = new ArrayList<JCheckBox>();
        for (int i2 = 0; i2 < this.osy.size(); ++i2) {
            serializable = new JCheckBox(){

                @Override
                protected void processMouseEvent(MouseEvent mouseEvent) {
                    try {
                        CheckBoxEditor.this.lsy = true;
                        super.processMouseEvent(mouseEvent);
                    }
                    finally {
                        CheckBoxEditor.this.lsy = false;
                    }
                }

                @Override
                public JToolTip createToolTip() {
                    return f.i(this);
                }
            };
            if (this.hsy == null) {
                this.hsy = ((Component)serializable).getFont();
            }
            if (!bl2 && color2 != null) {
                ((JComponent)serializable).setBackground(color2);
                ((JComponent)serializable).setOpaque(true);
            } else {
                ((JComponent)serializable).setOpaque(false);
            }
            if (color3 != null) {
                ((JComponent)serializable).setForeground(color3);
            }
            if (!bl) {
                ((Component)serializable).addKeyListener(keyAdapter);
                ((Component)serializable).addFocusListener(focusAdapter);
                ((AbstractButton)serializable).addActionListener(actionListener);
            }
            this.yxp((JCheckBox)serializable, i2, list, list2, bl, font);
            this.isy.add((Component)serializable);
            this.jsy.add((JCheckBox)serializable);
        }
        Point point = authorInplaceContext.getRelativeMouseLocation();
        if (bl && point != null) {
            serializable = db.c(this.isy, (Container)authorInplaceContext.getParentHost());
            this.isy.setSize(((Dimension)serializable).width, ((Dimension)serializable).height);
            this.isy.doLayout();
            Component component = this.isy.getComponentAt(point.x, point.y);
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).getModel().setRollover(true);
            }
        }
    }

    private List<String> xxp(String string) {
        ArrayList<String> arrayList = null;
        if (string != null) {
            arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, this.ksy);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                arrayList.add(string2.trim());
            }
        }
        return arrayList;
    }

    private void yxp(JCheckBox jCheckBox, int n2, List<String> list, List<String> list2, boolean bl, Font font) {
        String string;
        CIValue cIValue = this.osy.get(n2);
        String string2 = string = cIValue.getInsertString();
        if (this.msy != null && !this.msy.isEmpty()) {
            string2 = this.msy.get(n2);
        }
        if (n2 == 0 && string2.length() == 0) {
            string2 = "\u200b";
        }
        jCheckBox.setText(string2);
        jCheckBox.setToolTipText(cIValue.getAnnotation());
        boolean bl2 = false;
        if (list != null) {
            bl2 = list.contains(string);
        } else if (list2 != null) {
            bl2 = list2.contains(string);
        }
        jCheckBox.setSelected(bl2);
        java.awt.Font font2 = this.hsy;
        if (font != null) {
            font2 = new java.awt.Font(font.getName(), font.getStyle(), font.getSize());
        }
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = list == null && list2 != null;
            if (bl3) {
                int n3 = 2;
                if (font2.getStyle() != 0) {
                    n3 |= font2.getStyle();
                    font2 = font2.deriveFont(n3);
                }
            }
        }
        jCheckBox.setFont(font2);
    }

    @Override
    public String getDescription() {
        return "A renderer that uses checkboxes.";
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.wxp(authorInplaceContext, true);
        return this.isy;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        Serializable serializable;
        this.wxp(authorInplaceContext, true);
        int n2 = -1;
        if (!this.jsy.isEmpty()) {
            serializable = this.jsy.get(0);
            Dimension dimension = ((JComponent)serializable).getPreferredSize();
            n2 = db.b((JComponent)serializable, dimension.width, dimension.height);
        }
        serializable = this.zxp(authorInplaceContext);
        return new RendererLayoutInfo(n2, new ro.sync.exml.view.graphics.Dimension(((Dimension)serializable).width, ((Dimension)serializable).height));
    }

    private Dimension zxp(AuthorInplaceContext authorInplaceContext) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("processed_width", RelativeLength.createRelative(100.0f));
        int n2 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(hashMap, authorInplaceContext.getStyles().getFont().getSize());
        Dimension dimension = db.c(this.isy, (Container)authorInplaceContext.getParentHost());
        ++dimension.width;
        if (this.isy.getLayout() instanceof kd && dimension.width > n2) {
            int n3 = -1;
            for (JCheckBox jCheckBox : this.jsy) {
                int n4 = jCheckBox.getPreferredSize().width;
                if (n4 <= n3) continue;
                n3 = n4;
            }
            int n5 = -1;
            n5 = n2 > n3 ? n2 : n3;
            dimension = new Dimension(n5, Integer.MAX_VALUE);
            this.isy.setSize(dimension);
        }
        return dimension;
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, ro.sync.exml.view.graphics.Rectangle rectangle, Point point) {
        this.wxp(authorInplaceContext, false);
        return this.isy;
    }

    @Override
    public void requestFocus() {
        if (!this.jsy.isEmpty()) {
            this.jsy.get(0).requestFocus();
        }
    }

    @Override
    public Object getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.jsy.size(); ++i2) {
            String string = null;
            JCheckBox jCheckBox = this.jsy.get(i2);
            if (jCheckBox.isSelected()) {
                string = this.osy.get(i2).getInsertString();
            } else if (this.nsy != null && !this.nsy.isEmpty()) {
                string = this.nsy.get(i2).getInsertString();
            }
            if (string == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(this.ksy);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public void stopEditing() {
        this.vxp(true);
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    private void vxp(boolean bl) {
        this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        ro.sync.exml.view.graphics.Rectangle rectangle = null;
        for (int i2 = 0; i2 < this.jsy.size(); ++i2) {
            JCheckBox jCheckBox = this.jsy.get(i2);
            if (!jCheckBox.isFocusOwner()) continue;
            Rectangle rectangle2 = jCheckBox.getBounds();
            rectangle = new ro.sync.exml.view.graphics.Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            break;
        }
        return rectangle;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.wxp(authorInplaceContext, true);
        Dimension dimension = this.zxp(authorInplaceContext);
        this.isy.setSize(dimension.width, dimension.height);
        this.isy.doLayout();
        String string = null;
        Component component = this.isy.getComponentAt(n2, n3);
        if (component instanceof JCheckBox) {
            int n4 = this.jsy.indexOf(component);
            CIValue cIValue = this.osy.get(n4);
            string = cIValue.getAnnotation();
        }
        return string;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        List<String> list = this.xxp(string);
        String string2 = (String)authorInplaceContext.getArguments().get("default_value");
        List<String> list2 = this.xxp(string2);
        this.osy = (List)authorInplaceContext.getArguments().get("values");
        this.nsy = (List)authorInplaceContext.getArguments().get("uncheckedValues");
        this.msy = (List)authorInplaceContext.getArguments().get("labels");
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        for (int i2 = 0; i2 < this.osy.size(); ++i2) {
            this.yxp(this.jsy.get(i2), i2, list, list2, true, font);
        }
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.wxp(authorInplaceContext, true);
        for (JCheckBox jCheckBox : this.jsy) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (jCheckBox.isSelected()) {
                stringBuilder.append("|X|");
            } else {
                stringBuilder.append("| |");
            }
            stringBuilder.append(jCheckBox.getText());
        }
    }
}

