/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.text.BadLocationException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.document.w;
import ro.sync.ecss.common.WebappTextModeState;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.access.InternalWebappPluginWorkspace;
import ro.sync.ecss.g.j;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationManager;
import ro.sync.ecss.webapp.auth.ApplicationUserStore;
import ro.sync.exml.editor.xmleditor.XMLAnchor;
import ro.sync.exml.editor.xmleditor.hc;
import ro.sync.exml.editor.xmleditor.p;
import ro.sync.exml.editor.xmleditor.pageauthor.t;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.http.abstraction.k;
import ro.sync.syntaxhighlight.marker.TokenMarker;
import ro.sync.syntaxhighlight.marker.TokenMarkerFactory;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class WebappAccess {
    private static final Logger b = LoggerFactory.getLogger((String)WebappAccess.class.getName());

    private WebappAccess() {
    }

    public static WebappTextModeState getTextModeState(AuthorDocumentModel authorDocumentModel) {
        String string;
        Reader reader = authorDocumentModel.createReader();
        AuthorDocumentController authorDocumentController = authorDocumentModel.getAuthorDocumentController();
        int n2 = authorDocumentModel.getSelectionModel().getCaretOffset();
        AuthorElement authorElement = authorDocumentController.getAuthorDocumentNode().getRootElement();
        if (authorElement != null) {
            n2 = Math.max(authorElement.getStartOffset(), n2);
        }
        try {
            string = IOUtils.toString((Reader)reader);
        }
        catch (IOException iOException) {
            b.error("IOException thrown while reading the in-memory model: " + iOException, (Throwable)iOException);
            throw new IllegalStateException();
        }
        int n3 = 1;
        try {
            XMLAnchor xMLAnchor = t.l((j)authorDocumentController, n2);
            if (xMLAnchor != null) {
                TokenMarker tokenMarker = TokenMarkerFactory.newTokenMarker("text/xml");
                w w2 = w.ruj(tokenMarker);
                w2.irj(false);
                w2.ytj(false);
                w2.insertString(0, string, null);
                n3 = hc.b(w2, xMLAnchor);
            }
        }
        catch (BadLocationException badLocationException) {
            b.warn("Could not compute text-mode caret offset: " + badLocationException, (Throwable)badLocationException);
        }
        return new WebappTextModeState(string, n3);
    }

    public static void setTextModeState(AuthorDocumentModel authorDocumentModel, WebappTextModeState webappTextModeState) {
        j j2 = (j)authorDocumentModel.getAuthorDocumentController();
        AuthorDocument authorDocument = j2.getAuthorDocumentNode();
        authorDocumentModel.getAuthorAccess().getEditorAccess().reloadContent(new StringReader(webappTextModeState.getXmlContent()), false);
        AuthorDocument authorDocument2 = j2.getAuthorDocumentNode();
        if (authorDocument != authorDocument2) {
            try {
                TokenMarker tokenMarker = TokenMarkerFactory.newTokenMarker("text/xml");
                w w2 = w.ruj(tokenMarker);
                w2.irj(false);
                w2.duj(false);
                w2.ytj(false);
                w2.insertString(0, webappTextModeState.getXmlContent(), null);
                XMLAnchor xMLAnchor = hc.d(w2, webappTextModeState.getCaretOffset());
                int n2 = t.i(j2.c(), xMLAnchor);
                authorDocumentModel.getSelectionModel().moveTo(n2);
            }
            catch (BadLocationException | p exception) {
                b.debug((Object)exception, (Throwable)exception);
            }
        }
    }

    public static void disposeSession(String string) {
        k.c(string);
        WebappAccess.b(string);
    }

    private static void b(String string) {
        InternalWebappPluginWorkspace internalWebappPluginWorkspace = (InternalWebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ApplicationAuthenticationManager applicationAuthenticationManager = internalWebappPluginWorkspace.getApplicationAuthenticationManager();
        ApplicationUserStore applicationUserStore = applicationAuthenticationManager.getApplicationUserStore();
        applicationUserStore.revokeAuthentication(string);
    }
}

