/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.merge.trackchange.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.diff.api.AuthorDiffChangeTrackingMergerFactory;
import ro.sync.diff.api.AuthorDiffDirectoriesChangeTrackingMerger;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.api.DiffOptions;
import ro.sync.diff.script.c;
import ro.sync.util.fb;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class MergeDirectoriesWithChangeTrackingHighlights {
    protected static final String[] h = new String[]{"-base", "pathOfBaseDir", "Mandatory argument that specifies the path of the base directory (it can also be provided as a URL using 'file://' protocol).\n"};
    protected static final String[] j = new String[]{"-dtmw", "pathOfDirToMergeWith", "Mandatory argument that specifies the path of the directory to merge with (it can also be provided as a URL using 'file://' protocol).\n"};
    protected static final String[] b = new String[]{"-outd", "pathOfOutDir", "Optional argument that specifies the path of the directory where the merge operation results are saved to (it can also be provided as a URL using 'file://' protocol). If present, it must appear immediately after the first two mandatory arguments. If absent, the merge results are saved to the base directory, by overwriting it. You cannot choose the same directory specified as the directory to merge with as the output directory, the merge process is aborted in this case.\n"};
    protected static final String[] i = new String[]{"-nb", "noBackupOfBaseDir", "Set to \"true\" if do not want a backup copy of the base directory on the hard disk. There are 2 situations when a backup of the base directory is performed automatically and the backup operation must succeed to proceed with the merge (otherwise, the merge process is aborted): if the output directory is not specified (i.e. \"pathOfOutDir\" argument is not present), or the specified output directory is the base directory itself. The backup copy will have the same parent directory as the base directory and its name will be the name of the base directory suffixed by \".OXY.BAK\". Default value = \"false\", which means that, for any of the 2 previously mentioned situations, a backup copy of the base directory will be kept on the hard disk.\n"};
    protected static final String[] g = new String[]{"-nu", "noUpdateOfModifNonXMLFiles", "Set to \"true\" if you want to keep the non-XML files at their versions from the base directory. Default value = \"false\", which means that all files in the output directory that are copies of non-XML files in the base directory will be replaced by their corresponding files in the directory to merge with.\n"};
    protected static final String[] k = new String[]{"-na", "noAddingFilesOnlyPresentInDirToMergeWith", "Set to \"true\" if you want to skip adding the files only present in the directory to merge with to the output directory too. Default value = \"false\", which means that all files that are only present in the directory to merge with are also added to the output directory.\n"};
    protected static final String[] e = new String[]{"-nd", "noDeletionOfFilesOnlyPresentInBaseDir", "Set to \"true\" if you want to preserve the files that are only present in the base directory. Default value = \"false\", which means that all files that are only present in the base directory and initially copied to the output directory are deleted.\n"};
    protected static final String[] d = new String[]{"-cm", "createChangeTrackingMarkersForAddedXMLFiles", "Set to \"true\" if you want to create change tracking markers for the XML files only present in the directory to merge with, that will be added to the output directory. Although these files have no counterparts in the base directory, change tracking markers of type \"entire content added/inserted\" will be created. The option is not necessarily intended for the merge process itself, but it might prove an useful addition when you want to apply various Oxygen transformation scenarios to the resulting output directory. For example, if you merge 2 versions of a DITA project and then want a PDF to highlight the changes between those versions, you can apply a transformation on the resulting ditamap file. The \"-am\" option allows presenting the new DITA files as \"added content\" in the resulting PDF. Note that the option is only considered if the \"-na\" argument is absent or is explicitly set to \"false\". Default value = \"false\".\n"};
    protected static final String f = "\nAdditional notes:\n 1. To better understand the options explained above (i.e. what exactly does \"add\", \"delete\", \"update\") note that the merge process has a preliminary phase where the entire structure and content of the base directory is copied to the output directory.\n 2. For Boolean arguments, it is not necessary to provide the \"true\" value. Their presence in the argument list is equivalent to setting their value to \"true\" (and their absence from the argument list is equivalent to setting their value to \"false\"). However, constructs of the form \"bool_option true|false\" are accepted and interpreted accordingly.\n 3. Once the merge operation is complete, a report file is created and saved in the output directory, in a separate subdirectory named \".__OXY__MERGE__REPORT\". Loading the report file in Oxygen XML Editor provides additional functionality. Aside from the fact that the report provides an overview of the merge process, it also provides links to all the files in the resulting output directory. You can use the respective links to load the XML files in the editor, then switch to Author mode to review the tracked changes and accept or reject them.\n";
    protected static final String c = "-help | --help | -h | --h";

    private static void d() {
        System.out.println("Script for merging 2 directories with change tracking highlights, using the Oxygen Diff Directories 2-Way Comparator and Oxygen XML File Merger\n");
        char c2 = ' ';
        String string = " = ";
        StringBuilder stringBuilder = new StringBuilder(c2);
        stringBuilder.append(h[1]).append(c2).append(j[1]).append(c2).append('[');
        stringBuilder.append('[').append(b[1]).append("] ");
        List<String[]> list = MergeDirectoriesWithChangeTrackingHighlights.c();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String[] stringArray = list.get(i2);
            stringBuilder.append(i2 > 0 ? Character.valueOf(c2) : "").append('[').append(stringArray[0]).append(c2).append(stringArray[1]).append(']');
        }
        stringBuilder.append(']').append(c2).append('[').append(c).append(']');
        System.out.println((PlatformDetector.isWin() ? "mergeDirsTrackChanges.bat " : "sh mergeDirsTrackChanges.sh ") + stringBuilder.toString());
        stringBuilder = new StringBuilder("\nWhere:\n");
        stringBuilder.append(c2).append(h[1]).append(string).append(h[2]);
        stringBuilder.append(c2).append(j[1]).append(string).append(j[2]);
        stringBuilder.append(c2).append(b[1]).append(string).append(b[2]);
        for (String[] stringArray : list) {
            stringBuilder.append(c2).append(stringArray[0]).append(c2).append(stringArray[1]).append(string).append(stringArray[2]);
        }
        stringBuilder.append(c2).append(c).append(string).append("shows this help text.");
        stringBuilder.append('\n').append(f);
        System.out.println(stringBuilder.toString());
    }

    private static List<String[]> c() {
        return Arrays.asList(i, g, k, e, d);
    }

    private static Map<String, String> e(String[] stringArray) {
        HashMap<String, String> hashMap = null;
        if (stringArray.length > 1) {
            hashMap = new HashMap<String, String>();
            hashMap.put(h[0], stringArray[0]);
            hashMap.put(j[0], stringArray[1]);
            if (stringArray.length > 2) {
                hashMap.putAll(ro.sync.diff.script.c.j(stringArray, b[0], MergeDirectoriesWithChangeTrackingHighlights.c()));
            }
        }
        return hashMap;
    }

    private static void g(Map<String, String> map) {
        if (map == null) {
            System.err.println("ERROR: Wrong argument list. At least the directory paths must be provided.\n");
            System.exit(1);
        } else if (map.size() > 2) {
            MergeDirectoriesWithChangeTrackingHighlights.b(map);
        }
    }

    private static void b(Map<String, String> map) {
        ro.sync.diff.script.c.f(map, i[0], "No backup of base directory");
        ro.sync.diff.script.c.f(map, g[0], "No update of modified non-XML files");
        ro.sync.diff.script.c.f(map, k[0], "No adding files only present in the directory to merge with");
        ro.sync.diff.script.c.f(map, e[0], "No deletion of files only present in the base directory");
        ro.sync.diff.script.c.f(map, d[0], "Add change tracking markers to added XML files");
    }

    protected static boolean f(String[] stringArray) {
        Map<String, String> map = MergeDirectoriesWithChangeTrackingHighlights.e(stringArray);
        MergeDirectoriesWithChangeTrackingHighlights.g(map);
        boolean bl = false;
        AuthorDiffDirectoriesChangeTrackingMerger authorDiffDirectoriesChangeTrackingMerger = null;
        try {
            authorDiffDirectoriesChangeTrackingMerger = AuthorDiffChangeTrackingMergerFactory.createDirectoryChangeTrackingMergePerformer();
        }
        catch (DiffException diffException) {
            bl = true;
            System.err.println("ERROR: " + diffException.getMessage());
        }
        if (!bl) {
            try {
                authorDiffDirectoriesChangeTrackingMerger.mergeDirectoriesWithChangeTrackingHighlights(URLUtil.convertToURL((String)map.get(h[0])), URLUtil.convertToURL((String)map.get(j[0])), map.get(b[0]) != null ? URLUtil.convertToURL((String)map.get(b[0])) : null, new DiffOptions(), Boolean.valueOf(map.get(k[0])) == false, Boolean.valueOf(map.get(d[0])), Boolean.valueOf(map.get(e[0])) == false, Boolean.valueOf(map.get(g[0])) == false);
            }
            catch (DiffException diffException) {
                bl = true;
                System.err.println("ERROR: " + diffException.getMessage());
            }
        }
        if (!bl && Boolean.TRUE.equals(Boolean.valueOf(map.get(i[0])))) {
            String string = URLUtil.convertToURL((String)map.get(h[0])).toString();
            URL uRL = null;
            try {
                uRL = new URL(string.substring(0, string.length() - 1) + ".OXY.BAK");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            File file = URLUtil.getFileFromFileUrl(uRL, (boolean)true, (boolean)false, (boolean)false);
            if (file.exists()) {
                FileSystemUtil.deleteRecursivelly((File)file);
            }
        }
        return !bl;
    }

    public static void main(String[] stringArray) {
        ro.sync.diff.script.c.c("Merge directories with change tracking highlights");
        if (stringArray.length == 1 && fb.b(stringArray[0])) {
            MergeDirectoriesWithChangeTrackingHighlights.d();
            System.exit(0);
        }
        System.exit(MergeDirectoriesWithChangeTrackingHighlights.f(stringArray) ? 0 : 1);
    }
}

