/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.db;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Crypto;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.db.cb;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.options.SerializableLinkedHashMap;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DBConnectionInfo
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)DBConnectionInfo.class.getName());
    public static final int INVALID_KEY = 0;
    public static final int RDBMS = 0;
    public static final int NXD = 1;
    private int key = 0;
    private boolean isVisibleFromExplorer = true;
    private boolean canBeDisplayedInExplorer = true;
    private String sessionName = "";
    private String userName;
    private String password;
    private String driverName;
    private String urlFormat;
    private String host;
    private String port;
    private String initialDatabase;
    private boolean additionalCheck;
    private String webdavUrl;
    private SerializableLinkedHashMap<String, String> properties;

    public SerializableLinkedHashMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(SerializableLinkedHashMap<String, String> serializableLinkedHashMap) {
        this.properties = serializableLinkedHashMap;
    }

    public String getSessionName() {
        if ("".equals(this.sessionName)) {
            return null;
        }
        return this.sessionName;
    }

    public DBConnectionInfo() {
    }

    public DBConnectionInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this(string, string2, string3, string4, string5, string6, string7, null);
    }

    public DBConnectionInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.key = cb.j();
        this.driverName = string2;
        this.urlFormat = string3;
        this.userName = string4;
        this.setPassword(string5);
        this.host = string6;
        this.port = string7;
        this.sessionName = string == null ? this.getSessionNameProposal() : string;
        this.initialDatabase = string8;
    }

    public DBConnectionInfo(int n2) {
        this.key = n2;
    }

    public boolean equals(Object object) {
        return object == null || !(object instanceof DBConnectionInfo) ? false : ((DBConnectionInfo)object).getKey() == this.key;
    }

    public int hashCode() {
        return this.key;
    }

    public String getURL() {
        return this.urlFormat;
    }

    public void setURL(String string) {
        this.urlFormat = string;
    }

    public String getPassword() {
        String string = null;
        if (this.password != null) {
            string = Crypto.decrypt((String)this.password);
        }
        return string;
    }

    public void setPassword(String string) {
        this.password = string != null ? Crypto.crypt((String)string) : null;
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUsername(String string) {
        this.userName = string;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.sessionName.length() == 0) {
            throw new InvalidPersistentObjException("Empty session name");
        }
        if (this.key <= 0) {
            throw new InvalidPersistentObjException("Invalid unique key " + this.key);
        }
    }

    public String toString() {
        return this.key + " - " + this.sessionName;
    }

    public String getInitialDatabase() {
        return this.initialDatabase;
    }

    public void setInitialDatabase(String string) {
        this.initialDatabase = string;
    }

    public boolean isAdditionalCheck() {
        return this.additionalCheck;
    }

    public void setAdditionalCheck(boolean bl) {
        this.additionalCheck = bl;
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public boolean isVisibleFromExplorer() {
        return this.isVisibleFromExplorer;
    }

    public boolean canBeDisplayedInExplorer() {
        return this.canBeDisplayedInExplorer;
    }

    public void setVisibleFromExplorer(boolean bl) {
        this.isVisibleFromExplorer = bl;
    }

    public void setCanBeDisplayedInExplorer(boolean bl) {
        this.canBeDisplayedInExplorer = bl;
    }

    public int getKey() {
        return this.key;
    }

    public void setWebdavUrl(String string) {
        this.webdavUrl = string;
    }

    public String getWebdavUrl() {
        return this.webdavUrl;
    }

    private String getSessionNameProposal() {
        URL uRL;
        if (this.host != null) {
            return this.host;
        }
        if (this.urlFormat != null && (uRL = URLUtil.clearUserInfo((String)this.urlFormat)) != null) {
            return uRL.getHost();
        }
        return "";
    }

    public boolean isDifferent(DBConnectionInfo dBConnectionInfo) {
        if (this.key != dBConnectionInfo.key) {
            return true;
        }
        return !Equaler.verifyEquals((Object)this.sessionName, (Object)dBConnectionInfo.sessionName) || !Equaler.verifyEquals((Object)this.driverName, (Object)dBConnectionInfo.driverName) || !Equaler.verifyEquals((Object)this.userName, (Object)dBConnectionInfo.userName) || !Equaler.verifyEquals((Object)this.password, (Object)dBConnectionInfo.password) || !Equaler.verifyEquals((Object)this.host, (Object)dBConnectionInfo.host) || !Equaler.verifyEquals((Object)this.port, (Object)dBConnectionInfo.port) || !Equaler.verifyEquals((Object)this.initialDatabase, (Object)dBConnectionInfo.initialDatabase) || !Equaler.verifyEquals((Object)this.urlFormat, (Object)dBConnectionInfo.urlFormat) || !Equaler.verifyEquals((Object)this.webdavUrl, (Object)dBConnectionInfo.webdavUrl) || this.additionalCheck != dBConnectionInfo.additionalCheck;
    }

    public void setKey(int n2) {
        this.key = n2;
    }

    @Override
    public Object clone() {
        try {
            DBConnectionInfo dBConnectionInfo = (DBConnectionInfo)super.clone();
            if (this.properties != null) {
                dBConnectionInfo.properties = (SerializableLinkedHashMap)this.properties.clone();
            }
            return dBConnectionInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public DBConnectionInfo copy() {
        DBConnectionInfo dBConnectionInfo = (DBConnectionInfo)this.clone();
        dBConnectionInfo.setKey(cb.j());
        return dBConnectionInfo;
    }
}

