/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.resolver.Resolver;
import java.io.IOException;
import org.apache.xerces.parsers.OxygenPostDTDValidationParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.ditang.relaxng.defaults.LoggerUtil;
import org.ditang.relaxng.defaults.RelaxNGDefaultsComponent;
import org.ditang.relaxng.defaults.Util;
import org.slf4j.Logger;

public class RelaxDefaultsParserConfiguration
extends OxygenPostDTDValidationParserConfiguration {
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String XERCES_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected RelaxNGDefaultsComponent fRelaxDefaults;
    protected Resolver resolver;
    private boolean relaxNGValidation = false;
    private static Logger logger;

    public RelaxDefaultsParserConfiguration() {
        this(null, null, null);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, Resolver resolver) {
        this(symbolTable, xMLGrammarPool, null, resolver, false);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, Resolver resolver, boolean bl) {
        this(symbolTable, xMLGrammarPool, null, resolver, bl);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, XMLComponentManager xMLComponentManager, Resolver resolver) {
        this(symbolTable, xMLGrammarPool, xMLComponentManager, resolver, false);
    }

    public RelaxDefaultsParserConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, XMLComponentManager xMLComponentManager, Resolver resolver, boolean bl) {
        super(symbolTable, xMLGrammarPool, xMLComponentManager, bl);
        this.resolver = resolver;
    }

    public boolean parse(boolean bl) throws IOException {
        boolean bl2 = Util.isInsideDITAOTProcess();
        if (this.fInputSource != null && bl2) {
            try {
                this.setFeature(DYNAMIC_VALIDATION, this.getFeature(VALIDATION) || this.getFeature(XERCES_SCHEMA_VALIDATION));
            }
            catch (Exception exception) {
                RelaxDefaultsParserConfiguration.getLogger().error((Object)exception, (Throwable)exception);
            }
        }
        return super.parse(bl);
    }

    protected void configurePipeline() {
        super.configurePipeline();
        this.insertRelaxDefaultsComponent();
    }

    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.insertRelaxDefaultsComponent();
    }

    protected final void insertRelaxDefaultsComponent() {
        XMLDocumentSource xMLDocumentSource;
        XMLDocumentHandler xMLDocumentHandler;
        if (this.fRelaxDefaults == null) {
            this.fRelaxDefaults = new RelaxNGDefaultsComponent(this.resolver, this.fGrammarPool);
            this.addCommonComponent(this.fRelaxDefaults);
            this.fRelaxDefaults.setValidate(this.relaxNGValidation);
            this.fRelaxDefaults.setProperty("http://apache.org/xml/properties/internal/error-handler", this.getProperty("http://apache.org/xml/properties/internal/error-handler"));
            this.fRelaxDefaults.reset((XMLComponentManager)this);
        }
        if ((xMLDocumentHandler = (xMLDocumentSource = this.fLastComponent).getDocumentHandler()) != this.fRelaxDefaults) {
            xMLDocumentSource.setDocumentHandler((XMLDocumentHandler)this.fRelaxDefaults);
            this.fRelaxDefaults.setDocumentSource(xMLDocumentSource);
            if (xMLDocumentHandler != null) {
                this.fRelaxDefaults.setDocumentHandler(xMLDocumentHandler);
                xMLDocumentHandler.setDocumentSource((XMLDocumentSource)this.fRelaxDefaults);
            }
            this.fLastComponent = this.fRelaxDefaults;
        } else {
            logger.error("Attempt to chain relaxng default configuration to itself", (Throwable)new Exception());
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerUtil.createLogger(RelaxDefaultsParserConfiguration.class.getName());
        }
        return logger;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if ("http://apache.org/xml/features/validation/rngschema".equals(string)) {
            this.relaxNGValidation = bl;
        } else {
            super.setFeature(string, bl);
        }
    }
}

