/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.editor.urlsupport;

import com.oxygenxml.editor.editors.OxygenDocumentPartitioner;
import com.oxygenxml.editor.urlsupport.URLEditorInput;
import com.oxygenxml.editor.urlsupport.URLStorage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.StringUtil;

@SkipObfuscate(classes=SkipLevel.PROTECTED, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public class URLDocumentProvider
extends StorageDocumentProvider {
    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (object instanceof URLEditorInput) {
            ((URLEditorInput)object).store(iDocument);
        } else if (object instanceof FileEditorInput) {
            IFile iFile = ((FileEditorInput)object).getFile();
            String string = iDocument.get();
            byte[] byArray = null;
            if (this.getEncoding(object) == null) {
                byArray = StringUtil.convertStringToByteArray((String)string, (String)"UTF8");
            } else {
                try {
                    byArray = string.getBytes(this.getEncoding(object));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = StringUtil.convertStringToByteArray((String)string, (String)"UTF8");
                }
            }
            if (!iFile.exists()) {
                iFile.create((InputStream)new ByteArrayInputStream(byArray), 1, iProgressMonitor);
            } else {
                iFile.setContents((InputStream)new ByteArrayInputStream(byArray), 1, iProgressMonitor);
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        return new AnnotationModel();
    }

    protected void setupDocument(Object object, IDocument iDocument) {
        OxygenDocumentPartitioner oxygenDocumentPartitioner = new OxygenDocumentPartitioner();
        oxygenDocumentPartitioner.connect(iDocument);
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            iDocumentExtension3.setDocumentPartitioner("oXygen_partitioning", (IDocumentPartitioner)oxygenDocumentPartitioner);
        } else {
            iDocument.setDocumentPartitioner((IDocumentPartitioner)oxygenDocumentPartitioner);
        }
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof URLEditorInput) {
            URLEditorInput uRLEditorInput = (URLEditorInput)iEditorInput;
            URLStorage uRLStorage = (URLStorage)uRLEditorInput.getStorage();
            InputStream inputStream = uRLStorage.getContents();
            try {
                List list;
                if ("UTF-8".equals(string) && (list = uRLStorage.getBomBytes()) != null && list.size() > 0) {
                    int n2;
                    int n3 = 0;
                    do {
                        if ((n2 = inputStream.read(new byte[list.size()])) != -1) continue;
                        throw new IOException();
                    } while ((n3 += n2) < list.size());
                }
                this.setDocumentContent(iDocument, inputStream, string);
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage() != null ? iOException.getMessage() : "";
                Status status = new Status(4, "org.eclipse.ui", 0, string2, (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }
}

