/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.editor.editors;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.xml.encoding.EncodingDetector;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class UnicodeContentDescriber
implements ITextContentDescriber {
    private static Logger b = LoggerFactory.getLogger(UnicodeContentDescriber.class);
    private static final QualifiedName[] c = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        byte[] byArray = null;
        ArrayList arrayList = new ArrayList();
        InputStreamReader inputStreamReader = EncodingDetector.getInstance().createReader(inputStream, null, null, "UTF8", arrayList);
        Byte[] byteArray = arrayList.toArray(new Byte[0]);
        if (byteArray != null && byteArray.length > 0) {
            byArray = new byte[byteArray.length];
            for (int i2 = 0; i2 < byteArray.length; ++i2) {
                Byte by = byteArray[i2];
                if (by == null) {
                    byArray = null;
                    break;
                }
                byArray[i2] = by;
            }
        }
        if (byArray != null && iContentDescription != null) {
            iContentDescription.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)this.b(byArray));
        }
        return this.describe(inputStreamReader, iContentDescription);
    }

    private byte[] b(byte[] byArray) {
        if (Equaler.verifyArrayEquals((byte[])byArray, (byte[])IContentDescription.BOM_UTF_8)) {
            return IContentDescription.BOM_UTF_8;
        }
        if (Equaler.verifyArrayEquals((byte[])byArray, (byte[])IContentDescription.BOM_UTF_16LE)) {
            return IContentDescription.BOM_UTF_16LE;
        }
        if (Equaler.verifyArrayEquals((byte[])byArray, (byte[])IContentDescription.BOM_UTF_16BE)) {
            return IContentDescription.BOM_UTF_16BE;
        }
        return byArray;
    }

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        int n2 = 2;
        String string = null;
        try {
            string = EncodingDetector.getInstance().getHeaderIANAEncoding(reader, false);
            if (string == null || "".equals(string.trim())) {
                n2 = 1;
                string = "UTF-8";
            } else {
                String string2 = EncodingDetector.getInstance().getIANAEncodingFromJava(string);
                string = string2 != null ? string2 : string.toUpperCase();
            }
            if (iContentDescription != null && iContentDescription.isRequested(IContentDescription.CHARSET)) {
                iContentDescription.setProperty(IContentDescription.CHARSET, (Object)string);
            }
        }
        catch (Throwable throwable) {
            b.warn("?? Invalid ?? - " + throwable.getMessage(), throwable);
            n2 = 0;
        }
        if (b.isDebugEnabled()) {
            b.debug("Encoding: " + string + " return code: " + n2);
        }
        return n2;
    }

    public QualifiedName[] getSupportedOptions() {
        return c;
    }
}

