/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml.imagemap;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorElementBaseInterface;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.imagemap.NewWebappAreaView;
import ro.sync.ecss.extensions.api.webapp.imagemap.WebappAreaViewFactory;
import ro.sync.ecss.extensions.commons.imagemap.operations.NewShapeDescriptor;
import ro.sync.ecss.extensions.commons.imagemap.operations.UpdateImageMapOperationBase;
import ro.sync.exml.view.graphics.Circle;
import ro.sync.exml.view.graphics.Polygon;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.view.graphics.Shape;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class XHTMLUpdateImageMapOperation
extends UpdateImageMapOperationBase {
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorNode imageNode = this.getImageNode(authorAccess);
        super.doOperation(authorAccess, args);
        authorAccess.getEditorAccess().refresh(imageNode);
    }

    private AuthorNode getImageNode(AuthorAccess authorAccess) {
        AuthorNode imageNode;
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        try {
            imageNode = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
        return imageNode;
    }

    @Override
    protected List<? extends NewShapeDescriptor> getNewShapesList(String svgText) throws AuthorOperationException {
        return WebappAreaViewFactory.createFromSvg((String)svgText).stream().map(XHTMLNewShapeDescriptor::new).collect(Collectors.toList());
    }

    @Override
    protected AuthorElement[] getExistingShapesList(AuthorElement existingImageMap) {
        return existingImageMap.getElementsByLocalName("area");
    }

    @Override
    protected AuthorElement getImageMapElement(AuthorElement currentElement) {
        AuthorElementBaseInterface parent = currentElement.getParentElement();
        List siblings = parent.getContentNodes();
        AuthorNode map = (AuthorNode)siblings.get(siblings.size() - 1);
        return (AuthorElement)map;
    }

    public static class XHTMLNewShapeDescriptor
    implements NewShapeDescriptor {
        private NewWebappAreaView areaView;

        public XHTMLNewShapeDescriptor(NewWebappAreaView areaView) {
            this.areaView = areaView;
        }

        @Override
        public Optional<String> serializeToXml() {
            String shapeName;
            Shape shape = this.areaView.getShape();
            if (shape instanceof Circle) {
                shapeName = "circle";
            } else if (shape instanceof Rectangle) {
                shapeName = "rect";
            } else if (shape instanceof Polygon) {
                shapeName = "poly";
            } else {
                return Optional.empty();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<area shape=\"").append(shapeName).append("\" ").append("xmlns=\"http://www.w3.org/1999/xhtml\" ").append("coords=\"").append(this.getCoords()).append("\" ").append("alt=\"").append(this.getCoords()).append("\"").append("/>");
            return Optional.of(sb.toString());
        }

        private String getCoords() {
            StringBuilder sb = new StringBuilder();
            Shape shape = this.areaView.getShape();
            if (shape instanceof Circle) {
                Circle circle = (Circle)shape;
                sb.append(circle.x).append(',').append(circle.y).append(',').append(circle.radius);
            } else if (shape instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)shape;
                sb.append(rectangle.x).append(',').append(rectangle.y).append(',').append(rectangle.x + rectangle.width).append(',').append(rectangle.y + rectangle.height);
            } else if (shape instanceof Polygon) {
                Polygon polygon = (Polygon)shape;
                for (int i = 0; i < polygon.npoints; ++i) {
                    sb.append(polygon.xpoints[i]).append(',').append(polygon.ypoints[i]);
                    if (i == polygon.npoints - 1) continue;
                    sb.append(',');
                }
            }
            return sb.toString();
        }

        @Override
        public void mergeIntoOriginalShape(AuthorDocumentController controller, AuthorElement shapeElement) throws BadLocationException {
            controller.setAttribute("coords", new AttrValue(this.getCoords()), shapeElement);
        }

        @Override
        public Optional<Integer> getOriginalLayer() {
            int originalLayer = this.areaView.getOriginalLayer();
            return originalLayer == -1 ? Optional.empty() : Optional.of(originalLayer);
        }
    }
}

