/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml.imagemap;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.imagemap.EditImageMapCore;
import ro.sync.ecss.imagemap.SupportedFrameworks;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLEditImageMapCore
extends EditImageMapCore {
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    @Override
    public AuthorNode[] getNodesOfInterest(AuthorAccess authorAccess, AuthorNode interestNode, boolean doSurroundIfMissing) throws BadLocationException, AuthorOperationException {
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        AuthorNode nodeToEdit = interestNode;
        if (nodeToEdit == null) {
            nodeToEdit = this.getFullySelectedNode(documentController, editorAccess.getSelectionStart(), editorAccess.getSelectionEnd(), editorAccess.hasSelection());
        }
        if (nodeToEdit == null) {
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            nodeToEdit = documentController.getNodeAtOffset(caretOffset);
        }
        while (nodeToEdit != null && !this.isNodeOfInterest(nodeToEdit, "img") && !this.isNodeOfInterest(nodeToEdit, "map")) {
            nodeToEdit = nodeToEdit.getParent();
        }
        if (nodeToEdit != null && nodeToEdit.getType() == 0) {
            AuthorNode imgNode = null;
            AuthorNode mapNode = null;
            String name = ((AuthorElement)nodeToEdit).getLocalName();
            if ("img".equals(name)) {
                AuthorNode[] nodesByXPath;
                imgNode = nodeToEdit;
                AttrValue attrValue = ((AuthorElement)nodeToEdit).getAttribute("usemap");
                String mapName = null;
                if (attrValue != null && (mapName = attrValue.getValue()) != null && mapName.startsWith("#") && (nodesByXPath = documentController.findNodesByXPath("//map[namespace-uri() = 'http://www.w3.org/1999/xhtml'][@name = '" + (mapName = mapName.substring(1)) + "' or @id = '" + mapName + "']", nodeToEdit, true, true, true, false)) != null && nodesByXPath.length > 0) {
                    mapNode = nodesByXPath[0];
                }
                if (doSurroundIfMissing && mapNode == null) {
                    if (mapName == null) {
                        mapName = XHTMLEditImageMapCore.generateMapID();
                        documentController.setAttribute("usemap", new AttrValue("#" + mapName), (AuthorElement)imgNode);
                    }
                    StringBuilder mapElem = new StringBuilder("<map xmlns='").append(XHTML_NS).append("'");
                    mapElem.append(" name='").append(mapName).append("' id='").append(mapName).append("'/>");
                    AuthorDocumentFragment mapFrag = documentController.createNewDocumentFragmentInContext(mapElem.toString(), imgNode.getEndOffset() + 1);
                    documentController.insertFragment(imgNode.getEndOffset() + 1, mapFrag);
                    AuthorNode[] nodesByXPath2 = documentController.findNodesByXPath("//map[namespace-uri() = 'http://www.w3.org/1999/xhtml'][@name = '" + mapName + "' or @id = '" + mapName + "']", nodeToEdit, true, true, true, false);
                    if (nodesByXPath2 != null && nodesByXPath2.length > 0) {
                        mapNode = nodesByXPath2[0];
                    }
                }
            } else {
                AuthorNode[] nodesByXPath;
                String nameMap;
                mapNode = nodeToEdit;
                AttrValue attrValue = ((AuthorElement)nodeToEdit).getAttribute("name");
                if (attrValue == null) {
                    attrValue = ((AuthorElement)nodeToEdit).getAttribute("id");
                }
                if (attrValue != null && (nameMap = attrValue.getValue()) != null && (nodesByXPath = documentController.findNodesByXPath("//img[namespace-uri() = \"http://www.w3.org/1999/xhtml\"][@usemap = \"#" + nameMap + "\"]", nodeToEdit, true, true, true, false)) != null && nodesByXPath.length > 0) {
                    imgNode = nodesByXPath[0];
                }
            }
            if (imgNode != null && mapNode != null) {
                return new AuthorNode[]{imgNode, mapNode};
            }
        }
        return null;
    }

    private static String generateMapID() {
        return "map" + System.currentTimeMillis();
    }

    @Override
    public SupportedFrameworks getSupportedFramework(String namespaceURI) {
        return SupportedFrameworks.XHTML;
    }
}

