/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.EditedTablePropertiesInfo;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.SAPropertyPanel;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.util.ColorThemeUtilities;
import ro.sync.util.Resource;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SATablePropertiesCustomizerDialog
extends OKCancelDialog {
    private static final Logger logger = LoggerFactory.getLogger((String)SATablePropertiesCustomizerDialog.class.getName());
    private AuthorResourceBundle authorResourceBundle;
    private ColorThemeUtilities colorThemeUtilities;

    public SATablePropertiesCustomizerDialog(Frame parentFrame, AuthorResourceBundle authorResourceBundle, ColorThemeUtilities colorThemeUtilities) {
        super(parentFrame, authorResourceBundle.getMessage("Table_properties"), true);
        this.authorResourceBundle = authorResourceBundle;
        this.colorThemeUtilities = colorThemeUtilities;
    }

    public EditedTablePropertiesInfo getTablePropertiesInformation(EditedTablePropertiesInfo info) {
        EditedTablePropertiesInfo tableInfo = null;
        this.getContentPane().setLayout(new GridBagLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        List<TabInfo> categories = info.getCategories();
        EditedTablePropertiesInfo.TAB_TYPE selectedTab = info.getSelectedTab();
        int selectedTabIndex = 0;
        for (int i = 0; i < categories.size(); ++i) {
            TabInfo tabInfo = categories.get(i);
            SAPropertiesPanel panel = new SAPropertiesPanel(tabInfo.getProperties(), tabInfo.getContextInfo());
            tabbedPane.addTab(this.authorResourceBundle.getMessage(tabInfo.getTabKey()), panel);
            if (tabInfo.getTabKey().equals("Table") && selectedTab == EditedTablePropertiesInfo.TAB_TYPE.TABLE_TAB) {
                selectedTabIndex = i;
                continue;
            }
            if ((tabInfo.getTabKey().equals("Row") || tabInfo.getTabKey().equals("Rows")) && selectedTab == EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB) {
                selectedTabIndex = i;
                continue;
            }
            if ((tabInfo.getTabKey().equals("Column") || tabInfo.getTabKey().equals("Columns")) && selectedTab == EditedTablePropertiesInfo.TAB_TYPE.COLUMN_TAB) {
                selectedTabIndex = i;
                continue;
            }
            if (!tabInfo.getTabKey().equals("Cell") && !tabInfo.getTabKey().equals("Cells") || selectedTab != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) continue;
            selectedTabIndex = i;
        }
        if (!categories.isEmpty()) {
            tabbedPane.setSelectedIndex(selectedTabIndex);
        }
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.fill = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.insets = new Insets(0, 0, 10, 0);
        constr.gridwidth = 1;
        this.getContentPane().add((Component)tabbedPane, constr);
        this.setResizable(true);
        this.pack();
        this.setMinimumSize(new Dimension(this.getSize().width, this.getSize().height));
        this.setVisible(true);
        if (this.getResult() == 1) {
            ArrayList<TabInfo> modifications = new ArrayList<TabInfo>();
            for (int i = 0; i < tabbedPane.getComponentCount(); ++i) {
                SAPropertiesPanel panel = (SAPropertiesPanel)tabbedPane.getComponentAt(i);
                TabInfo tabInfo = categories.get(i);
                if (panel.getModifiedProperties().isEmpty()) continue;
                modifications.add(new TabInfo(tabInfo.getTabKey(), panel.getModifiedProperties(), tabInfo.getNodes()));
            }
            if (!modifications.isEmpty()) {
                tableInfo = new EditedTablePropertiesInfo(modifications);
            }
        }
        return tableInfo;
    }

    class SAPropertiesPanel
    extends JPanel
    implements PropertySelectionController {
        private final List<SAPropertyPanel> propertyPanels = new ArrayList<SAPropertyPanel>();
        private final Map<String, JLabel> previews = new HashMap<String, JLabel>();

        public SAPropertiesPanel(List<TableProperty> properties, String contextInfo) {
            GridBagLayout mgr = new GridBagLayout();
            this.setLayout(mgr);
            LinkedHashMap<String, ArrayList<TableProperty>> groups = new LinkedHashMap<String, ArrayList<TableProperty>>();
            for (int i = 0; i < properties.size(); ++i) {
                TableProperty property = properties.get(i);
                String currentGroup = property.getParentGroup();
                ArrayList<TableProperty> list = (ArrayList<TableProperty>)groups.get(currentGroup);
                if (list == null) {
                    list = new ArrayList<TableProperty>();
                }
                list.add(property);
                groups.put(currentGroup, list);
                this.previews.put(currentGroup, new JLabel());
            }
            GridBagConstraints constr = new GridBagConstraints();
            constr.gridx = 0;
            constr.gridy = 0;
            constr.anchor = 17;
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.insets = new Insets(3, 4, 2, 4);
            Set groupSet = groups.keySet();
            boolean isFirstElement = true;
            for (String key : groupSet) {
                List props = (List)groups.get(key);
                this.addGroup(constr, isFirstElement, key, props);
                if (!isFirstElement) continue;
                isFirstElement = false;
            }
            if (contextInfo != null) {
                constr.gridx = 0;
                ++constr.gridy;
                constr.anchor = 17;
                constr.fill = 0;
                constr.insets.top += 7;
                constr.insets.left += 10;
                constr.weightx = 0.0;
                constr.weighty = 0.0;
                constr.gridwidth = 2;
                this.add((Component)new JLabel(contextInfo), constr);
            }
            constr.gridx = 0;
            ++constr.gridy;
            constr.fill = 1;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.gridwidth = 2;
            this.add((Component)new JLabel(""), constr);
            if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities == null || !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isDarkTheme()) {
                this.setOpaque(false);
            }
        }

        private void addGroup(GridBagConstraints constr, boolean isFirstElement, String keyTitle, List<TableProperty> properties) {
            JPanel groupPanel = new JPanel(new GridBagLayout());
            int maxColNr = 1;
            if (properties.size() == 1 && properties.get(0).getGuiType() == GuiElements.COMBOBOX) {
                TitledBorder titledBorder = BorderFactory.createTitledBorder("");
                TitledBorder titledBorderWithTitle = BorderFactory.createTitledBorder(SATablePropertiesCustomizerDialog.this.authorResourceBundle.getMessage(keyTitle));
                Insets borderInsets = titledBorder.getBorderInsets(groupPanel);
                groupPanel.setBorder(BorderFactory.createEmptyBorder(borderInsets.top, titledBorderWithTitle.getBorderInsets((Component)groupPanel).left, borderInsets.bottom, borderInsets.right));
            } else {
                groupPanel.setBorder(BorderFactory.createTitledBorder(SATablePropertiesCustomizerDialog.this.authorResourceBundle.getMessage(keyTitle)));
            }
            if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities == null || !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isDarkTheme()) {
                groupPanel.setOpaque(false);
            }
            GridBagConstraints constr1 = new GridBagConstraints();
            constr1.gridx = 0;
            constr1.anchor = 17;
            constr1.insets.top += 2;
            for (int i = 0; i < properties.size(); ++i) {
                if (properties.get(i).getGuiType() == GuiElements.COMBOBOX) {
                    maxColNr = 2;
                } else if (1 > maxColNr) {
                    maxColNr = 1;
                }
                SAPropertyPanel p = new SAPropertyPanel(groupPanel, constr1, properties.get(i), SATablePropertiesCustomizerDialog.this.authorResourceBundle, this, 0, i == 0);
                this.propertyPanels.add(p);
            }
            constr1.fill = 1;
            constr1.weightx = 1.0;
            constr1.weighty = 1.0;
            constr.gridx = 0;
            constr1.gridwidth = maxColNr;
            groupPanel.add((Component)new JLabel(""), constr1);
            constr.insets.top = isFirstElement ? 5 : 0;
            constr.anchor = 17;
            constr.gridx = 0;
            constr.gridwidth = 1;
            constr.fill = 1;
            constr.weightx = 1.0;
            constr.weighty = 0.0;
            this.add((Component)groupPanel, constr);
            JPanel previewPanel = new JPanel(new GridBagLayout());
            previewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(SATablePropertiesCustomizerDialog.this.authorResourceBundle.getMessage("Preview")), BorderFactory.createEmptyBorder(0, 0, 6, 0)));
            if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities == null || !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isDarkTheme()) {
                previewPanel.setOpaque(false);
            }
            GridBagConstraints previewConstr = new GridBagConstraints();
            previewConstr.gridx = 0;
            previewConstr.gridy = 0;
            previewConstr.fill = 0;
            previewConstr.anchor = 10;
            this.previews.get(keyTitle).setFocusable(false);
            this.previews.get(keyTitle).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            previewPanel.add((Component)this.previews.get(keyTitle), previewConstr);
            previewPanel.setPreferredSize(new Dimension(150, previewPanel.getPreferredSize().height));
            previewPanel.setMinimumSize(new Dimension(150, previewPanel.getMinimumSize().height));
            ++constr.gridx;
            constr.fill = 1;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            this.add((Component)previewPanel, constr);
            ++constr.gridy;
        }

        @Override
        public void selectionChanged(TableProperty property, String newValue) throws AuthorOperationException {
            StringBuilder iconRelativePath = new StringBuilder();
            String group = property.getParentGroup();
            if ("colsep".equalsIgnoreCase(property.getAttributeName()) || "rowsep".equalsIgnoreCase(property.getAttributeName())) {
                String colsepVal = "<not set>";
                String rowsepVal = "<not set>";
                boolean checkRowsep = true;
                if ("colsep".equalsIgnoreCase(property.getAttributeName())) {
                    colsepVal = newValue;
                } else {
                    rowsepVal = newValue;
                    checkRowsep = false;
                }
                for (int i = 0; i < this.propertyPanels.size(); ++i) {
                    SAPropertyPanel tableProperty = this.propertyPanels.get(i);
                    if (checkRowsep && "rowsep".equalsIgnoreCase(tableProperty.getTableProperty().getAttributeName())) {
                        rowsepVal = tableProperty.getCurrentlySelectedValue();
                        continue;
                    }
                    if (checkRowsep || !"colsep".equalsIgnoreCase(tableProperty.getTableProperty().getAttributeName())) continue;
                    colsepVal = tableProperty.getCurrentlySelectedValue();
                }
                if ("1".equals(colsepVal) && "1".equals(rowsepVal)) {
                    iconRelativePath.append("/images/table-properties/ColRowSep.png");
                } else if ("1".equals(colsepVal)) {
                    iconRelativePath.append("/images/table-properties/ColSep.png");
                } else if ("1".equals(rowsepVal)) {
                    iconRelativePath.append("/images/table-properties/RowSep.png");
                } else {
                    iconRelativePath.append("/images/table-properties/EmptyIcon.png");
                }
            } else {
                String iconPath = null;
                iconPath = property.getIcons().get(newValue);
                if (iconPath != null) {
                    iconRelativePath.append(iconPath);
                } else {
                    iconRelativePath.append("/images/table-properties/EmptyIcon.png");
                }
            }
            JLabel iconLabel = this.previews.get(group);
            if (iconLabel != null) {
                BufferedImage bufferedImage = null;
                URL imageURL = Resource.getResource((String)iconRelativePath.toString());
                try {
                    bufferedImage = (BufferedImage)SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getImageInverter().loadImage(imageURL);
                }
                catch (IOException e) {
                    throw new AuthorOperationException(e.getMessage(), (Throwable)e);
                }
                if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isHighContrastTheme() && !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isHighContrastWhiteTheme()) {
                    try {
                        bufferedImage = (BufferedImage)SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getImageInverter().invertImage((Object)bufferedImage);
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                iconLabel.setIcon(imageIcon);
                iconLabel.repaint();
            }
        }

        public List<TableProperty> getModifiedProperties() {
            ArrayList<TableProperty> properties = new ArrayList<TableProperty>();
            for (int i = 0; i < this.propertyPanels.size(); ++i) {
                TableProperty modifiedProperty = this.propertyPanels.get(i).getModifiedProperty();
                if (modifiedProperty == null) continue;
                properties.add(modifiedProperty);
            }
            return properties;
        }
    }
}

