/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorTableAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SplitCellAboveBelowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class DeleteColumnOperationBase
extends AbstractTableOperation {
    protected AuthorElement tableElem = null;
    protected List<Integer> deletedColumnsIndices = null;

    public DeleteColumnOperationBase(AuthorTableHelper documentTypeHelper) {
        super(documentTypeHelper);
    }

    /*
     * WARNING - void declaration
     */
    public boolean performDeleteColumn(AuthorAccess authorAccess, List<ContentInterval> columnIntervals, boolean placeCaretInNextCell) throws AuthorOperationException {
        boolean handled = false;
        this.tableElem = null;
        int rowIndex = -1;
        this.deletedColumnsIndices = new ArrayList<Integer>();
        ArrayList<Position> caretOffsetsForDeleteColumns = new ArrayList<Position>();
        try {
            int tableRowCount;
            AuthorTableAccess tableAccess = authorAccess.getTableAccess();
            AuthorDocumentController documentController = authorAccess.getDocumentController();
            if (columnIntervals != null && !columnIntervals.isEmpty()) {
                ContentInterval firstInterval = columnIntervals.get(0);
                this.tableElem = this.getElementAncestor(documentController.getNodeAtOffset(firstInterval.getStartOffset()), 2);
                if (!this.canDeleteColumn()) {
                    return false;
                }
                if (this.tableElem != null) {
                    AuthorTableCellSpanProvider spanProvider = this.tableHelper.getTableCellSpanProvider(this.tableElem);
                    tableRowCount = tableAccess.getTableRowCount(this.tableElem);
                    int n = tableAccess.getTableNumberOfColumns(this.tableElem);
                    ArrayList<AuthorElement> selectedCells = new ArrayList<AuthorElement>();
                    block2: for (int i = 0; i < tableRowCount; ++i) {
                        block3: for (int j = 0; j < n; ++j) {
                            AuthorElement currentCell = tableAccess.getTableCellAt(i, j, this.tableElem);
                            if (currentCell == null) continue;
                            Iterator<ContentInterval> selectionIterator = columnIntervals.iterator();
                            while (selectionIterator.hasNext()) {
                                ContentInterval selectionInterval = selectionIterator.next();
                                if (currentCell.getStartOffset() != selectionInterval.getStartOffset() || currentCell.getEndOffset() != selectionInterval.getEndOffset() - 1) continue;
                                selectedCells.add(currentCell);
                                Integer colSpan = spanProvider.getColSpan(currentCell);
                                if (colSpan != null && colSpan > 1) {
                                    selectionIterator.remove();
                                    continue block3;
                                }
                                caretOffsetsForDeleteColumns.add(documentController.createPositionInContent(currentCell.getStartOffset() + 1));
                                break block2;
                            }
                        }
                    }
                    if (caretOffsetsForDeleteColumns.isEmpty()) {
                        int i;
                        List<Integer> commonCols = new ArrayList<Integer>();
                        int[] indices = tableAccess.getTableColSpanIndices((AuthorElement)selectedCells.get(0));
                        for (i = indices[0]; i <= indices[1]; ++i) {
                            commonCols.add(i);
                        }
                        for (i = 1; i < selectedCells.size(); ++i) {
                            commonCols = DeleteColumnOperationBase.computeCommonCols(commonCols, tableAccess.getTableColSpanIndices((AuthorElement)selectedCells.get(i)));
                        }
                        int referenceColumn = (Integer)commonCols.get(0);
                        AuthorElement referenceCell = null;
                        for (AuthorElement cell : selectedCells) {
                            if (tableAccess.getTableCellIndex(cell)[1] != referenceColumn) continue;
                            referenceCell = cell;
                            break;
                        }
                        if (referenceCell != null) {
                            caretOffsetsForDeleteColumns.add(documentController.createPositionInContent(referenceCell.getStartOffset() + 1));
                        }
                    }
                }
            } else if (authorAccess.getEditorAccess().hasSelection()) {
                HashMap<Integer, ArrayList<AuthorElement>> mapColumnIndexToSelCells = new HashMap<Integer, ArrayList<AuthorElement>>();
                this.tableElem = this.getElementAncestor(documentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()), 2);
                List<AuthorElement> selectedCells = TableOperationsUtil.getTableElementsOfTypeFromSelection(authorAccess, 6, TableOperationsUtil.createTableHelper(this.tableHelper), this.tableElem);
                for (AuthorElement authorElement : selectedCells) {
                    int[] cellIndices = tableAccess.getTableCellIndex(authorElement);
                    if (cellIndices == null) continue;
                    int columnNumber = cellIndices[1];
                    ArrayList<AuthorElement> cellsList = (ArrayList<AuthorElement>)mapColumnIndexToSelCells.get(columnNumber);
                    if (cellsList == null) {
                        cellsList = new ArrayList<AuthorElement>(1);
                        mapColumnIndexToSelCells.put(columnNumber, cellsList);
                    }
                    cellsList.add(authorElement);
                }
                Set columnsToDelete = mapColumnIndexToSelCells.keySet();
                for (Integer columnToDelete : columnsToDelete) {
                    List cells = (List)mapColumnIndexToSelCells.get(columnToDelete);
                    AuthorElement firstCell = (AuthorElement)cells.get(0);
                    int offset = firstCell.getStartOffset() + 1;
                    caretOffsetsForDeleteColumns.add(documentController.createPositionInContent(offset));
                }
            } else {
                caretOffsetsForDeleteColumns.add(documentController.createPositionInContent(authorAccess.getEditorAccess().getCaretOffset()));
                this.tableElem = this.getElementAncestor(documentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()), 2);
            }
            for (int i = 0; i < caretOffsetsForDeleteColumns.size() - 1; ++i) {
                for (int j = i + 1; j < caretOffsetsForDeleteColumns.size(); ++j) {
                    if (((Position)caretOffsetsForDeleteColumns.get(i)).getOffset() >= ((Position)caretOffsetsForDeleteColumns.get(j)).getOffset()) continue;
                    Position aux = (Position)caretOffsetsForDeleteColumns.get(i);
                    caretOffsetsForDeleteColumns.set(i, (Position)caretOffsetsForDeleteColumns.get(j));
                    caretOffsetsForDeleteColumns.set(j, aux);
                }
            }
            int initialColsNo = tableAccess.getTableNumberOfColumns(this.tableElem);
            for (Position caretPosition : caretOffsetsForDeleteColumns) {
                AuthorElement caretCell;
                authorAccess.getEditorAccess().setCaretPosition(caretPosition.getOffset());
                AuthorNode authorNode = documentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
                AuthorElement currentCellElem = this.getElementAncestor(authorNode, 0);
                AuthorElement currentRowElem = this.getElementAncestor(authorNode, 1);
                this.tableElem = this.getElementAncestor(authorNode, 2);
                if (currentCellElem == null || this.tableElem == null) continue;
                int[] cellIndices = tableAccess.getTableCellIndex(currentCellElem);
                if (cellIndices == null) {
                    throw new AuthorOperationException("Cannot obtain the index of cell in table.");
                }
                rowIndex = cellIndices[0];
                this.deletedColumnsIndices.add(cellIndices[1]);
                ArrayList<int[]> intervals = new ArrayList<int[]>();
                int rowsNumber = tableAccess.getTableRowCount(this.tableElem);
                AuthorTableCellSpanProvider spanProvider = this.tableHelper.getTableCellSpanProvider(this.tableElem);
                for (int i = 0; i < rowsNumber; ++i) {
                    int rowSpan;
                    AuthorElement cell = tableAccess.getTableCellAt(i, this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1).intValue(), this.tableElem);
                    if (cell == null) continue;
                    int[] spanIndices = tableAccess.getTableColSpanIndices(cell);
                    Integer colSpanInteger = spanProvider.getColSpan(cell);
                    Integer rowSpanInteger = spanProvider.getRowSpan(cell);
                    int colSpan = colSpanInteger != null ? colSpanInteger : 1;
                    int n = rowSpan = rowSpanInteger != null ? rowSpanInteger : 1;
                    if (colSpan == 1) {
                        intervals.add(new int[]{cell.getStartOffset(), cell.getEndOffset()});
                    } else {
                        this.updateTableColSpan(authorAccess, spanProvider, cell, spanIndices[0] + 1, spanIndices[1] + 1);
                    }
                    if (rowSpan <= 1) continue;
                    i += rowSpan - 1;
                }
                if (!intervals.isEmpty()) {
                    int[] startOffsets = new int[intervals.size()];
                    int[] endOffsets = new int[intervals.size()];
                    for (int i = 0; i < startOffsets.length; ++i) {
                        int[] interval = (int[])intervals.get(i);
                        startOffsets[i] = interval[0];
                        endOffsets[i] = interval[1];
                    }
                    documentController.multipleDelete(this.tableElem, startOffsets, endOffsets);
                }
                if (this.deletedColumnsIndices != null && !this.deletedColumnsIndices.isEmpty()) {
                    this.updateColspec(authorAccess, this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1));
                    this.updateAppliableColWidthsNumber(authorAccess, this.tableElem, this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1));
                }
                if ((caretCell = tableAccess.getTableCellAt(rowIndex, this.deletedColumnsIndices.get(this.deletedColumnsIndices.size() - 1).intValue(), this.tableElem)) != null) {
                    authorAccess.getEditorAccess().setCaretPosition(caretCell.getStartOffset() + (placeCaretInNextCell ? 1 : 0));
                } else {
                    authorAccess.getEditorAccess().setCaretPosition(currentRowElem.getEndOffset() - 1);
                }
                handled = true;
            }
            if (authorAccess.getTableAccess().getTableNumberOfColumns(this.tableElem) == 0) {
                AuthorNode tableElementForDeletion = this.tableHelper.getTableElementForDeletion((AuthorNode)this.tableElem);
                if (tableElementForDeletion != null) {
                    documentController.deleteNode(tableElementForDeletion);
                    this.tableElem = null;
                }
            } else {
                void var12_23;
                DeleteRowOperationBase deleteRowOperation = new DeleteRowOperationBase(this.tableHelper){

                    @Override
                    protected SplitCellAboveBelowOperationBase createSplitCellOperation() {
                        return null;
                    }
                };
                tableRowCount = tableAccess.getTableRowCount(this.tableElem);
                int n = tableRowCount - 1;
                while (var12_23 >= 0) {
                    AuthorElement tableRow = tableAccess.getTableRow((int)var12_23, this.tableElem);
                    if (tableRow != null && tableRow.getStartOffset() + 1 == tableRow.getEndOffset()) {
                        deleteRowOperation.performDeleteRows(authorAccess, tableRow.getStartOffset(), tableRow.getEndOffset() + 1);
                    }
                    --var12_23;
                }
            }
            if (this.tableElem != null) {
                this.tableHelper.updateTableColumnNumber(authorAccess, this.tableElem, initialColsNo - caretOffsetsForDeleteColumns.size());
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
        return handled;
    }

    private static List<Integer> computeCommonCols(List<Integer> commonCols, int[] colSpanIndices) {
        ArrayList<Integer> aux = new ArrayList<Integer>();
        for (Integer col : commonCols) {
            if (col < colSpanIndices[0] || col > colSpanIndices[1]) continue;
            aux.add(col);
        }
        return aux;
    }

    protected void updateColspec(AuthorAccess authorAccess, Integer deletedColumnIndex) {
    }

    protected void updateAppliableColWidthsNumber(AuthorAccess authorAccess, AuthorElement tableElem, int deletedColumnIndex) {
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        List selectionIntervals = null;
        AuthorSelectionModel selectionModel = authorAccess.getEditorAccess().getAuthorSelectionModel();
        SelectionInterpretationMode mode = selectionModel.getSelectionInterpretationMode();
        if (mode == SelectionInterpretationMode.TABLE_COLUMN) {
            selectionIntervals = selectionModel.getSelectionIntervals();
        }
        this.performDeleteColumn(authorAccess, selectionIntervals, true);
    }

    protected abstract void updateTableColSpan(AuthorAccess var1, AuthorTableCellSpanProvider var2, AuthorElement var3, int var4, int var5) throws AuthorOperationException;

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Delete the current table column.";
    }

    protected boolean canDeleteColumn() {
        return true;
    }
}

