/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.component.AuthorSchemaAwareOptions;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.exml.options.Options;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public abstract class InsertListOperation
implements AuthorOperation {
    protected static final ArgumentDescriptor SCHEMA_AWARE_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("schemaAware", 3, "Controls if the insertion is schema aware or not. When the schema aware is enabled and the fragments insertion is not allowed, a dialog will be shown, proposing solutions, like:\n - insert the fragments inside a new element. The name of the element to wrap the fragments in is computed by analyzing the left or right siblings;\n - split an ancestor of the node at insertion offset and insert the fragments between the resulted elements;\n - insert the fragments somewhere in the proximity of the insertion offset (left or right without skipping content);\nNote: if a selection exists, the surround with fragment operation is not schema aware.\nCan be: true, false. Default value is true.", new String[]{"true", "false"}, "true");
    public static final String CONVERT_ELEMENT_AT_CARET_ARGUMENT = "convertElementAtCaret";
    private static final String ARG_VALUE_AUTO = "auto";
    protected static final ArgumentDescriptor CONVERT_ELEMENT_AT_CARET_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("convertElementAtCaret", 3, "Controls whether a new list is inserted or the element at caret is converted to list, if there is no selection in the document.\n Can be: true, false or auto.\nDefault value is auto meaning that the element at caret is converted only if the option toshow content completion when pressing Enter is disabled.", new String[]{"true", "false", "auto"}, "auto");
    public static final String LIST_TYPE_ARGUMENT = "listType";
    private static final Logger logger = LoggerFactory.getLogger((String)InsertListOperation.class.getName());
    protected AuthorAccess authorAccess;
    protected String listType;

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        this.authorAccess = authorAccess;
        Object schemaAwareArgumentValue = args.getArgumentValue("schemaAware");
        boolean schemaAware = !"false".equals(schemaAwareArgumentValue);
        this.listType = (String)args.getArgumentValue(LIST_TYPE_ARGUMENT);
        String convertElementAtCaretArgValue = (String)args.getArgumentValue(CONVERT_ELEMENT_AT_CARET_ARGUMENT);
        List<ContentInterval> intervals = this.getIntervalsToConvert(convertElementAtCaretArgValue);
        List<CommonsOperationsUtil.SelectedFragmentInfo> fragmentsToConvert = this.getFragmentsToConvert(authorAccess, intervals);
        if (fragmentsToConvert != null) {
            Optional<AuthorElement> selectedList = this.getSelectedList(intervals);
            Optional<Map> listAttributes = selectedList.map(list -> CommonsOperationsUtil.getAttributes((AuthorNode)list, true));
            List<Position> positions = CommonsOperationsUtil.removeIntervals(authorAccess, intervals);
            Optional<Map<String, String>> attributesOfRemovedList = this.removeEmptyListElements(authorAccess, positions);
            if (!listAttributes.isPresent()) {
                listAttributes = attributesOfRemovedList;
            }
            InsertListOperation.deleteEmptyFragments(fragmentsToConvert);
            StringBuilder xmlFragment = this.getListXMLFragment((String)args.getArgumentValue(LIST_TYPE_ARGUMENT), listAttributes.orElse(Collections.emptyMap()), fragmentsToConvert.size(), authorAccess);
            SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment.toString(), authorAccess.getEditorAccess().getCaretOffset(), 7, true);
            Integer offset = (Integer)result.getResult("result.id.handle.insert.fragment.offset");
            this.insertFragmentsInListAtOffset(authorAccess, fragmentsToConvert, offset);
            CommonsOperationsUtil.removeEmptyElements(authorAccess, positions);
        } else {
            this.insertAtCaret(authorAccess, args, schemaAware);
        }
    }

    private Optional<Map<String, String>> removeEmptyListElements(AuthorAccess authorAccess, List<Position> positions) {
        Optional<Map<String, String>> listAttributes = Optional.empty();
        AuthorDocumentController controller = authorAccess.getDocumentController();
        AuthorElement rootElement = controller.getAuthorDocumentNode().getRootElement();
        try {
            for (int i = 0; i < positions.size(); ++i) {
                AuthorNode node = controller.getNodeAtOffset(positions.get(i).getOffset() + 1);
                while (node != null && node != rootElement) {
                    AuthorNode parentNode = node.getParent();
                    if (this.isEmptyListElement(node)) {
                        if (!listAttributes.isPresent() && this.isList(node)) {
                            Map<String, String> attributes = CommonsOperationsUtil.getAttributes(node, true);
                            listAttributes = Optional.of(attributes != null ? attributes : Collections.emptyMap());
                        }
                        controller.deleteNode(node);
                        positions.remove(controller.createPositionInContent(node.getStartOffset()));
                    }
                    node = parentNode;
                }
            }
        }
        catch (BadLocationException e1) {
            logger.debug(e1.getMessage(), (Throwable)e1);
        }
        return listAttributes;
    }

    private Optional<AuthorElement> getSelectedList(List<ContentInterval> intervals) {
        return intervals.stream().map(this::getSelectedList).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<AuthorElement> getSelectedList(ContentInterval interval) {
        try {
            return this.authorAccess.getDocumentController().getNodesToSelect(interval.getStartOffset(), interval.getEndOffset()).stream().filter(this::isList).map(AuthorElement.class::cast).findFirst();
        }
        catch (BadLocationException e) {
            return Optional.empty();
        }
    }

    private void insertFragmentsInListAtOffset(AuthorAccess authorAccess, List<CommonsOperationsUtil.SelectedFragmentInfo> fragmentsToConvert, int offset) {
        try {
            AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(offset + 1);
            this.insertContent(authorAccess, nodeAtOffset, fragmentsToConvert);
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static void deleteEmptyFragments(List<CommonsOperationsUtil.SelectedFragmentInfo> fragmentsToConvert) {
        int remaining = fragmentsToConvert.size();
        Iterator<CommonsOperationsUtil.SelectedFragmentInfo> iter = fragmentsToConvert.iterator();
        while (iter.hasNext()) {
            CommonsOperationsUtil.SelectedFragmentInfo fragmentInfo = iter.next();
            if (!fragmentInfo.getSelectedFragment().isEmpty() || remaining <= 1) continue;
            iter.remove();
            --remaining;
        }
    }

    private boolean shoudConvertElementAtCaret(String convertElement, boolean isAtStart) {
        boolean shouldConvert;
        if ("true".equals(convertElement)) {
            shouldConvert = true;
        } else if (ARG_VALUE_AUTO.equals(convertElement)) {
            if (isAtStart) {
                shouldConvert = true;
            } else {
                AuthorSchemaAwareOptions schemaAwareOptions = (AuthorSchemaAwareOptions)Options.getInstance().getObjectProperty("author.editing.mode");
                EditingSessionContext editingContext = this.authorAccess.getEditorAccess().getEditingContext();
                shouldConvert = !schemaAwareOptions.isShowAvailableCCItemsOnEnter() || "false".equals(editingContext.getAttribute("ccOnEnter"));
            }
        } else {
            shouldConvert = false;
        }
        return shouldConvert;
    }

    private List<CommonsOperationsUtil.SelectedFragmentInfo> getFragmentsToConvert(AuthorAccess authorAccess, List<ContentInterval> intervals) throws AuthorOperationException {
        List<CommonsOperationsUtil.SelectedFragmentInfo> fragmentsToConvert;
        block4: {
            fragmentsToConvert = null;
            if (!intervals.isEmpty()) {
                try {
                    CommonsOperationsUtil.ConversionElementHelper elementsChecker = this.getConversionElementsChecker();
                    fragmentsToConvert = CommonsOperationsUtil.getFragmentsForConversions(authorAccess, elementsChecker, intervals);
                }
                catch (BadLocationException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                catch (AuthorOperationException e) {
                    if (!authorAccess.getEditorAccess().hasSelection()) break block4;
                    throw e;
                }
            }
        }
        return fragmentsToConvert;
    }

    private List<ContentInterval> getIntervalsToConvert(String convertElementAtCaretArgValue) {
        CommonsOperationsUtil.ConversionElementHelper elementsChecker = this.getConversionElementsChecker();
        AuthorEditorAccess editorAccess = this.authorAccess.getEditorAccess();
        AuthorSelectionModel authorSelectionModel = editorAccess.getAuthorSelectionModel();
        List<ContentInterval> intervals = Collections.emptyList();
        if (authorSelectionModel.hasSelection()) {
            intervals = authorSelectionModel.getSelectionIntervals().stream().map(interval -> {
                int[] balanced = editorAccess.getBalancedSelection(interval.getStartOffset(), interval.getEndOffset());
                return new ContentInterval(balanced[0], balanced[1]);
            }).collect(Collectors.toList());
        } else {
            boolean isAtStart;
            Optional<AuthorNode> element = this.getElementAtCaretToConvert(this.authorAccess, elementsChecker);
            if (element.isPresent() && this.shoudConvertElementAtCaret(convertElementAtCaretArgValue, isAtStart = InsertListOperation.containsOnlyStartSentinels(this.authorAccess, element.get().getStartOffset(), editorAccess.getCaretOffset()))) {
                intervals = Collections.singletonList(new ContentInterval(element.get().getStartOffset(), element.get().getEndOffset() + 1));
            }
        }
        return intervals;
    }

    private static boolean containsOnlyStartSentinels(AuthorAccess authorAccess, int startOffset, int endOffset) {
        boolean onlySentinels = true;
        AuthorDocumentController controller = authorAccess.getDocumentController();
        try {
            for (int offset = startOffset; offset < endOffset; ++offset) {
                OffsetInformation offsetInfo = controller.getContentInformationAtOffset(offset);
                if (offsetInfo.getPositionType() == 1) continue;
                onlySentinels = false;
                break;
            }
        }
        catch (BadLocationException e) {
            logger.debug((Object)e, (Throwable)e);
            onlySentinels = false;
        }
        return onlySentinels;
    }

    public Optional<AuthorNode> getElementAtCaretToConvert(AuthorAccess authorAccess, CommonsOperationsUtil.ConversionElementHelper helper) {
        Optional<AuthorNode> elementToConvert = Optional.empty();
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        AuthorDocumentController controller = authorAccess.getDocumentController();
        try {
            for (AuthorNode candidate = controller.getNodeAtOffset(caretOffset); candidate != null; candidate = candidate.getParent()) {
                boolean canBeConverted;
                Styles styles = authorAccess.getEditorAccess().getStyles(candidate);
                String display = styles.getDisplay();
                if (!"block".equals(display) && !"list-item".equals(display) || !(canBeConverted = InsertListOperation.canBeConverted(authorAccess, helper, candidate))) continue;
                if ("list-item".equals(display)) {
                    candidate = candidate.getParent();
                }
                elementToConvert = Optional.of(candidate);
                break;
            }
        }
        catch (BadLocationException e) {
            logger.debug((Object)e, (Throwable)e);
        }
        return elementToConvert;
    }

    private static boolean canBeConverted(AuthorAccess authorAccess, CommonsOperationsUtil.ConversionElementHelper helper, AuthorNode candidate) {
        boolean canBeConverted = false;
        try {
            helper.blockContentMustBeConverted(candidate, authorAccess);
            canBeConverted = true;
        }
        catch (AuthorOperationException authorOperationException) {
            // empty catch block
        }
        return canBeConverted;
    }

    private boolean isEmptyListElement(AuthorNode node) {
        return this.isListElement(node) && node.getStartOffset() == node.getEndOffset() - 1;
    }

    protected boolean isListElement(AuthorNode node) {
        return false;
    }

    protected abstract boolean isList(AuthorNode var1);

    private void insertAtCaret(AuthorAccess authorAccess, ArgumentsMap args, boolean schemaAware) throws AuthorOperationException {
        String listType = (String)args.getArgumentValue(LIST_TYPE_ARGUMENT);
        String parentListType = null;
        try {
            AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            parentListType = this.getParentListType(nodeAtOffset);
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        String xmlFragment = this.getXMLFragment(authorAccess, listType, parentListType);
        if (parentListType != null) {
            int insertionOffset = authorAccess.getEditorAccess().getCaretOffset();
            if (!schemaAware) {
                authorAccess.getDocumentController().insertXMLFragment(xmlFragment, (String)null, "Inside as first child");
            } else {
                Integer off;
                SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment, (String)null, "Inside as first child");
                if (result != null && (off = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) != null) {
                    insertionOffset = off;
                }
            }
            try {
                int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                authorAccess.getEditorAccess().goToNextEditablePosition(insertionOffset, caretOffset);
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else {
            CommonsOperationsUtil.surroundWithFragment(authorAccess, schemaAware, xmlFragment);
        }
    }

    protected abstract String getParentListType(AuthorNode var1);

    protected abstract CommonsOperationsUtil.ConversionElementHelper getConversionElementsChecker();

    protected abstract void insertContent(AuthorAccess var1, AuthorNode var2, List<CommonsOperationsUtil.SelectedFragmentInfo> var3);

    protected abstract String getNamespace();

    protected abstract String getXMLFragment(AuthorAccess var1, String var2, String var3);

    protected abstract StringBuilder getListXMLFragment(String var1, Map<String, String> var2, int var3, AuthorAccess var4);

    protected abstract String getListTypeDescription(String var1);
}

