/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.imagemap.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.imagemap.operations.NewShapeDescriptor;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
@WebappCompatible
public abstract class UpdateImageMapOperationBase
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)UpdateImageMapOperationBase.class.getName());
    public static final String ARGUMENT_SHAPES = "shapes";
    protected static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("shapes", 0, "An SVG with the shapes to be used to update the Image Map at caret.\nIn order to match shapes from the SVG with shapes in the document, this operation needs the \"data-original-layer\" attribute of the SVG element to match the layer of the shape in the document.")};

    public String getDescription() {
        return "Updates an image map with shape information from an SVG";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        int caretOffset;
        AuthorEditorAccess editorAccess;
        String svgText = (String)args.getArgumentValue(ARGUMENT_SHAPES);
        AuthorDocumentController controller = authorAccess.getDocumentController();
        AuthorElement currentImageMap = this.getNodeToReplace(controller, editorAccess = authorAccess.getEditorAccess(), caretOffset = editorAccess.getCaretOffset());
        if (currentImageMap != null) {
            List<? extends NewShapeDescriptor> newShapesList = this.getNewShapesList(svgText);
            controller.beginCompoundEdit();
            try {
                this.mergeImageMaps(controller, currentImageMap, newShapesList);
            }
            catch (Exception e) {
                throw new AuthorOperationException("Cannot obtain the image map from internal model!", (Throwable)e);
            }
            finally {
                controller.endCompoundEdit();
            }
        } else {
            throw new AuthorOperationException("Could not identify Image Map!");
        }
    }

    protected abstract AuthorElement getImageMapElement(AuthorElement var1);

    protected abstract List<? extends NewShapeDescriptor> getNewShapesList(String var1) throws AuthorOperationException;

    protected abstract AuthorElement[] getExistingShapesList(AuthorElement var1);

    private void mergeImageMaps(AuthorDocumentController controller, AuthorElement currentImageMap, List<? extends NewShapeDescriptor> newShapeElements) throws AuthorOperationException {
        Map<Integer, AuthorElement> shapeElements = UpdateImageMapOperationBase.getShapesMap(this.getExistingShapesList(currentImageMap));
        List newShapes = newShapeElements.stream().map(newShapeElement -> this.getXmlForNewShape(controller, shapeElements, (NewShapeDescriptor)newShapeElement)).filter(Objects::nonNull).collect(Collectors.toList());
        int insertionPoint = currentImageMap.getEndOffset();
        for (AuthorElement shapeElement : shapeElements.values()) {
            insertionPoint = Math.min(insertionPoint, shapeElement.getStartOffset());
            controller.deleteNode((AuthorNode)shapeElement);
        }
        Collections.reverse(newShapes);
        for (String xmlShape : newShapes) {
            controller.insertXMLFragment(xmlShape, insertionPoint);
        }
    }

    private String getXmlForNewShape(AuthorDocumentController controller, Map<Integer, AuthorElement> shapeElements, NewShapeDescriptor newShapeElement) {
        String newShapeXml;
        Optional<Integer> originalLayer = newShapeElement.getOriginalLayer();
        if (originalLayer.isPresent()) {
            try {
                AuthorElement originalShape = shapeElements.get(originalLayer.get());
                newShapeElement.mergeIntoOriginalShape(controller, originalShape);
                newShapeXml = controller.serializeFragmentToXML(controller.createDocumentFragment((AuthorNode)originalShape, true));
            }
            catch (BadLocationException e) {
                logger.warn("Unable to merge shapes.", (Throwable)e);
                newShapeXml = newShapeElement.serializeToXml().orElse(null);
            }
        } else {
            newShapeXml = newShapeElement.serializeToXml().orElse(null);
        }
        return newShapeXml;
    }

    private static Map<Integer, AuthorElement> getShapesMap(AuthorElement[] imageMapElements) {
        HashMap<Integer, AuthorElement> map = new HashMap<Integer, AuthorElement>();
        for (int i = 0; i < imageMapElements.length; ++i) {
            map.put(i, imageMapElements[i]);
        }
        return map;
    }

    private AuthorElement getNodeToReplace(AuthorDocumentController controller, AuthorEditorAccess editorAccess, int caretOffset) throws AuthorOperationException {
        AuthorElement currentElement = (AuthorElement)editorAccess.getFullySelectedNode();
        if (currentElement == null) {
            try {
                currentElement = (AuthorElement)controller.getNodeAtOffset(caretOffset);
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getImageMapElement(currentElement);
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

