/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.markdown;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.markdown.MarkdownValidationProblem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.workspace.api.markdown.MarkdownValidator;
import ro.sync.exml.workspace.api.markdown.MarkdownValidatorFactory;
import ro.sync.servlet.ServletUtil;

public class MarkdownServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(MarkdownServlet.class);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            JsonNode requestData = new ObjectMapper().readTree((InputStream)req.getInputStream());
            String documentContent = requestData.get("docContent").textValue();
            String documentUrl = requestData.get("docUrl").textValue();
            String schematronId = requestData.get("schematronUrl").textValue();
            log.info("Validating document:" + documentUrl + " against schematron: " + schematronId);
            String decodedSchematronId = URLUtil.decodeURIComponent((String)schematronId);
            String absoluteSchematronId = URLUtil.makeAbsolute((String)documentUrl, (String)decodedSchematronId);
            log.debug("Absolute schematron URL:" + absoluteSchematronId);
            URL schematronUrl = new URL(absoluteSchematronId);
            ServletUtil.setUserContext((HttpServletRequest)req, (String)req.getSession().getId(), (URL)schematronUrl);
            ServletUtil.setUserContext((HttpServletRequest)req, (String)req.getSession().getId(), (URL)new URL(documentUrl));
            MarkdownValidator markdownValidator = MarkdownValidatorFactory.createSchematronValidator((String)schematronUrl.toString());
            List validationErrors = markdownValidator.validate(documentUrl, (Reader)new StringReader(documentContent));
            List markdownValidationProblems = validationErrors.stream().map(MarkdownValidationProblem::new).collect(Collectors.toList());
            new ObjectMapper().writeValue((OutputStream)resp.getOutputStream(), markdownValidationProblems);
        }
        catch (Exception e) {
            log.error("Cannot validate markdown document", (Throwable)e);
            resp.sendError(400);
        }
    }

    public String getPath() {
        return "markdown-plugin";
    }
}

