/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import ro.sync.basic.util.NumberParserUtil;

public class Base64Encoder {
    static final int LOWER_CASE_A_VALUE = 26;
    static final int ZERO_VALUE = 52;
    static final int PLUS_VALUE = 62;
    static final int SLASH_VALUE = 63;
    private static final int SIX_BIT_MASK = 63;

    private Base64Encoder() {
    }

    private static int convertUnsignedByteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public static String encode(byte[] data) {
        return Base64Encoder.encode(data, false);
    }

    public static String encode(byte[] data, boolean useLineBreaks) {
        int charCount = data.length * 4 / 3 + 4;
        StringBuilder result = useLineBreaks ? new StringBuilder(charCount * 77 / 76) : new StringBuilder(charCount);
        int byteArrayLength = data.length;
        int byteArrayIndex = 0;
        int byteTriplet = 0;
        while (byteArrayIndex < byteArrayLength - 2) {
            byteTriplet = Base64Encoder.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= Base64Encoder.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byte b4 = (byte)(0x3F & (byteTriplet |= Base64Encoder.convertUnsignedByteToInt(data[byteArrayIndex++])));
            byte b3 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(Base64Encoder.mapByteToChar(b1));
            result.append(Base64Encoder.mapByteToChar(b2));
            result.append(Base64Encoder.mapByteToChar(b3));
            result.append(Base64Encoder.mapByteToChar(b4));
            if (!useLineBreaks || byteArrayIndex % 57 != 0) continue;
            result.append(System.getProperty("line.separator"));
        }
        if (byteArrayIndex == byteArrayLength - 1) {
            byteTriplet = Base64Encoder.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b2 = (byte)(0x3F & (byteTriplet <<= 4));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(Base64Encoder.mapByteToChar(b1));
            result.append(Base64Encoder.mapByteToChar(b2));
            result.append("==");
        }
        if (byteArrayIndex == byteArrayLength - 2) {
            byteTriplet = Base64Encoder.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= Base64Encoder.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b3 = (byte)(0x3F & (byteTriplet <<= 2));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(Base64Encoder.mapByteToChar(b1));
            result.append(Base64Encoder.mapByteToChar(b2));
            result.append(Base64Encoder.mapByteToChar(b3));
            result.append("=");
        }
        return result.toString();
    }

    private static char mapByteToChar(byte b) {
        if (b < 26) {
            return (char)(65 + b);
        }
        if (b < 52) {
            return (char)(97 + (b - 26));
        }
        if (b < 62) {
            return (char)(48 + (b - 52));
        }
        if (b == 62) {
            return '+';
        }
        if (b == 63) {
            return '/';
        }
        throw new IllegalArgumentException("Byte " + NumberParserUtil.valueOfInteger(b) + " is not a valid Base64 value");
    }
}

