/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExceptCVSAndSVNFileFilter
implements FileFilter {
    private static final String DS_STORE = ".DS_Store";
    private static final String LOCK = ".lock";
    private static final List<String> SUBVERSION_FOLDERS = Stream.of(".git", ".svn", "cvs").collect(Collectors.toList());
    private boolean isLightImplementation = false;

    public ExceptCVSAndSVNFileFilter() {
    }

    public ExceptCVSAndSVNFileFilter(boolean isLightImplementation) {
        this.isLightImplementation = isLightImplementation;
    }

    @Override
    public boolean accept(File pathname) {
        String name = pathname.getName();
        String lowerCaseFileName = name.toLowerCase();
        return !(this.isLightImplementation ? SUBVERSION_FOLDERS.contains(lowerCaseFileName) || name.equals(DS_STORE) || name.endsWith(LOCK) : SUBVERSION_FOLDERS.contains(lowerCaseFileName) && pathname.isDirectory() || name.equals(DS_STORE) && pathname.isFile() || name.endsWith(LOCK) && pathname.isHidden());
    }
}

