/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xsl;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import com.oxygenxml.tokenmarker.activation.ActivationRange;
import com.oxygenxml.tokenmarker.xsl.ImbricationLevelStackOverLong;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextValueTemplatesActivationRule
extends AbstractXMLActivationRule {
    static final byte S_RECOGNIZED_STYLESHEET = 1;
    static final byte S_RECOGNIZED_STYLESHEET_VERSION = 2;
    static final byte S_RECOGNIZED_SV_EQ = 3;
    static final byte S_30_VERSION = 4;
    static final byte S_NO_30_VERSION = 5;
    static final byte S_30_EXPAND_TEXT = 6;
    static final byte S_30_EXPAND_TEXT_EQ = 7;
    static final byte S_ACTIVE_EXPAND_TEXT = 8;
    static final byte S_INACTIVE_EXPAND_TEXT = 9;
    private static final byte EXTRA_CELLS = 20;
    private ImbricationLevelStackOverLong[] imbrication = new ImbricationLevelStackOverLong[50];
    private boolean[] finishTextWithOpenedTVT = new boolean[50];
    private int line;
    private byte lastTokenId = (byte)10;
    private String lastOriginalTokenText = "";
    private boolean addNewImbricationState;
    private static final Set<String> OPEN_TAGS = Set.of("<stylesheet", "<transform", "<package");
    private static final Set<String> OPEN_TAGS_CONTAINS = Set.of(":stylesheet", ":transform", ":package");
    private static final Logger logger = LoggerFactory.getLogger((String)TextValueTemplatesActivationRule.class.getName());

    @Override
    protected void setLine(int line) {
        this.line = line;
        this.ensureArraysSize();
        if (line > 0) {
            this.imbrication[line] = this.imbrication[line - 1] == null ? new ImbricationLevelStackOverLong(0L) : (ImbricationLevelStackOverLong)this.imbrication[line - 1].clone();
        } else {
            this.imbrication[0] = new ImbricationLevelStackOverLong(0L);
        }
    }

    int getImbricationStackSize(int line) {
        return this.imbrication[line].getStackLen();
    }

    private void ensureArraysSize() {
        int len = this.imbrication.length;
        if (this.line >= len) {
            int newLen = len + 20;
            ImbricationLevelStackOverLong[] newImbrication = new ImbricationLevelStackOverLong[newLen];
            System.arraycopy(this.imbrication, 0, newImbrication, 0, len);
            this.imbrication = newImbrication;
            boolean[] newFinishTextWithOpenedTVT = new boolean[newLen];
            System.arraycopy(this.finishTextWithOpenedTVT, 0, newFinishTextWithOpenedTVT, 0, len);
            this.finishTextWithOpenedTVT = newFinishTextWithOpenedTVT;
        }
    }

    private static TAG_KIND getTagKind(String tag) {
        TAG_KIND tagKind = ">".equals(tag) ? TAG_KIND.START_TAG_END : ("/>".equals(tag) ? TAG_KIND.START_TAG_EMPTY_END : (tag.endsWith("/>") ? TAG_KIND.START_TAG_EMPTY : (tag.startsWith("</") ? TAG_KIND.END_TAG : (tag.endsWith(">") ? TAG_KIND.START_TAG_FULL : TAG_KIND.START_TAG_OPEN))));
        return tagKind;
    }

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        this.lastTokenId = tokenId;
        this.lastOriginalTokenText = originalTokenText;
        ImbricationLevelStackOverLong imbricationStack = this.imbrication[this.line];
        block0 : switch (this.state) {
            case 0: {
                if (6 != tokenId || TextValueTemplatesActivationRule.getTagKind(trimmedTokenText) != TAG_KIND.START_TAG_OPEN) break;
                if (!OPEN_TAGS.contains(trimmedTokenText)) {
                    if (!OPEN_TAGS_CONTAINS.stream().anyMatch(trimmedTokenText::contains)) break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                switch (tokenId) {
                    case 7: {
                        if ("version".equals(trimmedTokenText)) {
                            this.state = (byte)2;
                            break block0;
                        }
                        if (!"expand-text".equals(trimmedTokenText)) break block0;
                        this.state = (byte)6;
                        break block0;
                    }
                    case 3: 
                    case 4: 
                    case 9: {
                        break block0;
                    }
                }
                this.state = 0;
                break;
            }
            case 2: {
                this.state = (byte)(9 == tokenId ? 3 : 0);
                break;
            }
            case 3: {
                Character quote = TextValueTemplatesActivationRule.getAttributeValueTokenQuoteChar(tokenId);
                if (quote == null) {
                    this.state = 0;
                    break;
                }
                this.state = (byte)((quote + "3.0" + quote).equals(trimmedTokenText) ? 4 : 5);
                break;
            }
            case 4: {
                if (tokenId != 7 || !"expand-text".equals(trimmedTokenText) && !trimmedTokenText.endsWith(":expand-text")) break;
                this.state = (byte)6;
                break;
            }
            case 6: {
                this.state = (byte)(9 == tokenId ? 7 : 0);
                break;
            }
            case 7: {
                Character quote2 = TextValueTemplatesActivationRule.getAttributeValueTokenQuoteChar(tokenId);
                if (quote2 == null) {
                    this.state = 0;
                    break;
                }
                Set<CallSite> values = Set.of(quote2 + "true" + quote2, quote2 + "yes" + quote2, quote2 + "1" + quote2);
                this.state = (byte)(values.contains(trimmedTokenText) ? 8 : 9);
                this.addNewImbricationState = imbricationStack.isActive() ? this.state == 9 : this.state == 8;
                break;
            }
            case 8: 
            case 9: {
                if (tokenId != 6) break;
                TAG_KIND tagkind = TextValueTemplatesActivationRule.getTagKind(trimmedTokenText);
                switch (tagkind) {
                    case END_TAG: {
                        if (imbricationStack.isActive()) {
                            imbricationStack.decreaseImbricationLevel();
                        }
                        if (imbricationStack.isActive()) {
                            this.state = (byte)(imbricationStack.isEnabled() ? 8 : 9);
                            break block0;
                        }
                        this.state = (byte)4;
                        break block0;
                    }
                    case START_TAG_END: 
                    case START_TAG_FULL: {
                        if (this.addNewImbricationState) {
                            imbricationStack.addNewImbricationLevel(this.state == 8);
                        } else {
                            if (!imbricationStack.isActive()) {
                                imbricationStack.addNewImbricationLevel(this.state == 8);
                            }
                            imbricationStack.increaseImbricationLevel();
                        }
                        this.addNewImbricationState = false;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private static Character getAttributeValueTokenQuoteChar(byte tokenID) {
        Character quote = null;
        if (tokenID == 4) {
            quote = Character.valueOf('\'');
        } else if (tokenID == 3) {
            quote = Character.valueOf('\"');
        }
        return quote;
    }

    @Override
    public int getActivationState() {
        if (this.state == 8 && this.lastTokenId == 0 && (TextValueTemplatesActivationRule.getIndexOf(this.lastOriginalTokenText, '{', 0) != -1 || TextValueTemplatesActivationRule.getIndexOf(this.lastOriginalTokenText, '}', 0) != -1 || this.line > 0 && this.finishTextWithOpenedTVT[this.line - 1])) {
            return -1;
        }
        return -2;
    }

    private static boolean isDoubled(String tokenText, char ch, int pos) {
        try {
            return pos + 1 < tokenText.length() && tokenText.charAt(pos + 1) == ch;
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.debug(e::getMessage);
            logger.debug(() -> "|" + tokenText + "| - Pos: " + pos + " - Len: " + tokenText.length());
            return false;
        }
    }

    static int getIndexOf(String tokenText, char ch, int from) {
        int pos = tokenText.indexOf(ch, from);
        while (pos != -1 && TextValueTemplatesActivationRule.isDoubled(tokenText, ch, pos)) {
            if ((pos += 2) <= tokenText.length()) {
                pos = tokenText.indexOf(ch, pos);
                continue;
            }
            pos = -1;
        }
        return pos;
    }

    @Override
    public ActivationRange[] getRanges() {
        int start = TextValueTemplatesActivationRule.getIndexOf(this.lastOriginalTokenText, '{', 0);
        int end = TextValueTemplatesActivationRule.getIndexOf(this.lastOriginalTokenText, '}', 0);
        this.finishTextWithOpenedTVT[this.line] = false;
        if (start > end && end != -1) {
            start = 0;
        }
        boolean possibleOpenTVT = this.line > 0 && this.finishTextWithOpenedTVT[this.line - 1];
        ArrayList<ActivationRange> ranges = new ArrayList<ActivationRange>();
        if (start != -1 || end != -1 || possibleOpenTVT) {
            do {
                if (start == -1) {
                    start = 0;
                }
                if (end == -1) {
                    end = this.lastOriginalTokenText.length();
                    this.finishTextWithOpenedTVT[this.line] = true;
                } else {
                    ++end;
                }
                ranges.add(new ActivationRange(start, end));
                start = TextValueTemplatesActivationRule.getIndexOf(this.lastOriginalTokenText, '{', end);
                if (start == -1) continue;
                end = TextValueTemplatesActivationRule.getIndexOf(this.lastOriginalTokenText, '}', start);
            } while (start != -1);
        }
        return ranges.isEmpty() ? null : ranges.toArray(new ActivationRange[0]);
    }

    static String state2String(byte state) {
        String stateStr;
        switch (state) {
            case 1: {
                stateStr = "S_RECOGNIZED_STYLESHEET";
                break;
            }
            case 2: {
                stateStr = "S_RECOGNIZED_STYLESHEET_VERSION";
                break;
            }
            case 3: {
                stateStr = "S_RECOGNIZED_SV_EQ";
                break;
            }
            case 4: {
                stateStr = "S_30_VERSION";
                break;
            }
            case 5: {
                stateStr = "S_NO_30_VERSION";
                break;
            }
            case 6: {
                stateStr = "S_30_EXPAND_TEXT";
                break;
            }
            case 7: {
                stateStr = "S_30_EXPAND_TEXT_EQ";
                break;
            }
            case 8: {
                stateStr = "S_ACTIVE_EXPAND_TEXT";
                break;
            }
            case 9: {
                stateStr = "S_INACTIVE_EXPAND_TEXT";
                break;
            }
            default: {
                stateStr = "S_INITIAL";
            }
        }
        return stateStr;
    }

    private static enum TAG_KIND {
        START_TAG_FULL,
        START_TAG_EMPTY,
        START_TAG_OPEN,
        START_TAG_END,
        START_TAG_EMPTY_END,
        END_TAG;

    }
}

