/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core.urlhandler;

import com.oxygenxml.cmis.core.CMISAccess;
import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.CmisURL;
import com.oxygenxml.cmis.core.ResourceController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisURLConnection
extends URLConnection {
    private static final Logger log = LoggerFactory.getLogger(CmisURLConnection.class);
    private CMISAccess cmisAccess;
    private ResourceController resourceController;
    private CmisCredentials credentials;

    public CmisURLConnection(URL url, CMISAccess cmisAccess, CmisCredentials credentials) {
        super(url);
        this.cmisAccess = cmisAccess;
        this.credentials = credentials;
    }

    public static String generateURLObject(Folder folder, CmisObject object, ResourceController ctrl) {
        String originalProtocol = (String)ctrl.getSession().getSessionParameters().get("org.apache.chemistry.opencmis.binding.atompub.url");
        String repository = (String)ctrl.getSession().getSessionParameters().get("org.apache.chemistry.opencmis.session.repository.id");
        try {
            Object folderPath = folder.getPath();
            if (!((String)folderPath).endsWith("/")) {
                folderPath = (String)folderPath + "/";
            }
            CmisURL objCmisUrl = CmisURL.ofRepo(new URL(originalProtocol), repository, (String)folderPath + object.getName());
            String url = objCmisUrl.toExternalForm();
            if (object instanceof Folder) {
                url = url.concat("/");
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public CmisObject getCMISObject(String url) throws MalformedURLException, CmisObjectNotFoundException {
        CmisURL cmisUrl = CmisURL.parse(url);
        String repoID = cmisUrl.getRepositoryId();
        this.cmisAccess.connectToRepo(cmisUrl.getServerHttpUrl(), repoID, this.credentials);
        this.resourceController = this.cmisAccess.createResourceController();
        String path = cmisUrl.getPath();
        return this.resourceController.getSession().getObjectByPath(path);
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            Document initialDocument;
            Document document = initialDocument = (Document)this.getCMISObject(this.getURL().toExternalForm());
            if (document.isVersionable() && (document = document.getObjectOfLatestVersion(false)).isVersionSeriesCheckedOut().booleanValue()) {
                document = this.getPwcDocument(initialDocument);
            }
            ContentStream contentStream = null;
            if (document != null) {
                contentStream = document.getContentStream();
            }
            if (contentStream == null) {
                contentStream = initialDocument.getContentStream();
            }
            if (contentStream != null) {
                return contentStream.getStream();
            }
            throw new IOException("This document does not have any content");
        }
        catch (CmisObjectNotFoundException ex) {
            throw new FileNotFoundException(this.getURL().getPath());
        }
    }

    public Document getPwcDocument(Document document) {
        Document pwcDoc = document;
        if (!Boolean.TRUE.equals(document.isLatestVersion())) {
            pwcDoc = document.getObjectOfLatestVersion(false);
        }
        if (document.getVersionSeriesCheckedOutId() != null) {
            String pwcId = document.getVersionSeriesCheckedOutId();
            pwcDoc = (Document)this.resourceController.getSession().getObject(pwcId);
        }
        return pwcDoc;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                Document document = null;
                String documentUrl = null;
                boolean newDocument = false;
                try {
                    documentUrl = CmisURLConnection.this.getURL().toExternalForm();
                    document = (Document)CmisURLConnection.this.getCMISObject(documentUrl);
                }
                catch (CmisConnectionException | CmisObjectNotFoundException e) {
                    documentUrl = CmisURLConnection.this.createDocument();
                    document = (Document)CmisURLConnection.this.getCMISObject(documentUrl);
                    newDocument = true;
                }
                byte[] byteArray = this.toByteArray();
                String contentStreamMimeType = document.getContentStreamMimeType();
                if (contentStreamMimeType == null) {
                    contentStreamMimeType = "text/xml";
                }
                ContentStreamImpl contentStream = new ContentStreamImpl(document.getName(), BigInteger.valueOf(byteArray.length), contentStreamMimeType, (InputStream)new ByteArrayInputStream(byteArray));
                this.trySave(document, newDocument, contentStream);
            }

            private void trySave(Document document, boolean newDocument, ContentStreamImpl contentStream) throws IOException {
                try {
                    if (!document.isVersionable()) {
                        document.setContentStream((ContentStream)contentStream, true);
                    } else {
                        Document pwcDoc = null;
                        boolean alreadyCheckedOut = true;
                        if (document.isVersionSeriesCheckedOut().booleanValue()) {
                            pwcDoc = CmisURLConnection.this.getPwcDocument(document);
                        } else {
                            ObjectId pwcID = document.checkOut();
                            pwcDoc = (Document)CmisURLConnection.this.resourceController.getSession().getObject(pwcID);
                            alreadyCheckedOut = false;
                        }
                        pwcDoc.setContentStream((ContentStream)contentStream, true);
                        if (newDocument) {
                            pwcDoc.checkIn(true, null, null, " ");
                            CmisURLConnection.this.deleteUselessVersion(document);
                        } else if (!alreadyCheckedOut) {
                            pwcDoc.checkIn(false, null, null, " ");
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
        };
    }

    private void deleteUselessVersion(Document document) {
        document = document.getObjectOfLatestVersion(false);
        List allVersions = document.getAllVersions();
        Document usellesVersion = (Document)allVersions.get(allVersions.size() - 1);
        this.resourceController.deleteOneVersionDocument(usellesVersion);
    }

    public String createDocument() throws MalformedURLException {
        CmisURL cmisUrl = CmisURL.parse(this.url.toExternalForm());
        String folderPath = cmisUrl.getFolderPath();
        String fileName = cmisUrl.getFileName();
        String mimeType = MimeTypes.getMIMEType((String)cmisUrl.getExtension());
        if (mimeType == "application/octet-stream") {
            mimeType = "text/xml";
        }
        Folder rootFolder = (Folder)this.cmisAccess.getSession().getObjectByPath(folderPath);
        Document document = this.resourceController.createEmptyVersionedDocument(rootFolder, fileName, mimeType, VersioningState.MINOR);
        return CmisURLConnection.generateURLObject(rootFolder, (CmisObject)document, this.resourceController);
    }

    public boolean canCheckoutDocument(Document doc) {
        Boolean canSetContentStream = doc.hasAllowableAction(Action.CAN_SET_CONTENT_STREAM);
        boolean isSharePoint = this.getCMISAccess().isSharePoint();
        String versionSeriesCheckedOutBy = doc.getVersionSeriesCheckedOutBy();
        return canSetContentStream != false && isSharePoint || versionSeriesCheckedOutBy == null || this.getUserCredentials().getUsername().equals(versionSeriesCheckedOutBy);
    }

    public ResourceController getResourceController(String connectionUrl) throws MalformedURLException {
        this.getCMISObject(connectionUrl);
        return this.resourceController;
    }

    public CMISAccess getCMISAccess() {
        return this.cmisAccess;
    }

    public CmisCredentials getUserCredentials() {
        return this.credentials;
    }
}

