/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core.model.impl;

import com.oxygenxml.cmis.core.ResourceController;
import com.oxygenxml.cmis.core.model.IFolder;
import com.oxygenxml.cmis.core.model.IResource;
import com.oxygenxml.cmis.core.model.impl.DocumentImpl;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderImpl
implements IFolder {
    private static final Logger log = LoggerFactory.getLogger(FolderImpl.class);
    private Folder folder;

    public FolderImpl(Folder folder) {
        this.folder = folder;
    }

    public Folder getFolder() {
        return this.folder;
    }

    @Override
    public Iterator<IResource> iterator() {
        return new ResourceIterator(this.folder);
    }

    @Override
    public String getDisplayName() {
        return this.folder.getName();
    }

    @Override
    public String getDescription() {
        return this.folder.getDescription();
    }

    @Override
    public String getId() {
        return this.folder.getId();
    }

    @Override
    public String getFolderPath() {
        return this.folder.getPath();
    }

    @Override
    public String getCreatedBy() {
        return this.folder.getCreatedBy();
    }

    @Override
    public void addToModel(Document doc) {
    }

    public Date getTimeCreated() {
        return this.folder.getCreationDate().getTime();
    }

    public ItemIterable<QueryResult> getQuery(ResourceController ctrl) {
        String query = "SELECT * FROM cmis:folder WHERE cmis:name LIKE '".concat(this.getDisplayName()).concat("'");
        return ctrl.getSession().query(query, false);
    }

    @Override
    public boolean isCheckedOut() {
        return false;
    }

    @Override
    public void refresh() {
        this.folder.refresh();
    }

    @Override
    public void removeFromModel(IResource resource) {
    }

    public CmisObject rename(String newName) {
        return this.folder.rename(newName);
    }

    private class ResourceIterator
    implements Iterator<IResource> {
        private Iterator<CmisObject> children;

        public ResourceIterator(Folder folder) {
            this.children = folder.getChildren().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.children.hasNext();
        }

        @Override
        public IResource next() {
            CmisObject next = this.children.next();
            if (next instanceof Document) {
                return new DocumentImpl((Document)next);
            }
            if (next instanceof Folder) {
                return new FolderImpl((Folder)next);
            }
            log.error("Unhandled type " + next.getClass());
            return new OtherResource(next);
        }
    }

    private class OtherResource
    implements IResource {
        private CmisObject object;

        public OtherResource(CmisObject object) {
            this.object = object;
        }

        @Override
        public Iterator<IResource> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public String getDescription() {
            return this.object.getDescription();
        }

        @Override
        public String getDisplayName() {
            return this.object.getName() + " [" + this.object.getType() + "]";
        }

        @Override
        public String getId() {
            return this.object.getId();
        }

        @Override
        public String getCreatedBy() {
            return this.object.getCreatedBy();
        }

        @Override
        public boolean isCheckedOut() {
            return false;
        }

        @Override
        public void refresh() {
            this.object.refresh();
        }
    }
}

