/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core.model.impl;

import com.oxygenxml.cmis.core.CMISAccess;
import com.oxygenxml.cmis.core.ResourceController;
import com.oxygenxml.cmis.core.model.IDocument;
import com.oxygenxml.cmis.core.model.IResource;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.DocumentType;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentImpl
implements IDocument {
    private static final Logger log = LoggerFactory.getLogger(DocumentImpl.class);
    private final Document doc;

    public DocumentImpl(Document doc) {
        this.doc = doc;
    }

    @Override
    public Iterator<IResource> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Document getDoc() {
        return this.doc;
    }

    @Override
    public String getDisplayName() {
        return this.doc.getName();
    }

    @Override
    public String getId() {
        return this.doc.getId();
    }

    public Document getLastCheckoutVersion() {
        return this.doc.getObjectOfLatestVersion(false);
    }

    public String getContentStreamId() {
        return this.doc.getContentStreamId();
    }

    public String getVersionSeriesCheckedOutId() {
        return this.doc.getVersionSeriesCheckedOutId();
    }

    public DocumentType getDocType() {
        return this.doc.getDocumentType();
    }

    public String getModifiedBy() {
        Object displayTime = "";
        Date timeModified = this.doc.getLastModificationDate().getTime();
        Date today = new Date();
        long diff = today.getTime() - timeModified.getTime();
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        if (diffDays > 0L) {
            displayTime = String.valueOf(diffDays) + " day/s ago";
        } else if (diffHours > 0L) {
            displayTime = String.valueOf(diffHours) + " hour/s ago";
        } else if (diffMinutes > 0L) {
            displayTime = String.valueOf(diffHours) + " minute/s ago";
        } else if (diffSeconds > 0L) {
            displayTime = String.valueOf(diffSeconds) + " second/s ago";
        }
        return "Modified by " + this.doc.getLastModifiedBy() + " " + (String)displayTime;
    }

    public boolean canUserDelete() {
        return this.doc.hasAllowableAction(Action.CAN_DELETE_OBJECT);
    }

    public boolean canUserOpen() {
        return this.doc.hasAllowableAction(Action.CAN_GET_CONTENT_STREAM);
    }

    public boolean canUserCreateDoc() {
        return this.doc.hasAllowableAction(Action.CAN_CREATE_DOCUMENT);
    }

    public boolean canUserUpdateContent() {
        return this.doc.hasAllowableAction(Action.CAN_SET_CONTENT_STREAM);
    }

    public boolean canUserUpdateProperties() {
        return this.doc.hasAllowableAction(Action.CAN_UPDATE_PROPERTIES);
    }

    public boolean canUserCheckout() {
        return this.doc.hasAllowableAction(Action.CAN_CHECK_OUT);
    }

    public boolean canUserCheckin() {
        return this.doc.hasAllowableAction(Action.CAN_CHECK_IN);
    }

    public boolean canUserCancelCheckout() {
        return this.doc.hasAllowableAction(Action.CAN_CANCEL_CHECK_OUT);
    }

    public boolean isVersionable() {
        return this.doc.isVersionable();
    }

    public String getMimetype() {
        return this.doc.getContentStreamMimeType();
    }

    @Override
    public String getDescription() {
        return this.doc.getDescription();
    }

    public long getSize() {
        return this.doc.getContentStream().getLength();
    }

    public Date getTimeCreated() {
        return this.doc.getCreationDate().getTime();
    }

    @Override
    public String getCreatedBy() {
        return this.doc.getCreatedBy();
    }

    public ItemIterable<QueryResult> getQuery(ResourceController ctrl) {
        String query = "SELECT * FROM cmis:document WHERE cmis:name LIKE '".concat(this.getDisplayName()).concat("'");
        return ctrl.getSession().query(query, false);
    }

    @Override
    public String getDocumentPath(ResourceController ctrl) {
        StringBuilder b = new StringBuilder();
        List docPath = this.doc.getPaths();
        b.append("/").append(ctrl.getRootFolder().getName());
        for (int i = 0; i < docPath.size() && !docPath.isEmpty(); ++i) {
            b.append((String)docPath.get(i)).append("/");
        }
        return b.toString();
    }

    @Override
    public Document getLastVersionDocument() {
        Document latest = null;
        latest = Boolean.TRUE.equals(this.doc.isLatestVersion()) ? this.doc : this.doc.getObjectOfLatestVersion(false);
        return latest;
    }

    @Override
    public boolean isCheckedOut() {
        Property property;
        if (log.isDebugEnabled() && (property = this.doc.getProperty("cmis:isVersionSeriesCheckedOut")) != null) {
            log.debug(this.getDisplayName() + " is checked out=" + property.getValuesAsString());
        }
        Boolean versionSeriesCheckedOut = this.doc.isVersionSeriesCheckedOut();
        return Boolean.TRUE.equals(versionSeriesCheckedOut);
    }

    @Override
    public boolean isPrivateWorkingCopy() {
        Property property;
        if (log.isDebugEnabled() && (property = this.doc.getProperty("cmis:isPrivateWorkingCopy")) != null) {
            log.debug("CPWC=" + property.getValuesAsString());
        }
        Boolean isPrivateWC = this.doc.isPrivateWorkingCopy();
        return Boolean.TRUE.equals(isPrivateWC);
    }

    @Override
    public Document checkOut(DocumentType docType, CMISAccess cmisAccess) {
        if (Boolean.TRUE.equals(docType.isVersionable())) {
            ObjectId pwcId = this.doc.checkOut();
            Document pwc = (Document)cmisAccess.getSession().getObject(pwcId);
            if (log.isDebugEnabled()) {
                log.debug("PWC ID=" + pwcId);
                log.debug("PWC name=" + pwc.getName());
            }
            return pwc;
        }
        return this.doc;
    }

    @Override
    public void cancelCheckOut() throws CmisBaseException {
        this.doc.cancelCheckOut();
    }

    @Override
    public ObjectId checkIn(boolean major, String message) {
        return this.doc.checkIn(major, null, this.doc.getContentStream(), message);
    }

    @Override
    public void refresh() {
        this.doc.refresh();
    }

    public CmisObject rename(String newName) {
        return this.doc.rename(newName);
    }
}

