/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core;

import com.oxygenxml.cmis.core.CmisCredentials;
import javax.xml.bind.annotation.XmlRootElement;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

@XmlRootElement(name="userCredentials")
public class UserCredentials
implements CmisCredentials {
    private String username;
    private String password;
    private boolean encrypted = false;

    public UserCredentials() {
    }

    public UserCredentials(String username, String encryptedPassword) {
        this.username = username;
        this.password = encryptedPassword;
    }

    public UserCredentials(String username, String password, boolean encrypt) {
        this.username = username;
        if (encrypt) {
            this.password = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(password);
            this.encrypted = true;
        } else {
            this.password = password;
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassword(String password, boolean encrypt) {
        if (encrypt) {
            this.password = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(password);
            this.encrypted = true;
        } else {
            this.password = password;
            this.encrypted = false;
        }
    }

    public String getPassword() {
        if (this.encrypted) {
            return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(this.password);
        }
        return this.password;
    }

    @Override
    public boolean isEmpty() {
        if (this.username.isEmpty() && this.password.isEmpty()) {
            return true;
        }
        return !this.username.isEmpty() && this.password.isEmpty();
    }

    public String toString() {
        return "Username: " + this.username;
    }
}

