/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core;

import com.oxygenxml.cmis.core.ResourceController;
import com.oxygenxml.cmis.core.model.IDocument;
import com.oxygenxml.cmis.core.model.IResource;
import com.oxygenxml.cmis.core.model.impl.DocumentImpl;
import com.oxygenxml.cmis.core.model.impl.FolderImpl;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchController {
    private static final Logger log = LoggerFactory.getLogger(SearchController.class);
    private static final String FOLDER_TYPE = "cmis:folder";
    private static final String DOCUMENT_TYPE = "cmis:document";
    public static final int SEARCH_IN_DOCUMENT = 1;
    public static final int SEARCH_IN_FOLDER = 2;
    private ResourceController ctrl;

    public SearchController(ResourceController ctrl) {
        this.ctrl = ctrl;
    }

    private List<IResource> queryResourceName(String name, int searchObjectTypes) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        OperationContext oc = this.ctrl.getSession().createOperationContext();
        Object scope = "";
        if ((searchObjectTypes & 1) != 0) {
            scope = DOCUMENT_TYPE;
        } else if ((searchObjectTypes & 2) != 0) {
            if (((String)scope).length() > 0) {
                scope = (String)scope + ",";
            }
            scope = (String)scope + FOLDER_TYPE;
        }
        ItemIterable results = this.ctrl.getSession().queryObjects((String)scope, "cmis:name LIKE '%" + name + "%'", false, oc);
        for (CmisObject cmisObject : results) {
            IResource res = null;
            res = cmisObject instanceof Document ? new DocumentImpl((Document)cmisObject) : new FolderImpl((Folder)cmisObject);
            resources.add(res);
        }
        return resources;
    }

    private List<IResource> queryPersonalCheckedoutDocs(String toSearch, int searchObjectTypes) {
        ArrayList<DocumentImpl> personalDocuments = new ArrayList<DocumentImpl>();
        ArrayList<String> idResources = new ArrayList<String>();
        ArrayList<IResource> generalResults = new ArrayList<IResource>();
        OperationContext oc = this.ctrl.getSession().createOperationContext();
        oc.setOrderBy("cmis:name ASC");
        oc.setIncludeAllowableActions(true);
        oc.setIncludeRelationships(IncludeRelationships.BOTH);
        oc.setIncludePolicies(true);
        ItemIterable personalResults = this.ctrl.getSession().getCheckedOutDocs(oc);
        for (CmisObject cmisObject : personalResults) {
            IResource res = null;
            if (cmisObject instanceof Document) {
                res = new DocumentImpl((Document)cmisObject);
            } else if (cmisObject instanceof Folder) {
                res = new FolderImpl((Folder)cmisObject);
            }
            if (res == null) continue;
            Document lastCheckoutVersion = res.getLastCheckoutVersion();
            personalDocuments.add(new DocumentImpl(lastCheckoutVersion));
        }
        for (DocumentImpl document : personalDocuments) {
            idResources.add(document.getId());
        }
        generalResults.addAll(this.queryDoc(toSearch));
        Iterator resultsIterator = generalResults.iterator();
        while (resultsIterator.hasNext()) {
            DocumentImpl doc = (DocumentImpl)resultsIterator.next();
            String docId = doc.getId();
            if (idResources.contains(docId)) continue;
            resultsIterator.remove();
        }
        return generalResults;
    }

    public List<IResource> queryForeignCheckedoutDocs(String toSearch) {
        ArrayList<IResource> personalCheckedoutDocs = new ArrayList<IResource>();
        ArrayList<IResource> allResources = new ArrayList<IResource>();
        ArrayList<String> idResources = new ArrayList<String>();
        personalCheckedoutDocs.addAll(this.queryPersonalCheckedout(toSearch));
        for (IResource resource : personalCheckedoutDocs) {
            if (!(resource instanceof DocumentImpl)) continue;
            String docId = ((DocumentImpl)resource).getId();
            idResources.add(docId);
        }
        allResources.addAll(this.queryDoc(toSearch));
        this.removeNonCheckoutDocuments(allResources);
        Iterator allResourcesIterator = allResources.iterator();
        while (allResourcesIterator.hasNext()) {
            IResource resource;
            resource = (IResource)allResourcesIterator.next();
            if (!idResources.contains(resource.getId())) continue;
            allResourcesIterator.remove();
        }
        return allResources;
    }

    private List<IResource> removeNonCheckoutDocuments(List<IResource> resources) {
        Iterator<IResource> resIterator = resources.iterator();
        while (resIterator.hasNext()) {
            IResource resource = resIterator.next();
            if (resource.isCheckedOut()) continue;
            resIterator.remove();
        }
        return resources;
    }

    private ArrayList<IResource> removePWCDocsFromSearch(ArrayList<IResource> resources) {
        Iterator<IResource> resIterator = resources.iterator();
        while (resIterator.hasNext()) {
            IResource resource = resIterator.next();
            if (!resource.isCheckedOut() || !((DocumentImpl)resource).isPrivateWorkingCopy()) continue;
            resIterator.remove();
        }
        return resources;
    }

    private List<IResource> queryResource(String toSearch, int searchObjectTypes) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        String[] searchKeys = toSearch.split("\\s+");
        Object scope = "";
        OperationContext oc = this.ctrl.getSession().createOperationContext();
        oc.setOrderBy("cmis:name ASC");
        oc.setIncludeAllowableActions(true);
        oc.setIncludeRelationships(IncludeRelationships.BOTH);
        oc.setIncludePolicies(true);
        if ((searchObjectTypes & 1) != 0) {
            scope = DOCUMENT_TYPE;
        } else if ((searchObjectTypes & 2) != 0) {
            if (((String)scope).length() > 0) {
                scope = (String)scope + ",";
            }
            scope = (String)scope + FOLDER_TYPE;
        }
        StringBuilder strBuild = this.constructWhereStatement(searchKeys);
        String where = strBuild.toString();
        if (log.isDebugEnabled()) {
            log.debug("Where statement : " + where);
        }
        ItemIterable results = this.ctrl.getSession().queryObjects((String)scope, where, false, oc);
        for (CmisObject cmisObject : results) {
            IResource res = null;
            if (cmisObject instanceof Document) {
                res = new DocumentImpl((Document)cmisObject);
            } else if (cmisObject instanceof Folder) {
                res = new FolderImpl((Folder)cmisObject);
            }
            resources.add(res);
        }
        return this.removePWCDocsFromSearch(resources);
    }

    private StringBuilder constructWhereStatement(String[] searchKeys) {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append("CONTAINS('");
        Object searchKey = "";
        String logicKey = "";
        String key = "";
        for (int index = 0; index < searchKeys.length; ++index) {
            key = searchKeys[index];
            if (LogicOperators.contains(key)) {
                logicKey = key;
                strBuild.append(logicKey);
                continue;
            }
            searchKey = searchKeys.length == 1 ? "*" + key + "*" : key;
            strBuild.append("(cmis:name:" + (String)searchKey + " OR cmis:createdBy:" + (String)searchKey + " OR cmis:description:" + (String)searchKey + " OR " + (String)searchKey + ")");
            if (index + 1 >= searchKeys.length || LogicOperators.contains(key = searchKeys[index + 1])) continue;
            logicKey = "AND";
            strBuild.append(logicKey);
        }
        strBuild.append("')");
        return strBuild;
    }

    public List<IResource> queryDocName(String content) {
        return this.queryResourceName(content, 1);
    }

    public List<IResource> queryFolderName(String content) {
        return this.queryResourceName(content, 2);
    }

    public List<IResource> queryDoc(String content) {
        return this.queryResource(content, 1);
    }

    public List<IResource> queryPersonalCheckedout(String content) {
        return this.queryPersonalCheckedoutDocs(content, 1);
    }

    public List<IResource> queryFolder(String content) {
        return this.queryResource(content, 2);
    }

    public List<IDocument> queryDocContent(String content) {
        ArrayList<IDocument> docList = new ArrayList<IDocument>();
        OperationContext oc = this.ctrl.getSession().createOperationContext();
        ItemIterable results = this.ctrl.getSession().queryObjects(DOCUMENT_TYPE, "CONTAINS ('" + content + "')", false, oc);
        for (CmisObject cmisObject : results) {
            DocumentImpl doc = new DocumentImpl((Document)cmisObject);
            docList.add(doc);
        }
        return docList;
    }

    public String queryFindLine(IResource resource, String content) {
        String[] searchKeys = content.trim().split("\\s+");
        int STRING_LIMIT = 45;
        if (resource instanceof DocumentImpl) {
            IDocument iDocument = (IDocument)resource;
            try {
                Reader documentContent = this.ctrl.getDocumentContent(iDocument.getId());
                if (documentContent != null) {
                    return this.scanLines(searchKeys, 45, documentContent);
                }
            }
            catch (Exception e) {
                log.debug("Exception", (Throwable)e);
            }
        }
        return null;
    }

    private String scanLines(String[] searchKeys, int STRING_LIMIT, Reader documentContent) {
        Scanner scanner = new Scanner(documentContent);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            for (String key : searchKeys) {
                if (!line.contains(key)) continue;
                log.debug("Content found=" + line);
                scanner.close();
                return this.limitStringResult(line, key, STRING_LIMIT);
            }
        }
        scanner.close();
        return null;
    }

    public String limitStringResult(String input, String pattern, int stringLimit) {
        String limitedString = input.trim();
        int frontCounter = 1;
        int backCounter = input.length() - 1;
        while (limitedString.length() > stringLimit) {
            if (frontCounter != limitedString.indexOf(pattern)) {
                limitedString = limitedString.substring(frontCounter);
                --backCounter;
            }
            if (limitedString.length() <= stringLimit) {
                return limitedString;
            }
            if (backCounter != limitedString.indexOf(pattern) + pattern.length() - 1) {
                limitedString = limitedString.substring(0, backCounter);
                --backCounter;
            }
            if (limitedString.length() > stringLimit) continue;
            return limitedString;
        }
        return limitedString;
    }

    public static enum LogicOperators {
        AND,
        OR,
        NOT;


        public static boolean contains(String s) {
            for (LogicOperators choice : LogicOperators.values()) {
                if (!choice.name().equals(s)) continue;
                return true;
            }
            return false;
        }
    }
}

