/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceController {
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);
    public static final String DEFAULT_OBJ_TYPE = "cmis:document";
    public static final String VERSIONABLE_OBJ_TYPE = "VersionableType";
    private Session session;

    public ResourceController(Session session) {
        this.session = session;
    }

    public Folder getRootFolder() {
        return this.session.getRootFolder();
    }

    public Document createDocument(Folder path, String filename, String content, String mimeType) {
        String mimetype = mimeType.concat("; charset=UTF-8");
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream stream = new ByteArrayInputStream(contentBytes);
        ContentStream contentStream = this.session.getObjectFactory().createContentStream(filename, (long)contentBytes.length, mimetype, (InputStream)stream);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", filename);
        properties.put("cmis:objectTypeId", DEFAULT_OBJ_TYPE);
        return path.createDocument(properties, contentStream, VersioningState.NONE);
    }

    @VisibleForTesting
    Document createVersionedDocument(Folder path, String filename, String content, String mimetype, String objectType, VersioningState versioningState) {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream stream = new ByteArrayInputStream(contentBytes);
        ContentStream contentStream = this.session.getObjectFactory().createContentStream(filename, (long)contentBytes.length, mimetype, (InputStream)stream);
        return this.createVersionedDocument(path, filename, contentStream, objectType, versioningState);
    }

    public Document createEmptyVersionedDocument(Folder path, String filename, String mimetype, VersioningState versioningState) {
        String content = "<empty/>";
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.US_ASCII));
        ContentStream contentStream = this.session.getObjectFactory().createContentStream(filename, (long)content.length(), mimetype, (InputStream)stream);
        return this.createVersionedDocument(path, filename, contentStream, VERSIONABLE_OBJ_TYPE, versioningState);
    }

    public ContentStream createXmlUtf8ContentStream(String fileName, String content) {
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        return this.session.getObjectFactory().createContentStream(fileName, (long)content.length(), "text/xml", (InputStream)stream);
    }

    public Document createVersionedDocument(Folder path, String filename, ContentStream contentStream, String objectType, VersioningState versioningState) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", filename);
        if (!this.isTypeSupported(objectType)) {
            objectType = DEFAULT_OBJ_TYPE;
        }
        properties.put("cmis:objectTypeId", objectType);
        return path.createDocument(properties, contentStream, versioningState);
    }

    @VisibleForTesting
    boolean isTypeSupported(String objectType) {
        boolean typeExists = true;
        if (!DEFAULT_OBJ_TYPE.equals(objectType)) {
            try {
                this.session.getTypeDefinition(objectType);
            }
            catch (CmisInvalidArgumentException | CmisObjectNotFoundException e) {
                typeExists = false;
            }
        }
        return typeExists;
    }

    public boolean move(Folder sourceFolder, Folder targetFolder, Document doc) {
        return doc.move((ObjectId)sourceFolder, (ObjectId)targetFolder) != null;
    }

    public void addToFolder(Folder folder, Document doc) {
        doc.addToFolder((ObjectId)folder, true);
    }

    public void removeFromFolder(Folder folder, Document doc) {
        doc.removeFromFolder((ObjectId)folder);
    }

    public void deleteAllVersionsDocument(Document doc) {
        if (doc != null) {
            doc.delete(true);
        }
    }

    public void deleteOneVersionDocument(Document doc) {
        if (doc != null) {
            doc.delete(false);
        }
    }

    public Folder createFolder(Folder parent, String name) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", "cmis:folder");
        return parent.createFolder(properties);
    }

    public List<String> deleteFolderTree(Folder folder) {
        if (folder != null) {
            return folder.deleteTree(true, UnfileObject.DELETE, true);
        }
        return Collections.emptyList();
    }

    public CmisObject renameFolder(Folder folder, String newName) {
        return folder.rename(newName);
    }

    public Document getDocument(String id) {
        return (Document)this.session.getObject(id);
    }

    public Folder getFolder(String id) {
        return (Folder)this.session.getObject(id);
    }

    public Session getSession() {
        return this.session;
    }

    public Reader getDocumentContent(String docID) {
        Document document = null;
        if (docID != null) {
            try {
                document = (Document)this.session.getObject(docID);
            }
            catch (CmisObjectNotFoundException e) {
                log.warn("No object found for: " + docID);
            }
            if (document != null) {
                ContentStream contentStream = document.getContentStream();
                InputStream stream = contentStream.getStream();
                return new InputStreamReader(stream, StandardCharsets.UTF_8);
            }
        }
        return null;
    }

    public CmisObject getCmisObj(String objectID) {
        return this.session.getObject(objectID);
    }
}

