/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryInfo {
    private static final Logger log = LoggerFactory.getLogger(RepositoryInfo.class);
    private static final Pattern EXTRACT_REPO_ID_PATTERN = Pattern.compile("(.*?)\\s\\[(.*?)\\]$");
    private String id;
    private String name;

    public RepositoryInfo(String id, String name) {
        Objects.requireNonNull("the id of the repository cannot be null", id);
        this.id = id;
        this.name = name != null ? name : "";
    }

    public String toString() {
        return "RepositoryInfo [id=" + this.id + ", name=" + this.name + "]";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static RepositoryInfo fromURLPart(String urlPart) {
        Matcher m = EXTRACT_REPO_ID_PATTERN.matcher(urlPart);
        if (m.matches()) {
            String name = m.group(1);
            String id = m.group(2);
            log.debug("Repo name:{} - id: {}", (Object)name, (Object)id);
            return new RepositoryInfo(id, name);
        }
        return new RepositoryInfo(urlPart, "");
    }

    public String toUrlPart() {
        if (this.name.isEmpty()) {
            return this.id;
        }
        return this.name + " [" + this.id + "]";
    }
}

