/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core;

import com.oxygenxml.cmis.core.MaterializedResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.DefaultHttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class OxygenHttpInvoker
implements HttpInvoker {
    private static final Logger log = LoggerFactory.getLogger(OxygenHttpInvoker.class);
    private final HttpInvoker defaultInvoker = new DefaultHttpInvoker();

    public Response invokeGET(UrlBuilder url, BindingSession session) {
        try {
            return this.defaultInvoker.invokeGET(url, session);
        }
        catch (CmisConnectionException e) {
            return this.handleConnectionException(e);
        }
    }

    private Response handleConnectionException(CmisConnectionException e) {
        if (e.getCause() instanceof HttpExceptionWithDetails) {
            HttpExceptionWithDetails httpEx = (HttpExceptionWithDetails)e.getCause();
            return new Response(httpEx.getReasonCode(), httpEx.getMessage(), null, null, (InputStream)new ByteArrayInputStream(httpEx.getReason().getBytes(StandardCharsets.UTF_8)));
        }
        throw e;
    }

    public Response invokeGET(UrlBuilder url, BindingSession session, BigInteger offset, BigInteger length) {
        try {
            return this.defaultInvoker.invokeGET(url, session, offset, length);
        }
        catch (CmisConnectionException e) {
            return this.handleConnectionException(e);
        }
    }

    public Response invokePOST(UrlBuilder url, String contentType, Output writer, BindingSession session) {
        try {
            return this.defaultInvoker.invokePOST(url, contentType, writer, session);
        }
        catch (CmisConnectionException e) {
            return this.handleConnectionException(e);
        }
    }

    public Response invokePUT(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, BindingSession session) {
        try {
            Response response = this.defaultInvoker.invokePUT(url, contentType, headers, writer, session);
            return new MaterializedResponse(response);
        }
        catch (CmisConnectionException e) {
            return this.handleConnectionException(e);
        }
        catch (IOException e) {
            log.debug("Error when materializing CMIS PUT response", (Throwable)e);
            return new Response(500, e.getMessage(), Collections.emptyMap(), (InputStream)new ByteArrayInputStream(new byte[0]), (InputStream)new ByteArrayInputStream(new byte[0]));
        }
    }

    public Response invokeDELETE(UrlBuilder url, BindingSession session) {
        try {
            return this.defaultInvoker.invokeDELETE(url, session);
        }
        catch (CmisConnectionException e) {
            return this.handleConnectionException(e);
        }
    }
}

