/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core;

import com.oxygenxml.cmis.core.RepositoryInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Collectors;
import ro.sync.basic.util.URLUtil;

public class CmisURL {
    public static final String CMIS_PROTOCOL = "cmis";
    private static final String PREFIX = "cmis://";
    private static final String SLASH_SYMBOL = "/";
    private final URL serverHttpUrl;
    private final String path;
    private final RepositoryInfo repositoryInfo;

    private CmisURL(URL serverHttpUrl, String repoId, String path) {
        this(serverHttpUrl, new RepositoryInfo(repoId, ""), path);
    }

    private CmisURL(URL serverHttpUrl, RepositoryInfo repoInfo, String path) {
        this.serverHttpUrl = serverHttpUrl;
        this.repositoryInfo = repoInfo;
        this.path = path;
    }

    public static URL parseServerUrl(String serverRootUrl) throws MalformedURLException {
        String encodedServerUrl = CmisURL.parseEncodedServerUrl(serverRootUrl);
        return new URL(URLUtil.decodeURIComponent((String)encodedServerUrl));
    }

    private static String parseEncodedServerUrl(String cmisUrl) throws MalformedURLException {
        String invalidMsg = "Invalid CMIS URL. ";
        if (!cmisUrl.startsWith(PREFIX)) {
            throw new MalformedURLException(invalidMsg + "Must start with \"cmis://\": " + cmisUrl);
        }
        int serverUrlEnd = cmisUrl.indexOf(SLASH_SYMBOL, PREFIX.length() + 1);
        if (serverUrlEnd == -1) {
            throw new MalformedURLException(invalidMsg + "Missing CMIS server URL: " + cmisUrl);
        }
        return cmisUrl.substring(PREFIX.length(), serverUrlEnd);
    }

    public static CmisURL parse(String cmisUrl) throws MalformedURLException {
        String encodedServerHttpUrl = CmisURL.parseEncodedServerUrl(cmisUrl);
        String decodedHttpServerUrl = URLUtil.decodeURIComponent((String)encodedServerHttpUrl);
        URL serverHttpUrl = new URL(decodedHttpServerUrl);
        int serverUrlEnd = PREFIX.length() + encodedServerHttpUrl.length();
        int repositoryEnd = cmisUrl.indexOf(SLASH_SYMBOL, serverUrlEnd + 1);
        if (repositoryEnd == -1) {
            throw new MalformedURLException("Invalid CMIS URL. Missing repository: " + cmisUrl);
        }
        String repository = URLUtil.decodeURIComponent((String)cmisUrl.substring(serverUrlEnd + 1, repositoryEnd));
        String path = URLUtil.decodeURIComponent((String)cmisUrl.substring(repositoryEnd));
        RepositoryInfo repositoryInfo = RepositoryInfo.fromURLPart(repository);
        return new CmisURL(serverHttpUrl, repositoryInfo, path);
    }

    public static CmisURL ofRepo(URL serverHttpUrl, String repoId) {
        return new CmisURL(serverHttpUrl, repoId, "");
    }

    public static CmisURL ofRepo(URL serverHttpUrl, String repoId, String path) {
        return new CmisURL(serverHttpUrl, repoId, path);
    }

    public static CmisURL ofRepoWithName(URL serverHttpUrl, RepositoryInfo repoInfo) {
        return new CmisURL(serverHttpUrl, repoInfo, "");
    }

    public String getRepositoryId() {
        return this.repositoryInfo.getId();
    }

    public URL getServerHttpUrl() {
        return this.serverHttpUrl;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.path.substring(this.path.lastIndexOf(SLASH_SYMBOL) + 1, this.path.length());
    }

    public String getFolderPath() {
        return this.path.substring(0, this.path.lastIndexOf(SLASH_SYMBOL) + 1);
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public String getExtension() {
        String fileName = this.getFileName();
        int lastDot = fileName.lastIndexOf(46);
        String extension = "";
        if (lastDot != -1) {
            extension = fileName.substring(lastDot + 1, fileName.length());
        }
        return extension;
    }

    public String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        sb.append(CMIS_PROTOCOL).append("://").append(URLUtil.encodeURIComponent((String)this.serverHttpUrl.toExternalForm())).append(SLASH_SYMBOL).append(URLUtil.encodeURIComponent((String)this.repositoryInfo.toUrlPart())).append(SLASH_SYMBOL);
        String encodedPath = Arrays.stream(this.path.split(SLASH_SYMBOL)).skip(1L).map(URLUtil::encodeURIComponent).collect(Collectors.joining(SLASH_SYMBOL));
        sb.append(encodedPath);
        return sb.toString();
    }
}

