/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.cmis.core;

import com.oxygenxml.cmis.core.CmisCredentials;
import com.oxygenxml.cmis.core.OxygenHttpInvoker;
import com.oxygenxml.cmis.core.ResourceController;
import com.oxygenxml.cmis.core.TokenCredentials;
import com.oxygenxml.cmis.core.UserCredentials;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;

public class CMISAccess {
    private SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
    private Session session;
    private Map<String, String> parameters;

    public CMISAccess clone() {
        CMISAccess cmisAccess = new CMISAccess();
        cmisAccess.parameters = this.parameters;
        cmisAccess.session = this.factory.createSession(this.parameters);
        return cmisAccess;
    }

    public void connectToRepo(URL connectionInfo, String repositoryID, CmisCredentials uc) throws CmisUnauthorizedException {
        this.parameters = new HashMap<String, String>();
        this.populateParameters(connectionInfo, this.parameters, uc);
        this.parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryID);
        this.session = this.factory.createSession(this.parameters);
    }

    private void populateParameters(URL connectionInfo, Map<String, String> parameters, CmisCredentials uc) {
        if (uc != null) {
            if (uc instanceof UserCredentials) {
                UserCredentials creds = (UserCredentials)uc;
                parameters.put("org.apache.chemistry.opencmis.user", creds.getUsername());
                parameters.put("org.apache.chemistry.opencmis.password", String.valueOf(creds.getPassword()));
            } else if (uc instanceof TokenCredentials) {
                TokenCredentials creds = (TokenCredentials)uc;
                String token = creds.getToken();
                parameters.put("org.apache.chemistry.opencmis.user", "ROLE_TICKET");
                parameters.put("org.apache.chemistry.opencmis.password", token);
            }
        }
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", connectionInfo.toString());
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameters.put("org.apache.chemistry.opencmis.binding.connecttimeout", "5000");
        parameters.put("org.apache.chemistry.opencmis.binding.readtimeout", "5000");
        parameters.put("org.apache.chemistry.opencmis.workaround.getLatestVersionWithVersionSeriesId", "true");
        parameters.put("org.apache.chemistry.opencmis.workaround.addNameOnCheckIn", "true");
        parameters.put("org.apache.chemistry.opencmis.workaround.omitChangeTokens", "true");
        parameters.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", OxygenHttpInvoker.class.getName());
    }

    public List<Repository> connectToServerGetRepositories(URL connectionInfo, CmisCredentials uc) throws CmisUnauthorizedException {
        HashMap<String, String> conParameters = new HashMap<String, String>();
        this.populateParameters(connectionInfo, conParameters, uc);
        return this.factory.getRepositories(conParameters);
    }

    public void pureConnectToServer(URL connectionInfo, CmisCredentials uc) {
        HashMap<String, String> conParameters = new HashMap<String, String>();
        this.populateParameters(connectionInfo, conParameters, uc);
        String repositoryID = ((Repository)this.factory.getRepositories(conParameters).get(0)).getId();
        conParameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryID);
        this.session = this.factory.createSession(conParameters);
    }

    public ResourceController createResourceController() {
        if (this.session == null) {
            throw new IllegalAccessError("Not connected to reposiotry. This controller can't be used.");
        }
        return new ResourceController(this.session);
    }

    public Session getSession() {
        return this.session;
    }

    public String getCMSProductName() {
        return this.session.getRepositoryInfo().getProductName();
    }

    public boolean isSharePoint() {
        String productName = this.getCMSProductName();
        return productName != null && productName.toLowerCase().contains("sharepoint");
    }
}

