/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.parent.diffs;

import com.oxygenxml.webapp.diff.AuthorUtil;
import com.oxygenxml.webapp.diff.parent.diffs.ParentDiff;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.api.Difference;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class SpecialCaseParentDiff
extends ParentDiff {
    private static final Logger log = LoggerFactory.getLogger(SpecialCaseParentDiff.class);
    private SpecialCaseParentDiffType specialCaseType;

    public SpecialCaseParentDiff(AuthorDocumentModel leftDoc, AuthorDocumentModel rightDoc, Difference child, SpecialCaseParentDiffType specialCaseType) {
        super(leftDoc, rightDoc, child);
        this.specialCaseType = specialCaseType;
    }

    public SpecialCaseParentDiffType getSpecialCaseType() {
        return this.specialCaseType;
    }

    @Override
    public boolean equals(Object obj) {
        boolean eq = false;
        if (super.equals(obj) && obj instanceof SpecialCaseParentDiff) {
            eq = this.getSpecialCaseType() == ((SpecialCaseParentDiff)((Object)obj)).getSpecialCaseType();
        }
        return eq;
    }

    @Override
    public int hashCode() {
        String hash = this.getSpecialCaseType().toString() + super.hashCode();
        return hash.hashCode();
    }

    private static Position createPosition(AuthorDocumentModel doc, int offset) throws BadLocationException {
        return doc.getAuthorDocumentController().createPositionInContent(offset);
    }

    @Override
    protected void updateOffsets() {
        if (this.recomputeIntervals) {
            try {
                Difference diff = (Difference)this.children.get(0);
                try {
                    if (this.specialCaseType == SpecialCaseParentDiffType.START_SENTINEL_ADDED || this.specialCaseType == SpecialCaseParentDiffType.START_SENTINEL_CHANGE || this.specialCaseType == SpecialCaseParentDiffType.END_SENTINEL_ADDED || this.specialCaseType == SpecialCaseParentDiffType.END_SENTINEL_CHANGE) {
                        this.updateOffsetsForSentinelChangeCases(diff);
                    } else if (this.specialCaseType == SpecialCaseParentDiffType.INLINE_CONTENT_LEFT || this.specialCaseType == SpecialCaseParentDiffType.INLINE_CONTENT_RIGHT || this.specialCaseType == SpecialCaseParentDiffType.INLINE_CONTENT_BOTH) {
                        this.updateOffsetsForInlineBetweenBlocksCase(diff);
                    }
                }
                catch (BadLocationException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            finally {
                this.recomputeIntervals = false;
            }
        }
    }

    private void updateOffsetsForSentinelChangeCases(Difference diff) throws BadLocationException {
        this.setLeftIntervalStartPosition(SpecialCaseParentDiff.createPosition(this.leftDoc, diff.getLeftIntervalStart()));
        this.setLeftIntervalEndPosition(SpecialCaseParentDiff.createPosition(this.leftDoc, diff.getLeftIntervalEnd()));
        this.setRightIntervalStartPosition(SpecialCaseParentDiff.createPosition(this.rightDoc, diff.getRightIntervalStart()));
        this.setRightIntervalEndPosition(SpecialCaseParentDiff.createPosition(this.rightDoc, diff.getRightIntervalEnd()));
    }

    private void updateOffsetsForInlineBetweenBlocksCase(Difference diff) throws BadLocationException {
        int leftStart = diff.getLeftIntervalStart();
        int leftEnd = diff.getLeftIntervalEnd();
        int rightStart = diff.getRightIntervalStart();
        int rightEnd = diff.getRightIntervalEnd();
        int[] lefts = null;
        if (this.specialCaseType == SpecialCaseParentDiffType.INLINE_CONTENT_LEFT || this.specialCaseType == SpecialCaseParentDiffType.INLINE_CONTENT_BOTH) {
            lefts = this.getInlineContentBetweenBlocks(this.leftDoc, leftStart, leftEnd);
            if (lefts == null) {
                log.error("Could not determine left interval for inline content between blocks");
            }
        } else {
            lefts = new int[]{leftStart, leftEnd};
        }
        int[] rights = null;
        if (this.specialCaseType == SpecialCaseParentDiffType.INLINE_CONTENT_RIGHT || this.specialCaseType == SpecialCaseParentDiffType.INLINE_CONTENT_BOTH) {
            rights = this.getInlineContentBetweenBlocks(this.rightDoc, rightStart, rightEnd);
            if (rights == null) {
                log.error("Could not determine right interval for inline content between blocks");
            }
        } else {
            rights = new int[]{rightStart, rightEnd};
        }
        if (lefts != null && rights != null) {
            this.setLeftIntervalStartPosition(SpecialCaseParentDiff.createPosition(this.leftDoc, lefts[0]));
            this.setLeftIntervalEndPosition(SpecialCaseParentDiff.createPosition(this.leftDoc, lefts[1]));
            this.setRightIntervalStartPosition(SpecialCaseParentDiff.createPosition(this.rightDoc, rights[0]));
            this.setRightIntervalEndPosition(SpecialCaseParentDiff.createPosition(this.rightDoc, rights[1]));
        }
    }

    private int[] getInlineContentBetweenBlocks(AuthorDocumentModel docModel, int startOffset, int endOffset) throws BadLocationException {
        int[] inlineContentInterval = null;
        AuthorParentNode blockAncestor = this.getCommonBlockAncestor(docModel, startOffset, endOffset);
        if (blockAncestor != null) {
            int lastStart = blockAncestor.getStartOffset() + 1;
            List<AuthorNode> blockChildrenWithLimit = this.getBlockChildrenWithLimit(docModel, blockAncestor, endOffset);
            for (AuthorNode child : blockChildrenWithLimit) {
                if (startOffset >= lastStart && child.getStartOffset() >= endOffset) {
                    inlineContentInterval = new int[]{lastStart, child.getStartOffset()};
                    break;
                }
                lastStart = child.getEndOffset() + 1;
            }
            if (inlineContentInterval == null && startOffset >= lastStart && blockAncestor.getEndOffset() + 1 > endOffset) {
                inlineContentInterval = new int[]{lastStart, blockAncestor.getEndOffset()};
            }
        }
        return inlineContentInterval;
    }

    private List<AuthorNode> getBlockChildrenWithLimit(AuthorDocumentModel docModel, AuthorParentNode parent, int limit) {
        ArrayList<AuthorNode> blockChildren = new ArrayList<AuthorNode>();
        for (AuthorNode child : parent.getContentNodes()) {
            Styles styles;
            if (!AuthorUtil.isBlock(child, styles = docModel.getAuthorAccess().getEditorAccess().getStyles(child), docModel.getAuthorDocumentController())) continue;
            blockChildren.add(child);
            if (child.getStartOffset() < limit) continue;
            break;
        }
        return blockChildren;
    }

    private AuthorParentNode getCommonBlockAncestor(AuthorDocumentModel docModel, int startOffset, int endOffset) throws BadLocationException {
        AuthorDocumentController controller = docModel.getAuthorDocumentController();
        AuthorDocument doc = controller.getAuthorDocumentNode();
        AuthorNode node = controller.getCommonParentNode(doc, startOffset, endOffset - 1);
        AuthorNode blockAncestor = AuthorUtil.getBlockAncestor(docModel.getAuthorAccess(), node);
        return blockAncestor instanceof AuthorParentNode ? (AuthorParentNode)blockAncestor : null;
    }

    public static enum SpecialCaseParentDiffType {
        START_SENTINEL_CHANGE,
        END_SENTINEL_CHANGE,
        START_SENTINEL_ADDED,
        END_SENTINEL_ADDED,
        INLINE_CONTENT_BOTH,
        INLINE_CONTENT_LEFT,
        INLINE_CONTENT_RIGHT;

    }
}

