/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.parent.diffs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ro.sync.basic.util.Equaler;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferenceParent;
import ro.sync.diff.api.DifferenceType;
import ro.sync.diff.text.DiffEntry;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public abstract class ParentDiff
extends DiffEntry
implements DifferenceParent {
    public static final Comparator<ParentDiff> DEFAULT_COMPARATOR = (o1, o2) -> {
        int result = o1 != null ? (o1.isEmpty() ? 0 : o1.compareTo(o2)) : 1;
        return result;
    };
    protected List<Difference> children = new ArrayList<Difference>();
    protected AuthorDocumentModel leftDoc;
    protected AuthorDocumentModel rightDoc;
    protected boolean recomputeIntervals = true;
    private DifferenceType initialChildType = null;

    public ParentDiff(AuthorDocumentModel leftDoc, AuthorDocumentModel rightDoc, Difference child) {
        super(null, null, null, null);
        this.leftDoc = leftDoc;
        this.rightDoc = rightDoc;
        this.addChildDiff(child);
        this.initialChildType = child.getType();
    }

    public void addChildDiff(Difference child) {
        this.children.add(child);
        this.recomputeIntervals = true;
    }

    public void removeChildDiff(Difference child) {
        this.children.remove(child);
        this.recomputeIntervals = true;
    }

    public int getLeftIntervalStart() {
        this.updateOffsets();
        return super.getLeftIntervalStart();
    }

    public int getLeftIntervalEnd() {
        this.updateOffsets();
        return super.getLeftIntervalEnd();
    }

    public int getRightIntervalStart() {
        this.updateOffsets();
        return super.getRightIntervalStart();
    }

    public int getRightIntervalEnd() {
        this.updateOffsets();
        return super.getRightIntervalEnd();
    }

    protected abstract void updateOffsets();

    public DifferenceType getType() {
        DifferenceType type = null;
        for (Difference child : this.children) {
            if (type == null) {
                type = child.getType();
                continue;
            }
            if (type == child.getType()) continue;
            type = DifferenceType.BOTH_CHANGED;
        }
        if (type == null) {
            type = this.initialChildType;
        }
        return type;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public List<Difference> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Difference: \n");
        sb.append("left interval : [").append(this.getLeftIntervalStart()).append(", ").append(this.getLeftIntervalEnd()).append("]\n");
        sb.append("right interval : [").append(this.getRightIntervalStart()).append(", ").append(this.getRightIntervalEnd()).append("]\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        boolean equals;
        boolean bl = equals = obj == this;
        if (!equals && obj instanceof ParentDiff) {
            ParentDiff other = (ParentDiff)((Object)obj);
            equals = Equaler.verifyListEquals(this.getChildren(), other.getChildren());
            if (equals) {
                boolean bl2 = equals = this.getLeftIntervalLength() == other.getLeftIntervalLength() && this.getRightIntervalLength() == other.getRightIntervalLength();
                if (equals) {
                    equals = this.getLeftIntervalStart() == other.getLeftIntervalStart() && this.getLeftIntervalEnd() == other.getLeftIntervalEnd() && this.getRightIntervalStart() == other.getRightIntervalStart() && this.getRightIntervalEnd() == other.getRightIntervalEnd();
                }
            }
        }
        return equals;
    }

    public int compareTo(Object o) {
        int toReturn = 0;
        if (o instanceof ParentDiff) {
            toReturn = ((ParentDiff)((Object)o)).isEmpty() ? (this.isEmpty() ? 0 : -1) : super.compareTo(o);
        }
        return toReturn;
    }

    public int hashCode() {
        String hash = "" + this.getLeftIntervalStart() + this.getLeftIntervalEnd() + this.getRightIntervalStart() + this.getRightIntervalEnd();
        return hash.hashCode();
    }

    public void markInvalid() {
        this.recomputeIntervals = true;
    }

    public boolean includes(Difference diff) {
        return this.getLeftIntervalStart() <= diff.getLeftIntervalStart() && this.getLeftIntervalEnd() >= diff.getLeftIntervalEnd() && this.getRightIntervalStart() <= diff.getRightIntervalStart() && this.getRightIntervalEnd() >= diff.getRightIntervalEnd();
    }
}

