/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.parent.diffs;

import com.oxygenxml.webapp.diff.parent.LineOffsetsUtil;
import com.oxygenxml.webapp.diff.parent.SortedDifferences;
import com.oxygenxml.webapp.diff.parent.diffs.Interval;
import com.oxygenxml.webapp.diff.parent.diffs.ParentDiff;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.api.Difference;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class BlockParentDiff
extends ParentDiff {
    private static final Logger log = LoggerFactory.getLogger(BlockParentDiff.class);
    private final SortedDifferences diffs;

    public BlockParentDiff(AuthorDocumentModel leftDoc, AuthorDocumentModel rightDoc, Difference child, SortedDifferences diffs) {
        super(leftDoc, rightDoc, child);
        this.diffs = diffs;
    }

    @Override
    protected void updateOffsets() {
        if (!this.recomputeIntervals) {
            return;
        }
        if (this.children.isEmpty()) {
            this.setIsMerged();
            return;
        }
        this.recomputeIntervals = false;
        AuthorAccess leftDocAccess = this.leftDoc.getAuthorAccess();
        AuthorAccess rightDocAccess = this.rightDoc.getAuthorAccess();
        Interval leftInterval = this.computeLeftInterval();
        Interval rightInterval = this.computeRightInterval();
        Interval leftBlockInterval = this.extendToBlockInterval(leftInterval, leftDocAccess);
        Interval rightBlockInterval = this.extendToBlockInterval(rightInterval, rightDocAccess);
        if (leftInterval.isEmpty() && rightInterval.equals(rightBlockInterval)) {
            leftBlockInterval = leftInterval;
        } else if (rightInterval.isEmpty() && leftInterval.equals(leftBlockInterval)) {
            rightBlockInterval = rightInterval;
        } else {
            int projectedRightStartExtension;
            int rightStartExtension = rightInterval.getStart() - rightBlockInterval.getStart();
            if (rightStartExtension > (projectedRightStartExtension = this.diffs.getProjectedLengthOnRight(leftBlockInterval.getStart(), leftInterval.getStart()))) {
                int projectedLeftStartExtension = this.diffs.getProjectedLengthOnLeft(rightBlockInterval.getStart(), rightInterval.getStart());
                leftBlockInterval = new Interval(leftInterval.getStart() - projectedLeftStartExtension, leftBlockInterval.getEnd());
            } else if (rightStartExtension < projectedRightStartExtension) {
                rightBlockInterval = new Interval(rightInterval.getStart() - projectedRightStartExtension, rightBlockInterval.getEnd());
            }
            int rightEndExtension = rightBlockInterval.getEnd() - rightInterval.getEnd();
            int projectedRightEndExtension = this.diffs.getProjectedLengthOnRight(leftInterval.getEnd(), leftBlockInterval.getEnd());
            if (rightEndExtension > projectedRightEndExtension) {
                int projectedLeftEndExtension = this.diffs.getProjectedLengthOnLeft(rightInterval.getEnd(), rightBlockInterval.getEnd());
                leftBlockInterval = new Interval(leftBlockInterval.getStart(), leftInterval.getEnd() + projectedLeftEndExtension);
            } else if (rightEndExtension < projectedRightEndExtension) {
                rightBlockInterval = new Interval(rightBlockInterval.getStart(), rightInterval.getEnd() + projectedRightEndExtension);
            }
        }
        this.setEndpoints(leftDocAccess, rightDocAccess, leftBlockInterval, rightBlockInterval);
    }

    private void setEndpoints(AuthorAccess leftDocAccess, AuthorAccess rightDocAccess, Interval leftBlockInterval, Interval rightBlockInterval) {
        try {
            this.setLeftIntervalStartPosition(this.createPosition(leftDocAccess, leftBlockInterval.getStart()));
            this.setLeftIntervalEndPosition(this.createPosition(leftDocAccess, leftBlockInterval.getEnd()));
            this.setRightIntervalStartPosition(this.createPosition(rightDocAccess, rightBlockInterval.getStart()));
            this.setRightIntervalEndPosition(this.createPosition(rightDocAccess, rightBlockInterval.getEnd()));
        }
        catch (BadLocationException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private Interval extendToBlockInterval(Interval interval, AuthorAccess docAccess) {
        int blockStart = LineOffsetsUtil.getBlockStartOffset(interval.getStart(), docAccess);
        int blockEnd = this.determineBlockEndPosition(interval, docAccess);
        Interval blockInterval = new Interval(blockStart, blockEnd);
        if (!interval.isEmpty()) {
            List nodesToSelect = Collections.emptyList();
            try {
                nodesToSelect = docAccess.getDocumentController().getNodesToSelect(blockStart, blockEnd);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (!nodesToSelect.isEmpty()) {
                AuthorNode firstNode = (AuthorNode)nodesToSelect.get(0);
                AuthorNode lastNode = (AuthorNode)nodesToSelect.get(nodesToSelect.size() - 1);
                blockInterval = new Interval(firstNode.getStartOffset(), lastNode.getEndOffset() + 1);
            }
        }
        return blockInterval;
    }

    private Interval computeRightInterval() {
        int rightStart = Integer.MAX_VALUE;
        int rightEnd = Integer.MIN_VALUE;
        for (Difference child : this.children) {
            rightStart = Math.min(rightStart, child.getRightIntervalStart());
            rightEnd = Math.max(rightEnd, child.getRightIntervalEnd());
        }
        return new Interval(rightStart, rightEnd);
    }

    private Interval computeLeftInterval() {
        int leftStart = Integer.MAX_VALUE;
        int leftEnd = Integer.MIN_VALUE;
        for (Difference child : this.children) {
            leftStart = Math.min(leftStart, child.getLeftIntervalStart());
            leftEnd = Math.max(leftEnd, child.getLeftIntervalEnd());
        }
        return new Interval(leftStart, leftEnd);
    }

    private Position createPosition(AuthorAccess access, int offset) throws BadLocationException {
        AuthorDocumentController documentController = access.getDocumentController();
        offset = Math.max(0, offset);
        offset = Math.min(documentController.getAuthorDocumentNode().getEndOffset(), offset);
        return documentController.createPositionInContent(offset);
    }

    private int determineBlockEndPosition(Interval interval, AuthorAccess authorAccess) {
        int endPosition;
        int docLen = authorAccess.getDocumentController().getAuthorDocumentNode().getLength();
        if (LineOffsetsUtil.getBlockStartOffset(interval.getEnd(), authorAccess) != interval.getEnd()) {
            int offsetOfLineEnd = LineOffsetsUtil.getBlockEndOffset(interval.getStart(), interval.getEnd(), authorAccess);
            if (offsetOfLineEnd > docLen) {
                offsetOfLineEnd = docLen;
            }
            endPosition = offsetOfLineEnd;
        } else {
            endPosition = interval.getEnd();
        }
        return endPosition;
    }
}

