/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.parent;

import com.oxygenxml.webapp.diff.AuthorUtil;
import com.oxygenxml.webapp.diff.parent.diffs.SpecialCaseParentDiff;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.api.Difference;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

class SpecialCaseParendDiffDetector {
    private static final Logger log = LoggerFactory.getLogger(SpecialCaseParendDiffDetector.class);
    private AuthorDocumentModel leftDoc;
    private AuthorDocumentModel rightDoc;

    public SpecialCaseParendDiffDetector(AuthorDocumentModel leftDoc, AuthorDocumentModel rightDoc) {
        this.leftDoc = leftDoc;
        this.rightDoc = rightDoc;
    }

    public SpecialCaseParentDiff.SpecialCaseParentDiffType getSpecialCaseParentType(Difference diff) throws BadLocationException {
        SpecialCaseParentDiff.SpecialCaseParentDiffType specialCase = null;
        if (!this.isInsideReference(diff)) {
            try {
                specialCase = this.getSentinelChangeType(diff);
                if (specialCase == null) {
                    specialCase = this.getInlineChangeType(diff);
                }
            }
            catch (BadLocationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return specialCase;
    }

    private boolean isInsideReference(Difference diff) throws BadLocationException {
        return this.isInsideReference(diff.getLeftIntervalStart(), diff.getLeftIntervalEnd() - 1, this.leftDoc.getAuthorDocumentController()) || this.isInsideReference(diff.getRightIntervalStart(), diff.getRightIntervalEnd() - 1, this.rightDoc.getAuthorDocumentController());
    }

    private boolean isInsideReference(int startOffset, int endOffset, AuthorDocumentController ctrl) throws BadLocationException {
        AuthorNode node = ctrl.getCommonParentNode(ctrl.getAuthorDocumentNode(), startOffset, endOffset);
        return AuthorUtil.getReferenceAncestor(node, ctrl) != null;
    }

    private SpecialCaseParentDiff.SpecialCaseParentDiffType getInlineChangeType(Difference diff) throws BadLocationException {
        SpecialCaseParentDiff.SpecialCaseParentDiffType specialCase = null;
        boolean inlineLeft = SpecialCaseParendDiffDetector.isInlineContentBetweenBlocks(this.leftDoc, diff.getLeftIntervalStart(), diff.getLeftIntervalEnd());
        boolean inlineRight = SpecialCaseParendDiffDetector.isInlineContentBetweenBlocks(this.rightDoc, diff.getRightIntervalStart(), diff.getRightIntervalEnd());
        if (inlineLeft && inlineRight) {
            specialCase = SpecialCaseParentDiff.SpecialCaseParentDiffType.INLINE_CONTENT_BOTH;
        } else if (inlineLeft) {
            specialCase = SpecialCaseParentDiff.SpecialCaseParentDiffType.INLINE_CONTENT_LEFT;
        } else if (inlineRight) {
            specialCase = SpecialCaseParentDiff.SpecialCaseParentDiffType.INLINE_CONTENT_RIGHT;
        }
        return specialCase;
    }

    private SpecialCaseParentDiff.SpecialCaseParentDiffType getSentinelChangeType(Difference diff) throws BadLocationException {
        SpecialCaseParentDiff.SpecialCaseParentDiffType specialCaseType = null;
        int leftIntervalLen = diff.getLeftIntervalEnd() - diff.getLeftIntervalStart();
        int rightIntervalLength = diff.getRightIntervalEnd() - diff.getRightIntervalStart();
        int leftDiffOffset = diff.getLeftIntervalStart();
        int rightDiffOffset = diff.getRightIntervalStart();
        if (leftIntervalLen == 1 && rightIntervalLength == 1) {
            specialCaseType = this.getSentinelChangeType(leftDiffOffset, rightDiffOffset);
        } else if (leftIntervalLen == 1 && rightIntervalLength == 0) {
            specialCaseType = this.getSentinelAddedChangeType(leftDiffOffset, this.leftDoc);
        } else if (leftIntervalLen == 0 && rightIntervalLength == 1) {
            specialCaseType = this.getSentinelAddedChangeType(rightDiffOffset, this.rightDoc);
        }
        return specialCaseType;
    }

    private SpecialCaseParentDiff.SpecialCaseParentDiffType getSentinelAddedChangeType(int diffOffset, AuthorDocumentModel doc) throws BadLocationException {
        SpecialCaseParentDiff.SpecialCaseParentDiffType specialCaseType = null;
        if (this.isOnStartSentinel(doc, diffOffset)) {
            specialCaseType = SpecialCaseParentDiff.SpecialCaseParentDiffType.START_SENTINEL_ADDED;
        } else if (this.isOnEndSentinel(doc, diffOffset)) {
            specialCaseType = SpecialCaseParentDiff.SpecialCaseParentDiffType.END_SENTINEL_ADDED;
        }
        return specialCaseType;
    }

    private SpecialCaseParentDiff.SpecialCaseParentDiffType getSentinelChangeType(int leftDiffOffset, int rightDiffOffset) throws BadLocationException {
        SpecialCaseParentDiff.SpecialCaseParentDiffType specialCaseType = null;
        if (this.isOnStartSentinel(this.leftDoc, leftDiffOffset) && this.isOnStartSentinel(this.rightDoc, rightDiffOffset)) {
            specialCaseType = SpecialCaseParentDiff.SpecialCaseParentDiffType.START_SENTINEL_CHANGE;
        } else if (this.isOnEndSentinel(this.leftDoc, leftDiffOffset) && this.isOnEndSentinel(this.rightDoc, rightDiffOffset)) {
            specialCaseType = SpecialCaseParentDiff.SpecialCaseParentDiffType.END_SENTINEL_CHANGE;
        }
        return specialCaseType;
    }

    private static boolean isInlineContentBetweenBlocks(AuthorDocumentModel docModel, int startOffset, int endOffset) throws BadLocationException {
        AuthorDocumentController controller = docModel.getAuthorDocumentController();
        AuthorDocument doc = controller.getAuthorDocumentNode();
        boolean inlineContentBetweenBlocks = false;
        AuthorNode node = controller.getCommonParentNode(doc, startOffset, --endOffset);
        AuthorNode blockAncestor = AuthorUtil.getBlockAncestor(docModel.getAuthorAccess(), node);
        if (blockAncestor instanceof AuthorElement && startOffset > blockAncestor.getStartOffset() + 1 && endOffset < blockAncestor.getEndOffset()) {
            inlineContentBetweenBlocks = SpecialCaseParendDiffDetector.isInlineContentBetweenBlocks(docModel, startOffset, endOffset, blockAncestor);
        }
        return inlineContentBetweenBlocks;
    }

    private static boolean isInlineContentBetweenBlocks(AuthorDocumentModel docModel, int startOffset, int endOffset, AuthorNode blockAncestor) {
        boolean inlineContentBetweenBlocks = true;
        List contentNodes = ((AuthorElement)blockAncestor).getContentNodes();
        boolean foundBlocks = false;
        for (AuthorNode child : contentNodes) {
            Styles styles;
            if (!AuthorUtil.isBlock(child, styles = docModel.getAuthorAccess().getEditorAccess().getStyles(child), docModel.getAuthorDocumentController())) continue;
            foundBlocks = true;
            if (!(startOffset >= child.getStartOffset() && startOffset <= child.getEndOffset() || endOffset >= child.getStartOffset() && endOffset <= child.getEndOffset()) && (startOffset > child.getStartOffset() || endOffset < child.getEndOffset())) continue;
            inlineContentBetweenBlocks = false;
            break;
        }
        return foundBlocks && inlineContentBetweenBlocks;
    }

    private boolean isOnStartSentinel(AuthorDocumentModel docModel, int offset) throws BadLocationException {
        AuthorDocumentController controller = docModel.getAuthorAccess().getDocumentController();
        AuthorNode nodeAtOffset = controller.getNodeAtOffset(offset + 1);
        return nodeAtOffset.getStartOffset() == offset;
    }

    private boolean isOnEndSentinel(AuthorDocumentModel docModel, int offset) throws BadLocationException {
        AuthorDocumentController controller = docModel.getAuthorAccess().getDocumentController();
        AuthorNode nodeAtOffset = controller.getNodeAtOffset(offset);
        return nodeAtOffset.getEndOffset() == offset;
    }
}

