/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.parent;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferenceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;

public class SortedDifferences {
    private static final Logger log = LoggerFactory.getLogger(SortedDifferences.class);
    private List<Difference> reportedDiffs;
    private List<Difference> actualDiffs;

    public SortedDifferences(List<Difference> diffs) {
        this.reportedDiffs = diffs;
        this.actualDiffs = diffs;
    }

    public void addDifferencesFromReferenceNodes(AuthorAccess leftDocument, AuthorAccess rightDocument) {
        ArrayList<AuthorNode> refs = new ArrayList<AuthorNode>();
        this.collectReferences((AuthorNode)leftDocument.getDocumentController().getAuthorDocumentNode(), refs);
        for (AuthorNode ref : refs) {
            int rightMostDiffLessThan = this.rightMostDiffLessThan(ref.getStartOffset(), true);
            if (rightMostDiffLessThan != -1 && this.actualDiffs.get(rightMostDiffLessThan).getLeftIntervalEnd() >= ref.getEndOffset()) continue;
            int rightStart = ref.getStartOffset();
            if (rightMostDiffLessThan != -1) {
                Difference difference = this.actualDiffs.get(rightMostDiffLessThan);
                rightStart = difference.getRightIntervalEnd() + ref.getStartOffset() - difference.getLeftIntervalEnd();
            }
            try {
                AuthorDocumentController rightController = rightDocument.getDocumentController();
                OffsetInformation offsetInformation = rightController.getContentInformationAtOffset(rightStart);
                AuthorNode correspondingRefNode = offsetInformation.getNodeForMarkerOffset();
                if (correspondingRefNode == null || correspondingRefNode.getType() != 7) continue;
                RefNodeDiff refNodeDiff = new RefNodeDiff(ref, correspondingRefNode);
                this.addRefNodeDiffIfNeeded(refNodeDiff);
            }
            catch (BadLocationException e) {
                log.debug("Error when generating diffs for #reference nodes.", (Throwable)e);
            }
        }
    }

    private void addRefNodeDiffIfNeeded(RefNodeDiff refNodeDiff) {
        if (!refNodeDiff.hasSameLength()) {
            if (this.actualDiffs == this.reportedDiffs) {
                this.actualDiffs = new ArrayList<Difference>(this.reportedDiffs);
            }
            this.actualDiffs.add(refNodeDiff);
            Collections.sort(this.actualDiffs, (o1, o2) -> o1.getLeftIntervalStart() - o2.getLeftIntervalStart());
        }
    }

    private void collectReferences(AuthorNode node, List<AuthorNode> references) {
        if (node.getType() == 7) {
            references.add(node);
        } else if (node instanceof AuthorParentNode) {
            List children = ((AuthorParentNode)node).getContentNodes();
            for (AuthorNode child : children) {
                this.collectReferences(child, references);
            }
        }
    }

    public int getProjectedLengthOnRight(int start, int end) {
        List<Difference> rangesBetweenLeft = this.getRangesBetween(start, end, true);
        return end - start - this.getTotalLengthLeft(rangesBetweenLeft) + this.getTotalLengthRight(rangesBetweenLeft);
    }

    public int getProjectedLengthOnLeft(int start, int end) {
        List<Difference> rangesBetweenRight = this.getRangesBetween(start, end, false);
        return end - start - this.getTotalLengthRight(rangesBetweenRight) + this.getTotalLengthLeft(rangesBetweenRight);
    }

    private int getTotalLengthLeft(List<Difference> diffs) {
        int length = 0;
        for (Difference diff : diffs) {
            length += diff.getLeftIntervalEnd() - diff.getLeftIntervalStart();
        }
        return length;
    }

    private int getTotalLengthRight(List<Difference> diffs) {
        int length = 0;
        for (Difference diff : diffs) {
            length += diff.getRightIntervalEnd() - diff.getRightIntervalStart();
        }
        return length;
    }

    @VisibleForTesting
    List<Difference> getRangesBetween(int start, int end, boolean leftEditor) {
        Difference firstDiff;
        int endIndex;
        int startIndex = this.rightMostDiffLessThan(start, leftEditor);
        if (startIndex < (endIndex = this.rightMostDiffLessThan(end, leftEditor)) && this.isEmptyAtOffset(leftEditor, firstDiff = this.actualDiffs.get(startIndex + 1), start)) {
            ++startIndex;
        }
        return this.actualDiffs.subList(startIndex + 1, endIndex + 1);
    }

    private boolean isEmptyAtOffset(boolean leftEditor, Difference diff, int offset) {
        if (leftEditor) {
            return diff.getLeftIntervalStart() == diff.getLeftIntervalEnd() && diff.getLeftIntervalStart() == offset;
        }
        return diff.getRightIntervalStart() == diff.getRightIntervalEnd() && diff.getRightIntervalStart() == offset;
    }

    private int rightMostDiffLessThan(int offset, boolean leftEditor) {
        int left = 0;
        int right = this.actualDiffs.size();
        while (left < right) {
            int midValue;
            int mid = (left + right) / 2;
            Difference midDiff = this.actualDiffs.get(mid);
            int n = midValue = leftEditor ? midDiff.getLeftIntervalStart() : midDiff.getRightIntervalStart();
            if (midValue >= offset) {
                right = mid;
                continue;
            }
            left = mid + 1;
        }
        return left - 1;
    }

    public List<Difference> getDiffs() {
        return this.reportedDiffs;
    }

    private final class RefNodeDiff
    implements Difference {
        private AuthorNode left;
        private AuthorNode right;

        public RefNodeDiff(AuthorNode left, AuthorNode right) {
            this.left = left;
            this.right = right;
        }

        public DifferenceType getType() {
            return null;
        }

        public int getRightIntervalStart() {
            return this.right.getStartOffset();
        }

        public int getRightIntervalEnd() {
            return this.right.getEndOffset();
        }

        public int getLeftIntervalStart() {
            return this.left.getStartOffset();
        }

        public int getLeftIntervalEnd() {
            return this.left.getEndOffset();
        }

        public boolean hasSameLength() {
            return this.left.getEndOffset() - this.left.getStartOffset() == this.right.getEndOffset() - this.right.getStartOffset();
        }
    }
}

