/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.parent;

import com.oxygenxml.webapp.diff.parent.SortedDifferences;
import com.oxygenxml.webapp.diff.parent.SpecialCaseParendDiffDetector;
import com.oxygenxml.webapp.diff.parent.diffs.BlockParentDiff;
import com.oxygenxml.webapp.diff.parent.diffs.ParentDiff;
import com.oxygenxml.webapp.diff.parent.diffs.SpecialCaseParentDiff;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.SortedList;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferenceParent;
import ro.sync.diff.text.DiffEntry;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class ParentDiffsProvider {
    private static final Logger log = LoggerFactory.getLogger(ParentDiffsProvider.class);
    private AuthorDocumentModel leftDoc;
    private AuthorDocumentModel rightDoc;
    private SortedDifferences diffs;
    public static final Comparator<Difference> DIFF_COMPARATOR = (p1, p2) -> {
        int firstStart = p1.getLeftIntervalStart();
        int firstEnd = p1.getLeftIntervalEnd();
        int secondStart = p2.getLeftIntervalStart();
        int secondEnd = p2.getLeftIntervalEnd();
        int result = p1 == p2 ? 0 : (firstStart == secondStart ? (firstEnd > secondEnd ? 1 : -1) : (firstStart > secondStart ? 1 : -1));
        return result;
    };

    public ParentDiffsProvider(AuthorDocumentModel leftDoc, AuthorDocumentModel rightDoc, List<Difference> diffs) {
        this.leftDoc = leftDoc;
        this.rightDoc = rightDoc;
        this.diffs = new SortedDifferences(diffs);
        this.diffs.addDifferencesFromReferenceNodes(leftDoc.getAuthorAccess(), rightDoc.getAuthorAccess());
    }

    public List<ParentDiff> getParentDiffs() {
        SortedList parents = new SortedList(DIFF_COMPARATOR);
        SpecialCaseParendDiffDetector specialCaseDetector = new SpecialCaseParendDiffDetector(this.leftDoc, this.rightDoc);
        HashMap<Integer, SpecialCaseParentDiff> mapStartOffToStartSentChangeDiff = new HashMap<Integer, SpecialCaseParentDiff>();
        for (Difference diff : this.diffs.getDiffs()) {
            if (!(diff instanceof DiffEntry) || ((DiffEntry)diff).isMerged()) continue;
            try {
                this.detectParentForDiffEntry(diff, (List<ParentDiff>)parents, specialCaseDetector, mapStartOffToStartSentChangeDiff);
            }
            catch (BadLocationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        this.mergeParentDiffs((List<ParentDiff>)parents);
        for (DifferenceParent differenceParent : parents) {
            differenceParent.getChildren().sort((a, b) -> {
                int result = a.getLeftIntervalStart() - b.getLeftIntervalStart();
                if (result == 0) {
                    result = a.getLeftIntervalEnd() - b.getLeftIntervalEnd();
                }
                return result;
            });
        }
        return parents;
    }

    private void mergeParentDiffs(List<ParentDiff> parents) {
        if (parents.size() < 2) {
            return;
        }
        ListIterator<ParentDiff> iterator = parents.listIterator();
        ParentDiff lastParent = null;
        while (iterator.hasNext()) {
            List<Difference> children;
            ParentDiff currentParent = iterator.next();
            if (lastParent != null && lastParent.includes((Difference)currentParent)) {
                children = currentParent.getChildren();
                for (Difference child : children) {
                    lastParent.addChildDiff(child);
                }
                iterator.remove();
                continue;
            }
            if (lastParent != null && currentParent.includes((Difference)lastParent)) {
                children = lastParent.getChildren();
                for (Difference child : children) {
                    currentParent.addChildDiff(child);
                }
                iterator.previous();
                iterator.previous();
                iterator.remove();
                iterator.next();
                lastParent = currentParent;
                continue;
            }
            lastParent = currentParent;
        }
    }

    private boolean mergeStartAndEndSentinelChange(Map<Integer, SpecialCaseParentDiff> mapStartOffToStartSentChangeDiff, Difference endSentinelDiff, List<ParentDiff> parents) {
        boolean added = false;
        if (!mapStartOffToStartSentChangeDiff.isEmpty()) {
            SpecialCaseParentDiff toMergeWith;
            int startSentinelOffset = -1;
            try {
                AuthorNode node;
                int endSentinelOffset;
                if (endSentinelDiff.getLeftIntervalStart() != endSentinelDiff.getLeftIntervalEnd()) {
                    endSentinelOffset = endSentinelDiff.getLeftIntervalStart();
                    node = this.leftDoc.getAuthorDocumentController().getNodeAtOffset(endSentinelOffset);
                    startSentinelOffset = node.getStartOffset();
                } else {
                    endSentinelOffset = endSentinelDiff.getRightIntervalStart();
                    node = this.rightDoc.getAuthorDocumentController().getNodeAtOffset(endSentinelOffset);
                    startSentinelOffset = node.getStartOffset();
                }
            }
            catch (BadLocationException e) {
                log.error((Object)e, (Throwable)e);
            }
            if (startSentinelOffset != -1 && (toMergeWith = mapStartOffToStartSentChangeDiff.get(startSentinelOffset)) != null) {
                parents.remove((Object)toMergeWith);
                Difference startChild = toMergeWith.getChildren().get(0);
                BlockParentDiff newBlockParentDiff = new BlockParentDiff(this.leftDoc, this.rightDoc, startChild, this.diffs);
                newBlockParentDiff.addChildDiff(endSentinelDiff);
                parents.add(newBlockParentDiff);
                added = true;
            }
        }
        return added;
    }

    private void mapStartSentinelChange(SpecialCaseParentDiff startSentinelChange, Map<Integer, SpecialCaseParentDiff> mapStartOffToStartSentChangeDiff) {
        int sentinelOffset = -1;
        sentinelOffset = startSentinelChange.getLeftIntervalStart() != startSentinelChange.getLeftIntervalEnd() ? startSentinelChange.getLeftIntervalStart() : startSentinelChange.getRightIntervalStart();
        mapStartOffToStartSentChangeDiff.put(sentinelOffset, startSentinelChange);
    }

    private void detectParentForDiffEntry(Difference diff, List<ParentDiff> parents, SpecialCaseParendDiffDetector specialCaseDetector, Map<Integer, SpecialCaseParentDiff> mapStartOffToStartSentChangeDiff) throws BadLocationException {
        ParentDiff existingParent = this.getParentMatchingDiff(diff, parents);
        if (existingParent != null) {
            existingParent.addChildDiff(diff);
        } else {
            SpecialCaseParentDiff.SpecialCaseParentDiffType specialCaseType = specialCaseDetector.getSpecialCaseParentType(diff);
            if (specialCaseType != null) {
                this.addSpecialCaseParentDiff(diff, parents, mapStartOffToStartSentChangeDiff, specialCaseType);
            } else {
                parents.add(new BlockParentDiff(this.leftDoc, this.rightDoc, diff, this.diffs));
            }
        }
    }

    private void addSpecialCaseParentDiff(Difference diff, List<ParentDiff> parents, Map<Integer, SpecialCaseParentDiff> mapStartOffToStartSentChangeDiff, SpecialCaseParentDiff.SpecialCaseParentDiffType specialCaseType) {
        boolean specialParentDiffAdded = false;
        if (specialCaseType == SpecialCaseParentDiff.SpecialCaseParentDiffType.END_SENTINEL_CHANGE || specialCaseType == SpecialCaseParentDiff.SpecialCaseParentDiffType.END_SENTINEL_ADDED) {
            specialParentDiffAdded = this.mergeStartAndEndSentinelChange(mapStartOffToStartSentChangeDiff, diff, parents);
        }
        if (!specialParentDiffAdded) {
            SpecialCaseParentDiff newParent = new SpecialCaseParentDiff(this.leftDoc, this.rightDoc, diff, specialCaseType);
            parents.add(newParent);
            if (specialCaseType == SpecialCaseParentDiff.SpecialCaseParentDiffType.START_SENTINEL_CHANGE || specialCaseType == SpecialCaseParentDiff.SpecialCaseParentDiffType.START_SENTINEL_ADDED) {
                this.mapStartSentinelChange(newParent, mapStartOffToStartSentChangeDiff);
            }
        }
    }

    private ParentDiff getParentMatchingDiff(Difference diff, List<ParentDiff> parents) {
        ParentDiff parentDiff;
        ParentDiff mergingParent = null;
        if (!parents.isEmpty() && (parentDiff = parents.get(parents.size() - 1)).includes(diff)) {
            mergingParent = parentDiff;
        }
        return mergingParent;
    }
}

