/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.parent;

import com.oxygenxml.webapp.diff.AuthorUtil;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorNode;

public class LineOffsetsUtil {
    private static final Logger log = LoggerFactory.getLogger(LineOffsetsUtil.class);

    private LineOffsetsUtil() {
    }

    public static int getBlockStartOffset(int currentOffset, AuthorAccess authorAccess) {
        int blockStartOffset = -1;
        currentOffset = LineOffsetsUtil.checkCurrentOffsetIsInDocument(currentOffset, authorAccess);
        try {
            OffsetInformation information = authorAccess.getDocumentController().getContentInformationAtOffset(currentOffset);
            int positionType = information.getPositionType();
            AuthorNode node = positionType == 1 ? information.getNodeForMarkerOffset() : information.getNodeForOffset();
            node = AuthorUtil.getBlockAncestor(authorAccess, node);
            if (node != null) {
                blockStartOffset = node.getStartOffset();
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e, (Throwable)e);
        }
        return blockStartOffset;
    }

    private static int checkCurrentOffsetIsInDocument(int currentOffset, AuthorAccess authorAccess) {
        AuthorDocument authorDocumentNode = authorAccess.getDocumentController().getAuthorDocumentNode();
        if (currentOffset < authorDocumentNode.getStartOffset()) {
            currentOffset = authorDocumentNode.getStartOffset();
        }
        if (currentOffset > authorDocumentNode.getEndOffset()) {
            currentOffset = authorDocumentNode.getEndOffset();
        }
        return currentOffset;
    }

    public static int getBlockEndOffset(int startOffset, int endOffset, AuthorAccess authorAccess) {
        int blockEndOffset = -1;
        endOffset = LineOffsetsUtil.checkCurrentOffsetIsInDocument(endOffset, authorAccess);
        try {
            OffsetInformation information;
            int positionType;
            AuthorNode node = null;
            if (startOffset < endOffset && (positionType = (information = authorAccess.getDocumentController().getContentInformationAtOffset(endOffset - 1)).getPositionType()) == 2) {
                node = information.getNodeForMarkerOffset();
            }
            if (node == null) {
                node = authorAccess.getDocumentController().getNodeAtOffset(endOffset);
            }
            if ((node = AuthorUtil.getBlockAncestor(authorAccess, node)) != null) {
                blockEndOffset = node.getEndOffset() + 1;
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e, (Throwable)e);
        }
        return blockEndOffset;
    }
}

