/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations.parentdescriptor;

import com.oxygenxml.webapp.diff.AuthorUtil;
import com.oxygenxml.webapp.diff.model.DiffInterval;
import com.oxygenxml.webapp.diff.model.ParentDiffInterval;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.AllDifferences;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.BlocksParentDiffDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.EmptyParentDiffDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.InlinesParentDiffDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.ParentDiffDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.SentinelParentDiffDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.UnknownParentDiffDescriptor;
import com.oxygenxml.webapp.diff.parent.diffs.SpecialCaseParentDiff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorIdIndex;
import ro.sync.servlet.patches.CaretPosition;

public class DiffDescriptorsUtil {
    private static final Logger log = LoggerFactory.getLogger(DiffDescriptorsUtil.class);

    private DiffDescriptorsUtil() {
    }

    public static AllDifferences getDiffHighlightsInfo(List<ParentDiffInterval> intervals, AuthorDocumentModel docModel, boolean leftDocument) {
        ArrayList<ParentDiffDescriptor> parentDescriptors = new ArrayList<ParentDiffDescriptor>();
        List<String> secondLevelDiffIds = new ArrayList<String>();
        if (intervals != null) {
            ArrayList<List<DiffInterval>> secondaryDiffs = new ArrayList<List<DiffInterval>>(intervals.size());
            for (ParentDiffInterval parentInterval : intervals) {
                try {
                    ParentDiffDescriptor parentDiffDescr = DiffDescriptorsUtil.getParentDiffDescriptor(parentInterval, docModel, leftDocument);
                    secondaryDiffs.add(parentInterval.getDiffIntervals());
                    parentDescriptors.add(parentDiffDescr);
                }
                catch (BadLocationException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            secondLevelDiffIds = secondaryDiffs.stream().flatMap(Collection::stream).sorted().map(diffInterval -> diffInterval.getId()).collect(Collectors.toList());
        }
        return new AllDifferences(parentDescriptors, secondLevelDiffIds);
    }

    private static ParentDiffDescriptor getParentDiffDescriptor(ParentDiffInterval parentInterval, AuthorDocumentModel docModel, boolean leftDocument) throws BadLocationException {
        ParentDiffDescriptor parentDiffDescr = null;
        AuthorDocumentController docCtrl = docModel.getAuthorAccess().getDocumentController();
        AuthorIdIndex nodeIndexer = docModel.getNodeIndexer();
        int start = parentInterval.getStart();
        int end = parentInterval.getEnd() - 1;
        String id = parentInterval.getId();
        String type = parentInterval.getType().toString();
        if (log.isDebugEnabled()) {
            log.debug("Get descriptor for: start {}, end {}", (Object)start, (Object)end);
        }
        if (start > end) {
            AuthorNode node;
            DiffInterval diffInterval;
            List<DiffInterval> diffs = parentInterval.getDiffIntervals();
            if (diffs.size() == 1 && (diffInterval = diffs.get(0)).getStart() == diffInterval.getEnd() && AuthorUtil.getReferenceAncestor(node = docCtrl.getNodeAtOffset(diffInterval.getStart()), docCtrl) == null) {
                Optional emptyPosition = CaretPosition.createCaretPosition((int)start, (AuthorAccess)docModel.getAuthorAccess(), (AuthorIdIndex)docModel.getNodeIndexer(), (boolean)true);
                if (emptyPosition.isPresent()) {
                    CaretPosition pos = (CaretPosition)emptyPosition.get();
                    parentDiffDescr = new EmptyParentDiffDescriptor(id, type, pos.nodeId, pos.distance, pos.sentinelType);
                } else {
                    log.warn("Cannot create a proper empty descriptor: {} {}", (Object)id, (Object)start);
                    parentDiffDescr = new EmptyParentDiffDescriptor(id, type, -1L, -1, -1);
                }
            }
        } else {
            SpecialCaseParentDiff.SpecialCaseParentDiffType specialCase = parentInterval.getSpecialCase();
            if (specialCase != null) {
                switch (specialCase) {
                    case START_SENTINEL_ADDED: 
                    case START_SENTINEL_CHANGE: {
                        Long idOfNodeAtStart;
                        OffsetInformation information = docCtrl.getContentInformationAtOffset(start);
                        AuthorNode nodeForMarkerOffset = information.getNodeForMarkerOffset();
                        if (nodeForMarkerOffset != null && (idOfNodeAtStart = nodeIndexer.getIdIfExists((Object)nodeForMarkerOffset)) != null) {
                            parentDiffDescr = new SentinelParentDiffDescriptor(id, type, idOfNodeAtStart, specialCase);
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug("Special-case parent: {}", (Object)specialCase);
                        break;
                    }
                    case END_SENTINEL_ADDED: 
                    case END_SENTINEL_CHANGE: {
                        AuthorNode nodeAtStart = docCtrl.getNodeAtOffset(start);
                        Long idOfNodeAtStart = nodeIndexer.getIdIfExists((Object)nodeAtStart);
                        if (idOfNodeAtStart == null) break;
                        parentDiffDescr = new SentinelParentDiffDescriptor(id, type, idOfNodeAtStart, specialCase);
                        if (!log.isDebugEnabled()) break;
                        log.debug("Special-case parent: {}", (Object)specialCase);
                        break;
                    }
                    case INLINE_CONTENT_LEFT: 
                    case INLINE_CONTENT_RIGHT: 
                    case INLINE_CONTENT_BOTH: {
                        parentDiffDescr = specialCase == SpecialCaseParentDiff.SpecialCaseParentDiffType.INLINE_CONTENT_BOTH || leftDocument && specialCase == SpecialCaseParentDiff.SpecialCaseParentDiffType.INLINE_CONTENT_LEFT || !leftDocument && specialCase == SpecialCaseParentDiff.SpecialCaseParentDiffType.INLINE_CONTENT_RIGHT ? DiffDescriptorsUtil.getInlineParentDiffDescriptor(docModel, start, end, id, type) : new UnknownParentDiffDescriptor(id, type);
                    }
                }
            } else {
                parentDiffDescr = DiffDescriptorsUtil.getBlockParentDiffDescriptor(docCtrl, (AuthorIdIndex<AuthorNode>)nodeIndexer, start, end, id, type);
            }
        }
        if (parentDiffDescr == null) {
            log.error("Could not create parent diff descriptor for insterval: {} {}", (Object)start, (Object)end);
            parentDiffDescr = new UnknownParentDiffDescriptor(id, type);
        }
        return parentDiffDescr;
    }

    private static ParentDiffDescriptor getInlineParentDiffDescriptor(AuthorDocumentModel docModel, int start, int end, String id, String type) throws BadLocationException {
        ParentDiffDescriptor parentDiffDescr = null;
        AuthorDocumentController docCtrl = docModel.getAuthorAccess().getDocumentController();
        AuthorNode nodeAtStart = docCtrl.getNodeAtOffset(start);
        if (nodeAtStart instanceof AuthorElement) {
            parentDiffDescr = new InlinesParentDiffDescriptor(id, type);
            if (log.isDebugEnabled()) {
                log.debug("Inline content parent");
            }
        }
        if (parentDiffDescr == null) {
            log.error("Could not determine the descriptor of inline content parent diff. Start pos: {} end pos: {}", (Object)start, (Object)end);
            parentDiffDescr = new UnknownParentDiffDescriptor(id, type);
        }
        return parentDiffDescr;
    }

    private static ParentDiffDescriptor getBlockParentDiffDescriptor(AuthorDocumentController docCtrl, AuthorIdIndex<AuthorNode> nodeIndexer, int start, int end, String id, String type) throws BadLocationException {
        BlocksParentDiffDescriptor parentDiffDescr = null;
        List nodesToSelect = docCtrl.getNodesToSelect(start, end);
        if (nodesToSelect != null && !nodesToSelect.isEmpty()) {
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (AuthorNode authorNode : nodesToSelect) {
                Long parentId = nodeIndexer.getIdIfExists((Object)authorNode);
                if (parentId == null) continue;
                parentIds.add(parentId);
            }
            parentDiffDescr = new BlocksParentDiffDescriptor(parentIds, id, type);
            if (log.isDebugEnabled()) {
                log.debug("Blocks parent");
            }
        }
        return parentDiffDescr;
    }
}

