/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations.descriptors;

import com.oxygenxml.webapp.diff.operations.CommonPosition;
import com.oxygenxml.webapp.diff.operations.descriptors.ContentChangeDescriptor;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferenceDescriptor;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferenceDescriptorType;
import com.oxygenxml.webapp.diff.operations.descriptors.ReviewCommentDifferenceDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferenceType;
import ro.sync.diff.text.CompoundDiffEntry;
import ro.sync.diff.text.MarkerDiffEntry;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class DifferencesDescriptorsDetector {
    private AuthorDocumentModel leftDocumentModel;
    private AuthorDocumentModel rightDocumentModel;
    private AuthorDocumentModel baseDocumentModel;

    public DifferencesDescriptorsDetector(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, AuthorDocumentModel baseDocumentModel) {
        this.leftDocumentModel = leftDocumentModel;
        this.rightDocumentModel = rightDocumentModel;
        this.baseDocumentModel = baseDocumentModel;
    }

    public List<DifferenceDescriptor> computeDiffsDescriptors(Difference diff) {
        ArrayList<DifferenceDescriptor> toReturn = new ArrayList<DifferenceDescriptor>();
        List<ReviewCommentDifferenceDescriptor> reviewCommentsDiffsDescriptors = this.computeReviewCommentsDiffsForDiff(diff);
        if (reviewCommentsDiffsDescriptors.isEmpty()) {
            toReturn.add(new ContentChangeDescriptor());
        } else {
            if (diff instanceof CompoundDiffEntry) {
                CompoundDiffEntry composedDiff = (CompoundDiffEntry)diff;
                if (!composedDiff.getPrimaryContentDiffEntries().isEmpty()) {
                    toReturn.add(new ContentChangeDescriptor());
                } else {
                    for (MarkerDiffEntry markerDiff : composedDiff.getMarkerDiffEntries()) {
                        if ((markerDiff.getLeftMarker() == null || markerDiff.getLeftMarker().getType() == AuthorPersistentHighlight.PersistentHighlightType.COMMENT) && (markerDiff.getRightMarker() == null || markerDiff.getRightMarker().getType() == AuthorPersistentHighlight.PersistentHighlightType.COMMENT)) continue;
                        toReturn.add(new ContentChangeDescriptor());
                        break;
                    }
                }
            }
            toReturn.addAll(reviewCommentsDiffsDescriptors);
        }
        return toReturn;
    }

    private List<ReviewCommentDifferenceDescriptor> computeReviewCommentsDiffsForDiff(Difference diff) {
        ArrayList<ReviewCommentDifferenceDescriptor> toReturn = new ArrayList<ReviewCommentDifferenceDescriptor>();
        boolean isThreeWay = this.baseDocumentModel != null;
        List<AuthorPersistentHighlight> leftCommentsInDiff = this.getReviewCommentsAt(this.leftDocumentModel, diff.getLeftIntervalStart(), diff.getLeftIntervalEnd());
        List<AuthorPersistentHighlight> rightCommentsInDiff = this.getReviewCommentsAt(this.rightDocumentModel, diff.getRightIntervalStart(), diff.getRightIntervalEnd());
        List<Long> leftCommentsTrackableIds = leftCommentsInDiff.stream().map(this::getTrackableId).collect(Collectors.toList());
        List<Long> rightCommentsTrackableIds = rightCommentsInDiff.stream().map(this::getTrackableId).collect(Collectors.toList());
        List<CommonPosition> commonLeftRightComments = DifferencesDescriptorsDetector.lcs(leftCommentsTrackableIds, rightCommentsTrackableIds);
        for (int i = 0; i < commonLeftRightComments.size(); ++i) {
            CommonPosition commonLeftRightPosition = commonLeftRightComments.get(i);
            int leftExtraCommentIndexFrom = i == 0 ? 0 : commonLeftRightComments.get(i - 1).getAPosition() + 1;
            int leftExtraCommentIndexTo = commonLeftRightPosition.getAPosition();
            for (int leftExtraCommentIndex = leftExtraCommentIndexFrom; leftExtraCommentIndex < leftExtraCommentIndexTo; ++leftExtraCommentIndex) {
                AuthorPersistentHighlight leftExtraComment = leftCommentsInDiff.get(leftExtraCommentIndex);
                AuthorPersistentHighlight rightMissingComment = null;
                this.computeCommentDifference(leftExtraComment, rightMissingComment, diff, isThreeWay).ifPresent(toReturn::add);
            }
            int rightExtraCommentIndexFrom = i == 0 ? 0 : commonLeftRightComments.get(i - 1).getBPosition() + 1;
            int rightExtraCommentTo = commonLeftRightPosition.getBPosition();
            for (int rightExtraCommentIndex = rightExtraCommentIndexFrom; rightExtraCommentIndex < rightExtraCommentTo; ++rightExtraCommentIndex) {
                AuthorPersistentHighlight leftMissingComment = null;
                AuthorPersistentHighlight rightExtraComment = rightCommentsInDiff.get(rightExtraCommentIndex);
                this.computeCommentDifference(leftMissingComment, rightExtraComment, diff, isThreeWay).ifPresent(toReturn::add);
            }
            AuthorPersistentHighlight leftComment = leftCommentsInDiff.get(commonLeftRightPosition.getAPosition());
            AuthorPersistentHighlight rightComment = rightCommentsInDiff.get(commonLeftRightPosition.getBPosition());
            this.computeCommentDifference(leftComment, rightComment, diff, this.baseDocumentModel != null).ifPresent(toReturn::add);
        }
        int leftExtraCommentStart = 0;
        int rightExtraCommentStart = 0;
        if (!commonLeftRightComments.isEmpty()) {
            CommonPosition lastCommonPosition = commonLeftRightComments.get(commonLeftRightComments.size() - 1);
            leftExtraCommentStart = lastCommonPosition.getAPosition() + 1;
            rightExtraCommentStart = lastCommonPosition.getBPosition() + 1;
        }
        for (int leftExtraCommentIndex = leftExtraCommentStart; leftExtraCommentIndex < leftCommentsTrackableIds.size(); ++leftExtraCommentIndex) {
            AuthorPersistentHighlight leftExtraComment = leftCommentsInDiff.get(leftExtraCommentIndex);
            AuthorPersistentHighlight rightMissingComment = null;
            this.computeCommentDifference(leftExtraComment, rightMissingComment, diff, isThreeWay).ifPresent(toReturn::add);
        }
        for (int rightExtraCommentIndex = rightExtraCommentStart; rightExtraCommentIndex < rightCommentsTrackableIds.size(); ++rightExtraCommentIndex) {
            AuthorPersistentHighlight rightExtraComment = rightCommentsInDiff.get(rightExtraCommentIndex);
            AuthorPersistentHighlight leftMissingComment = null;
            this.computeCommentDifference(leftMissingComment, rightExtraComment, diff, isThreeWay).ifPresent(toReturn::add);
        }
        return toReturn;
    }

    private Optional<ReviewCommentDifferenceDescriptor> computeCommentDifference(AuthorPersistentHighlight leftComment, AuthorPersistentHighlight rightComment, Difference diff, boolean isThreeWay) {
        if (isThreeWay) {
            if (leftComment != null) {
                long leftMarkerId = this.leftDocumentModel.getMarkersIndexer().getId((Object)leftComment);
                if (rightComment != null) {
                    long rightMarkerId = this.rightDocumentModel.getMarkersIndexer().getId((Object)rightComment);
                    if (this.areCommentsEqual(leftComment, rightComment)) {
                        return Optional.empty();
                    }
                    if (diff.getType() == DifferenceType.LEFT_CHANGED) {
                        return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.LEFT_COMMENT_CHANGED));
                    }
                    if (diff.getType() == DifferenceType.RIGHT_CHANGED) {
                        return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.RIGHT_COMMENT_CHANGED));
                    }
                    return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.COMMENT_CONFLICT));
                }
                long rightMarkerId = -1L;
                if (diff.getType() == DifferenceType.LEFT_CHANGED) {
                    return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.LEFT_COMMENT_ADDED));
                }
                if (diff.getType() == DifferenceType.RIGHT_CHANGED) {
                    return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.RIGHT_COMMENT_REMOVED));
                }
                return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.COMMENT_CONFLICT));
            }
            long leftMarkerId = -1L;
            if (rightComment != null) {
                long rightMarkerId = this.rightDocumentModel.getMarkersIndexer().getId((Object)rightComment);
                if (diff.getType() == DifferenceType.LEFT_CHANGED) {
                    return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.LEFT_COMMENT_REMOVED));
                }
                if (diff.getType() == DifferenceType.RIGHT_CHANGED) {
                    return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.RIGHT_COMMENT_ADDED));
                }
                return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.COMMENT_CONFLICT));
            }
            throw new IllegalArgumentException();
        }
        if (leftComment != null) {
            long leftMarkerId = this.leftDocumentModel.getMarkersIndexer().getId((Object)leftComment);
            if (rightComment != null) {
                long rightMarkerId = this.rightDocumentModel.getMarkersIndexer().getId((Object)rightComment);
                if (this.areCommentsEqual(leftComment, rightComment)) {
                    return Optional.empty();
                }
                return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.COMMENTS_DIFFER));
            }
            long rightMarkerId = -1L;
            return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.COMMENT_ON_LEFT));
        }
        if (rightComment != null) {
            long leftMarkerId = -1L;
            long rightMarkerId = this.rightDocumentModel.getMarkersIndexer().getId((Object)rightComment);
            return Optional.of(new ReviewCommentDifferenceDescriptor(leftMarkerId, rightMarkerId, DifferenceDescriptorType.COMMENT_ON_RIGHT));
        }
        throw new IllegalArgumentException();
    }

    private boolean areCommentsEqual(AuthorPersistentHighlight leftComment, AuthorPersistentHighlight rightComment) {
        LinkedHashMap leftCommentProps = leftComment.getClonedProperties();
        LinkedHashMap rightCommentProps = rightComment.getClonedProperties();
        leftCommentProps.remove("id");
        leftCommentProps.remove("parentID");
        leftCommentProps.remove("mid");
        rightCommentProps.remove("id");
        rightCommentProps.remove("parentID");
        rightCommentProps.remove("mid");
        return leftCommentProps.hashCode() == rightCommentProps.hashCode();
    }

    private long getTrackableId(AuthorPersistentHighlight comment) {
        return Objects.hash(comment.getProperty("timestamp"), comment.getProperty("author"));
    }

    private List<AuthorPersistentHighlight> getReviewCommentsAt(AuthorDocumentModel adm, long start, long endExclusive) {
        return adm.getReviewController().getAllHighlights().stream().filter(highlight -> highlight.getType() == AuthorPersistentHighlight.PersistentHighlightType.COMMENT).filter(highlight -> (long)highlight.getStartOffset() >= start).filter(highlight -> (long)highlight.getEndOffset() < endExclusive).collect(Collectors.toList());
    }

    static List<CommonPosition> lcs(List<Long> aIds, List<Long> bIds) {
        int m = aIds.size();
        int n = bIds.size();
        int[][] dp = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                dp[i][j] = aIds.get(i - 1).equals(bIds.get(j - 1)) ? dp[i - 1][j - 1] + 1 : Math.max(dp[i - 1][j], dp[i][j - 1]);
            }
        }
        ArrayList<CommonPosition> result = new ArrayList<CommonPosition>();
        int i = m;
        int j = n;
        while (i > 0 && j > 0) {
            if (aIds.get(i - 1).equals(bIds.get(j - 1))) {
                result.add(0, new CommonPosition(i - 1, j - 1));
                --i;
                --j;
                continue;
            }
            if (dp[i - 1][j] > dp[i][j - 1]) {
                --i;
                continue;
            }
            --j;
        }
        return result;
    }
}

