/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations.copy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.operations.DiffHighlightsManager;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferenceDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.AllDifferences;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.DiffDescriptorsUtil;
import java.util.List;
import java.util.Map;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class CopyOperationResponse {
    private List<String> rightHighlightIdsToRemove;
    private AllDifferences leftDiffsDescriptors;
    private AllDifferences rightDiffsDescriptors;
    private Map<String, Map<String, List<DifferenceDescriptor>>> differencesDescriptors;

    public CopyOperationResponse() {
    }

    public CopyOperationResponse(List<String> rightHighlightIdsToRemove, AllDifferences leftDiffsDescriptors, AllDifferences rightDiffsDescriptors, Map<String, Map<String, List<DifferenceDescriptor>>> differencesDescriptors) {
        this.rightHighlightIdsToRemove = rightHighlightIdsToRemove;
        this.leftDiffsDescriptors = leftDiffsDescriptors;
        this.rightDiffsDescriptors = rightDiffsDescriptors;
        this.differencesDescriptors = differencesDescriptors;
    }

    public List<String> getRightHighlightIdsToRemove() {
        return this.rightHighlightIdsToRemove;
    }

    public AllDifferences getLeftDiffsDescriptors() {
        return this.leftDiffsDescriptors;
    }

    public AllDifferences getRightDiffsDescriptors() {
        return this.rightDiffsDescriptors;
    }

    public Map<String, Map<String, List<DifferenceDescriptor>>> getDifferencesDescriptors() {
        return this.differencesDescriptors;
    }

    public String toJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static CopyOperationResponse create(DiffModelImpl diffModel, AuthorDocumentModel leftAdm, AuthorDocumentModel rightAdm) {
        List<String> rightHighlightIds = new DiffHighlightsManager(rightAdm).getHighlightIdsForDiffs(diffModel.getRemovedDiffIds());
        AllDifferences leftDiffsDescriptors = DiffDescriptorsUtil.getDiffHighlightsInfo(diffModel.getParentDiffIntervals(IntervalsPair.Side.LEFT), leftAdm, true);
        AllDifferences rightDiffsDescriptors = DiffDescriptorsUtil.getDiffHighlightsInfo(diffModel.getParentDiffIntervals(IntervalsPair.Side.RIGHT), rightAdm, false);
        return new CopyOperationResponse(rightHighlightIds, leftDiffsDescriptors, rightDiffsDescriptors, diffModel.getDifferencesDescriptors());
    }
}

