/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations.copy;

import com.oxygenxml.webapp.diff.model.DiffIntervalsPair;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.model.DiffModelStorage;
import com.oxygenxml.webapp.diff.operations.ComputeDiffsOperation;
import com.oxygenxml.webapp.diff.operations.copy.AuthorModelLocker;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.diff.merge.api.DiffModel;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.diff.merge.api.MergeController;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;

public abstract class CopyMultipleDiffsOperation
extends AuthorOperationWithResult {
    public String getDescription() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doOperation(AuthorDocumentModel leftModel, ArgumentsMap args) throws AuthorOperationException {
        EditingSessionContext leftEditingContext = leftModel.getAuthorAccess().getEditorAccess().getEditingContext();
        DiffModelStorage diffModelStorage = new DiffModelStorage(leftEditingContext);
        DiffModelImpl diffModel = diffModelStorage.getDiffModel();
        AuthorDocumentController leftController = leftModel.getAuthorDocumentController();
        AuthorModelLocker authorModelLocker = AuthorModelLocker.createLockerForRightDocument(leftModel);
        AuthorDocumentModel rightAdm = authorModelLocker.lock();
        try {
            AuthorDocumentController rightController = rightAdm.getAuthorDocumentController();
            this.doOperationInternal(diffModel, leftController, rightController);
            String string = new ComputeDiffsOperation().doOperation(leftModel, null);
            authorModelLocker.unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                authorModelLocker.unlock();
                throw throwable;
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage());
            }
        }
    }

    private void doOperationInternal(DiffModelImpl diffModel, AuthorDocumentController leftController, AuthorDocumentController rightController) throws BadLocationException {
        MergeController mergeController = new MergeController((DiffModel)diffModel, rightController, leftController);
        List<IntervalsPair> allDiffs = diffModel.getAllDiffs();
        for (int i = allDiffs.size() - 1; i >= 0; --i) {
            IntervalsPair pair = allDiffs.get(i);
            DiffIntervalsPair diffPair = (DiffIntervalsPair)pair;
            if (!this.shouldCopyChange(diffPair) || diffModel.isAlreadyMerged(diffPair)) continue;
            mergeController.copy(pair.getInterval(IntervalsPair.Side.RIGHT), pair.getInterval(IntervalsPair.Side.LEFT), false);
            diffModel.removeDiffs(Arrays.asList(pair));
        }
    }

    protected abstract boolean shouldCopyChange(DiffIntervalsPair var1);
}

