/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations.copy;

import com.oxygenxml.webapp.diff.model.DiffIntervalsPair;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.model.DiffModelStorage;
import com.oxygenxml.webapp.diff.operations.DiffHighlightsManager;
import com.oxygenxml.webapp.diff.operations.copy.AuthorModelLocker;
import com.oxygenxml.webapp.diff.operations.copy.CopyOperationResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.diff.merge.api.DiffModel;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.diff.merge.api.MergeController;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@WebappRestSafe
public class CopyDiffOperation
extends AuthorOperationWithResult {
    public static final String DIFF_ID = "diffId";

    public String getDescription() {
        return null;
    }

    public String doOperation(AuthorDocumentModel leftModel, ArgumentsMap args) throws AuthorOperationException {
        AuthorModelLocker authorModelLocker = AuthorModelLocker.createLockerForRightDocument(leftModel);
        AuthorDocumentModel rightAdm = authorModelLocker.lock();
        try {
            String diffId = (String)args.getArgumentValue(DIFF_ID);
            CopyOperationResponse response = this.doOperationInternal(leftModel, rightAdm, diffId);
            String string = response.toJson();
            return string;
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException(e.getMessage());
        }
        finally {
            authorModelLocker.unlock();
        }
    }

    private CopyOperationResponse doOperationInternal(AuthorDocumentModel leftModel, AuthorDocumentModel rightAdm, String diffId) throws BadLocationException, AuthorOperationException {
        EditingSessionContext leftEditingContext = leftModel.getAuthorAccess().getEditorAccess().getEditingContext();
        DiffModelStorage diffModelStorage = new DiffModelStorage(leftEditingContext);
        DiffModelImpl diffModel = diffModelStorage.getDiffModel();
        this.copyChangeWithId(diffId, diffModel, leftModel, rightAdm);
        new DiffHighlightsManager(leftModel).removeHighlightsForDiffs(diffModel.getRemovedDiffIds());
        return CopyOperationResponse.create(diffModel, leftModel, rightAdm);
    }

    public void copyChangeWithId(String diffId, DiffModelImpl diffModel, AuthorDocumentModel leftAdm, AuthorDocumentModel rightAdm) throws BadLocationException {
        AuthorDocumentController leftController = leftAdm.getAuthorDocumentController();
        AuthorDocumentController rightController = rightAdm.getAuthorDocumentController();
        MergeController mergeController = new MergeController((DiffModel)diffModel, rightController, leftController);
        List<DiffIntervalsPair> diffsToCopy = this.getSecondLevelDiffsToCopy(diffId, diffModel);
        for (DiffIntervalsPair diff : diffsToCopy) {
            if (diffModel.isAlreadyMerged(diff)) continue;
            diffModel.removeDiffs(Arrays.asList(diff));
            mergeController.copy(diff.getInterval(IntervalsPair.Side.RIGHT), diff.getInterval(IntervalsPair.Side.LEFT), false);
        }
    }

    private List<DiffIntervalsPair> getSecondLevelDiffsToCopy(String diffId, DiffModelImpl diffModel) {
        ArrayList<DiffIntervalsPair> toReturn = new ArrayList<DiffIntervalsPair>();
        if (this.isIdOfSecondLevelDiff(diffId)) {
            diffModel.findDiffById(diffId).ifPresent(toReturn::add);
        } else {
            List<DiffIntervalsPair> secondLevelDiffs = diffModel.findDiffsByParentId(diffId);
            toReturn.addAll(secondLevelDiffs);
        }
        return toReturn;
    }

    private boolean isIdOfSecondLevelDiff(String diffId) {
        return diffId.contains(".");
    }
}

