/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations.copy;

import com.oxygenxml.webapp.diff.DiffDocumentsLinker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.servlet.ServletDocumentModel;
import ro.sync.servlet.ServletDocumentModelCache;

class AuthorModelLocker {
    private static final Logger log = LoggerFactory.getLogger(AuthorModelLocker.class);
    private final String docId;
    private ServletDocumentModelCache servletDocumentModelCache;
    private boolean modelStillInCache = true;

    AuthorModelLocker(String docId) {
        this.docId = docId;
        if (docId == null) {
            throw new IllegalStateException("Cannot get doc ID from editing context!");
        }
        this.servletDocumentModelCache = ServletDocumentModelCache.getInstance();
    }

    public AuthorDocumentModel lock() {
        try {
            ServletDocumentModel cachedModel = this.servletDocumentModelCache.getDocumentModelByIdUnchecked(this.docId);
            this.modelStillInCache = cachedModel != null;
            return cachedModel.getAuthorDocumentModel();
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
            throw e;
        }
    }

    public void unlock() {
        if (this.modelStillInCache) {
            try {
                this.servletDocumentModelCache.releaseDocument(this.docId);
            }
            catch (Exception e) {
                log.warn((Object)e, (Throwable)e);
                throw e;
            }
        }
    }

    public static AuthorModelLocker createLockerForRightDocument(AuthorDocumentModel leftDocument) {
        AuthorDocumentModel rightDocumentModel = new DiffDocumentsLinker(leftDocument).getPair();
        EditingSessionContext rightEditingContext = rightDocumentModel.getAuthorAccess().getEditorAccess().getEditingContext();
        String docId = (String)rightEditingContext.getAttribute("com.oxygenxml.docId");
        return new AuthorModelLocker(docId);
    }
}

