/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations;

import com.oxygenxml.webapp.diff.DiffDocumentsLinker;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.model.DiffModelStorage;
import com.oxygenxml.webapp.diff.model.ParentDiffInterval;
import com.oxygenxml.webapp.diff.operations.AuthorDocumentLastModificationTimestampTracker;
import com.oxygenxml.webapp.diff.operations.DiffHighlightDescriptor;
import com.oxygenxml.webapp.diff.operations.DiffHighlightsManager;
import com.oxygenxml.webapp.diff.operations.DiffPseudoClassSetterOnDiffs;
import java.util.List;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@WebappRestSafe
public class ShowDiffsOperation
extends AuthorOperationWithResult {
    private static String REFRESH_HIGHLIGHTS = "refreshHighlights";

    public String doOperation(AuthorDocumentModel authorDocumentModel, ArgumentsMap arg1) throws AuthorOperationException {
        EditingSessionContext leftEditingContext;
        AuthorAccess authorAccess = authorDocumentModel.getAuthorAccess();
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        EditingSessionContext editingContext = editorAccess.getEditingContext();
        IntervalsPair.Side side = this.getSide(editingContext);
        DiffModelStorage currentDiffModelStorage = new DiffModelStorage(editingContext);
        DiffModelImpl diffModel = currentDiffModelStorage.getTempDiffModel();
        EditingSessionContext editingSessionContext = leftEditingContext = side == IntervalsPair.Side.LEFT ? editingContext : DiffDocumentsLinker.getLeftEditingContext(editingContext);
        if (diffModel != null && diffModel.getDocTimestamp() == AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(leftEditingContext)) {
            List<ParentDiffInterval> parentDiffIntervals = diffModel.getParentDiffIntervals(this.getSide(editingContext));
            List<DiffHighlightDescriptor> descriptors = DiffHighlightDescriptor.createDiffHighlightDescriptors(parentDiffIntervals);
            DiffHighlightsManager diffHighlightsManager = new DiffHighlightsManager(authorDocumentModel);
            boolean refreshHighlights = false;
            if (arg1 != null) {
                refreshHighlights = Boolean.TRUE.equals(arg1.getArgumentValue(REFRESH_HIGHLIGHTS));
            }
            diffHighlightsManager.updateHighlights(descriptors, refreshHighlights);
            currentDiffModelStorage.removeTempDiffModel();
            if (side == IntervalsPair.Side.LEFT) {
                DiffModelStorage leftDdiffModelStorage = new DiffModelStorage(leftEditingContext);
                leftDdiffModelStorage.storeDiffModel(diffModel);
            }
            DiffPseudoClassSetterOnDiffs.setDiffPseudoClass(authorDocumentModel, side, diffModel);
            return "{\"success\":true}";
        }
        return "{\"success\":false,\"staleDoc\":true}";
    }

    private IntervalsPair.Side getSide(EditingSessionContext editingContext) {
        IntervalsPair.Side side = DiffDocumentsLinker.getLeftEditingContext(editingContext) != null ? IntervalsPair.Side.RIGHT : IntervalsPair.Side.LEFT;
        return side;
    }
}

