/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations;

import com.oxygenxml.webapp.diff.DiffDocumentsLinker;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappAuthorDocumentFactory;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@WebappRestSafe
public class SetBaseDocOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(SetBaseDocOperation.class);
    private static final String BASE_DIFF_URL = "diffBaseUrl";

    public String doOperation(AuthorDocumentModel leftDocumentModel, ArgumentsMap args) throws AuthorOperationException {
        String baseDiffUrl = (String)args.getArgumentValue(BASE_DIFF_URL);
        this.doOperationInternal(leftDocumentModel, baseDiffUrl);
        return "";
    }

    void doOperationInternal(AuthorDocumentModel leftDocumentModel, String baseDiffUrl) {
        try {
            AuthorDocumentModel baseDocument = this.loadBaseDocument(leftDocumentModel, baseDiffUrl);
            new DiffDocumentsLinker(leftDocumentModel).setBase(new DiffDocumentsLinker.DiffBaseData(baseDocument, false));
        }
        catch (IOException | SAXException e) {
            log.info("fail to load base document for diff {}", (Object)baseDiffUrl, (Object)e);
            new DiffDocumentsLinker(leftDocumentModel).setBase(new DiffDocumentsLinker.DiffBaseData(null, true));
        }
    }

    private AuthorDocumentModel loadBaseDocument(AuthorDocumentModel leftDocumentModel, String base) throws IOException, SAXException {
        URL baseUrl = new URL(base);
        String rightEditorUrl = leftDocumentModel.getAuthorAccess().getEditorAccess().getEditorLocation().toExternalForm();
        baseUrl = URLUtil.addAuthenticationInfo((URL)new URL(rightEditorUrl), (URL)baseUrl);
        HashMap<String, String> sessionAttributes = new HashMap<String, String>();
        sessionAttributes.put("previewMode", "true");
        String externalForm = baseUrl.toExternalForm();
        AuthorDocumentModel baseDocumentModel = WebappAuthorDocumentFactory.createAuthorDocumentInfo((String)externalForm, sessionAttributes);
        return baseDocumentModel;
    }
}

