/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations;

import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class DiffPseudoClassSetterOnDiffs {
    private static final Logger log = LoggerFactory.getLogger(DiffPseudoClassSetterOnDiffs.class);
    private static final String DIFF_INSIDE_PSEUDO_CLASS = "diff-inside";

    public static void setDiffPseudoClass(AuthorDocumentModel adm, IntervalsPair.Side side, DiffModelImpl diffModel) {
        AuthorDocumentController ctrl = adm.getAuthorDocumentController();
        AuthorDocument doc = adm.getAuthorDocumentController().getAuthorDocumentNode();
        List<IntervalsPair> diffs = diffModel.getAllDiffs();
        for (IntervalsPair diffIntervalPair : diffs) {
            ContentInterval diff = diffIntervalPair.getInterval(side);
            try {
                for (AuthorNode parentNode = ctrl.getCommonParentNode(doc, diff.getStartOffset(), diff.getEndOffset() - 1); parentNode != null && parentNode instanceof AuthorElement; parentNode = parentNode.getParent()) {
                    ctrl.setPseudoClass(DIFF_INSIDE_PSEUDO_CLASS, (AuthorElement)parentNode);
                }
                OffsetInformation info = ctrl.getContentInformationAtOffset(diff.getStartOffset());
                if (DiffPseudoClassSetterOnDiffs.isSurround(diff, info)) {
                    ctrl.setPseudoClass(DIFF_INSIDE_PSEUDO_CLASS, (AuthorElement)info.getNodeForMarkerOffset());
                }
                ctrl.getNodesToSelect(diff.getStartOffset(), diff.getEndOffset() - 1).stream().filter(node -> DiffPseudoClassSetterOnDiffs.isInside(diff, node)).forEach(nodeInsideDiff -> DiffPseudoClassSetterOnDiffs.setPseudoClassRecursively(DIFF_INSIDE_PSEUDO_CLASS, nodeInsideDiff, ctrl));
            }
            catch (BadLocationException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean isInside(ContentInterval diff, AuthorNode node) {
        return node.getStartOffset() >= diff.getStartOffset() && node.getEndOffset() <= diff.getEndOffset() - 1;
    }

    private static boolean isSurround(ContentInterval diff, OffsetInformation info) {
        return diff.getStartOffset() == diff.getEndOffset() - 1 && (info.getPositionType() == 1 || info.getPositionType() == 2);
    }

    private static void setPseudoClassRecursively(String pseudoClass, AuthorNode node, AuthorDocumentController ctrl) {
        if (node instanceof AuthorElement) {
            AuthorElement element = (AuthorElement)node;
            ctrl.setPseudoClass(pseudoClass, element);
            for (AuthorNode child : element.getContentNodes()) {
                if (!(child instanceof AuthorElement)) continue;
                DiffPseudoClassSetterOnDiffs.setPseudoClassRecursively(pseudoClass, (AuthorNode)((AuthorElement)child), ctrl);
            }
        }
    }
}

