/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.oxygenxml.webapp.diff.model.DiffInterval;
import com.oxygenxml.webapp.diff.operations.DiffHighlightDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.highlights.AuthorHighlighter;
import ro.sync.ecss.extensions.api.highlights.Highlight;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class DiffHighlightsManager {
    private static final Logger log = LoggerFactory.getLogger(DiffHighlightsManager.class);
    private static final String DIFF_ID_ATTR_NAME = "diff-id";
    private static final String DIFF_PARENT_ID_ATTR_NAME = "diff-parent";
    private static final String DIFF_TYPE_ATTR_NAME = "diff-type";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String DIFF_CLASS = "diff";
    private AuthorDocumentModel docModel;

    public DiffHighlightsManager(AuthorDocumentModel model) {
        this.docModel = model;
    }

    private void addHighlight(DiffHighlightDescriptor descriptor) {
        DiffInterval interval = descriptor.getInterval();
        this.addHighlight(interval, descriptor.getParentId());
    }

    @VisibleForTesting
    Highlight addHighlight(DiffInterval interval, String parentId) {
        try {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(CLASS_ATTR_NAME, DIFF_CLASS);
            attrs.put(DIFF_TYPE_ATTR_NAME, interval.getType().toString());
            attrs.put(DIFF_ID_ATTR_NAME, interval.getId());
            attrs.put(DIFF_PARENT_ID_ATTR_NAME, parentId);
            return this.getHighlighter().addHighlight(interval.getStart(), interval.getEnd() - 1, null, attrs);
        }
        catch (BadLocationException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private static boolean equals(DiffHighlightDescriptor diffInterval, Highlight highlight) {
        Object additionalData = highlight.getAdditionalData();
        if (additionalData instanceof Map) {
            Map additionalDataMap = (Map)additionalData;
            return diffInterval.getInterval().getId().equals(additionalDataMap.get(DIFF_ID_ATTR_NAME)) && diffInterval.getInterval().getType().toString().equals(additionalDataMap.get(DIFF_TYPE_ATTR_NAME)) && diffInterval.getParentId().equals(additionalDataMap.get(DIFF_PARENT_ID_ATTR_NAME)) && DIFF_CLASS.equals(additionalDataMap.get(CLASS_ATTR_NAME)) && highlight.getStartOffset() == diffInterval.getInterval().getStart() && highlight.getEndOffset() == diffInterval.getInterval().getEnd() - 1;
        }
        return false;
    }

    public void removeHighlightsForDiffs(Set<String> diffIds) {
        Highlight[] highlightsToRemove = (Highlight[])this.getDiffHighlightsForIds(diffIds).toArray(Highlight[]::new);
        this.getHighlighter().removeHighlights(highlightsToRemove);
    }

    private Stream<Highlight> getDiffHighlightsForIds(Set<String> diffIntervalIds) {
        return Arrays.stream(this.getHighlighter().getHighlights()).filter(highlight -> diffIntervalIds.contains(this.getDiffId((Highlight)highlight)));
    }

    public Optional<Highlight> getDiffById(String id) {
        return this.getDiffHighlightsForIds(Collections.singleton(id)).findFirst();
    }

    public List<String> getHighlightIdsForDiffs(Set<String> diffIds) {
        return this.getDiffHighlightsForIds(diffIds).map(Highlight::getId).collect(Collectors.toList());
    }

    String getDiffId(Highlight highlight) {
        Object diffId;
        Object additionalData = highlight.getAdditionalData();
        if (additionalData instanceof Map) {
            Map additionalDataMap = (Map)additionalData;
            diffId = additionalDataMap.get(DIFF_ID_ATTR_NAME);
        } else {
            diffId = null;
        }
        return diffId;
    }

    private AuthorHighlighter getHighlighter() {
        return this.docModel.getAuthorAccess().getEditorAccess().getHighlighter();
    }

    public void updateHighlights(List<DiffHighlightDescriptor> descriptors, boolean refreshHighlights) {
        HashMap<String, DiffHighlightDescriptor> diffIdToDescriptor = new HashMap<String, DiffHighlightDescriptor>();
        for (DiffHighlightDescriptor descriptor : descriptors) {
            diffIdToDescriptor.put(descriptor.getInterval().getId(), descriptor);
        }
        List<Highlight> diffHighlights = this.getDiffHighlights();
        for (Highlight highlight : diffHighlights) {
            String diffId = this.getDiffId(highlight);
            DiffHighlightDescriptor highlightDescriptor = (DiffHighlightDescriptor)diffIdToDescriptor.get(diffId);
            AuthorHighlighter highlighter = this.getHighlighter();
            if (highlightDescriptor != null) {
                diffIdToDescriptor.remove(diffId);
                if (!refreshHighlights && DiffHighlightsManager.equals(highlightDescriptor, highlight)) {
                    log.debug("diff highlight not modified {}", (Object)diffId);
                    continue;
                }
                highlighter.removeHighlight(highlight);
                this.addHighlight(highlightDescriptor);
                log.debug("diff highlight updated {}", (Object)diffId);
                continue;
            }
            highlighter.removeHighlight(highlight);
            log.debug("diff highlight removed {}", (Object)diffId);
        }
        for (DiffHighlightDescriptor diffHighlightDescriptor : diffIdToDescriptor.values()) {
            log.debug("diff highlight added {}", (Object)diffHighlightDescriptor.getInterval().getId());
            this.addHighlight(diffHighlightDescriptor);
        }
    }

    public List<Highlight> getDiffHighlights() {
        Highlight[] highlights = this.getHighlighter().getHighlights();
        if (highlights != null) {
            return Arrays.stream(highlights).filter(this::hasDiffClass).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean hasDiffClass(Highlight highlight) {
        String classValue = (String)MoreObjects.firstNonNull((Object)this.getClass(highlight), (Object)"");
        List<String> classTokens = Arrays.asList(classValue.split(" "));
        return classTokens.contains(DIFF_CLASS);
    }

    @VisibleForTesting
    String getClass(Highlight highlight) {
        Map additionalDataMap;
        Object classValue;
        Object additionalData = highlight.getAdditionalData();
        if (additionalData instanceof Map && (classValue = (additionalDataMap = (Map)additionalData).get(CLASS_ATTR_NAME)) instanceof String) {
            return (String)classValue;
        }
        return null;
    }

    public void updateHighlightEndPosition(DiffInterval interval) {
        Optional<Highlight> maybeHighlight = this.getDiffById(interval.getId());
        if (maybeHighlight.isPresent()) {
            Highlight oldHighlight = maybeHighlight.get();
            this.updateHighlightEndpoints(oldHighlight, interval);
        } else {
            this.addHighlight(interval, interval.getParentId());
        }
    }

    private void updateHighlightEndpoints(Highlight oldHighlight, DiffInterval interval) {
        Object oldAttributes = oldHighlight.getAdditionalData();
        try {
            AuthorHighlighter highlighter = this.getHighlighter();
            highlighter.addHighlight(interval.getStart(), interval.getEnd() - 1, null, oldAttributes);
            highlighter.removeHighlight(oldHighlight);
        }
        catch (BadLocationException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

