/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.webapp.diff.DiffDocumentsLinker;
import com.oxygenxml.webapp.diff.DiffPerformer;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.model.DiffModelStorage;
import com.oxygenxml.webapp.diff.model.ParentDiffInterval;
import com.oxygenxml.webapp.diff.operations.AuthorDocumentLastModificationTimestampTracker;
import com.oxygenxml.webapp.diff.operations.ComputeDiffsOperation;
import com.oxygenxml.webapp.diff.operations.ConcurrentAuthorDocModificationException;
import com.oxygenxml.webapp.diff.operations.DiffDocumentsStore;
import com.oxygenxml.webapp.diff.operations.DiffOperationFailureResponse;
import com.oxygenxml.webapp.diff.operations.DiffOperationModelChangedResponse;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.AllDifferences;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.DiffDescriptorsUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.plugin.PluginContext;

public class ComputeDiffsServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(ComputeDiffsServlet.class);
    @PluginContext
    private DiffDocumentsStore diffDocumentsStore;

    public String getPath() {
        return "compute-diffs";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String docId = req.getParameter("docId");
        AuthorDocumentModel leftDocumentModel = this.diffDocumentsStore.getDocument(docId);
        DiffDocumentsLinker documentsLinker = new DiffDocumentsLinker(leftDocumentModel);
        AuthorDocumentModel rightDocumentModel = documentsLinker.getPair();
        Optional<DiffDocumentsLinker.DiffBaseData> baseDocumentOpt = documentsLinker.getBase();
        String responseStr = this.computeSerializedDiffResponse(leftDocumentModel, rightDocumentModel, baseDocumentOpt);
        resp.setStatus(200);
        resp.setHeader("Content-Type", "application/json; charset=utf-8");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(responseStr);
        resp.getWriter().flush();
    }

    String computeSerializedDiffResponse(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, Optional<DiffDocumentsLinker.DiffBaseData> baseDocumentOpt) throws JsonProcessingException {
        ComputeDiffsOperation.DiffOperationResponse response = this.computeDiffResponse(leftDocumentModel, rightDocumentModel, baseDocumentOpt);
        return new ObjectMapper().writeValueAsString((Object)response);
    }

    ComputeDiffsOperation.DiffOperationResponse computeDiffResponse(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, Optional<DiffDocumentsLinker.DiffBaseData> baseDocumentOpt) {
        ComputeDiffsOperation.DiffOperationResponse response;
        try {
            response = this.computeDiff(leftDocumentModel, rightDocumentModel, baseDocumentOpt);
        }
        catch (IOException | DiffException e) {
            log.warn((Object)e, e);
            response = new DiffOperationFailureResponse("Unable to perform diff.");
        }
        catch (DiffPerformer.DiffNotLicensedException e) {
            log.info((Object)e, (Throwable)e);
            response = new DiffOperationFailureResponse(e.getMessage());
        }
        catch (ConcurrentAuthorDocModificationException e) {
            response = new DiffOperationModelChangedResponse();
        }
        return response;
    }

    private ComputeDiffsOperation.DiffOperationSuccessResponse computeDiff(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, Optional<DiffDocumentsLinker.DiffBaseData> baseDocumentOpt) throws ConcurrentAuthorDocModificationException, DiffPerformer.DiffNotLicensedException, DiffException, IOException {
        AllDifferences rightDiffs;
        AllDifferences leftDiffs;
        DiffModelImpl diffModel;
        EditingSessionContext editingContext = leftDocumentModel.getAuthorAccess().getEditorAccess().getEditingContext();
        long timestampBefore = AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(editingContext);
        DiffPerformer diffPerformer = new DiffPerformer();
        try {
            diffModel = this.computeDiffModel(leftDocumentModel, rightDocumentModel, baseDocumentOpt, diffPerformer);
        }
        catch (DiffPerformer.DiffNotLicensedException e) {
            throw e;
        }
        catch (IOException | RuntimeException | DiffException e) {
            if (timestampBefore != AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(editingContext)) {
                throw new ConcurrentAuthorDocModificationException();
            }
            throw e;
        }
        if (timestampBefore != AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(editingContext)) {
            throw new ConcurrentAuthorDocModificationException();
        }
        try {
            leftDiffs = this.findParentDiffHighlights(leftDocumentModel, diffModel, IntervalsPair.Side.LEFT);
            rightDiffs = this.findParentDiffHighlights(rightDocumentModel, diffModel, IntervalsPair.Side.RIGHT);
        }
        catch (RuntimeException e) {
            if (timestampBefore != AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(editingContext)) {
                throw new ConcurrentAuthorDocModificationException();
            }
            throw e;
        }
        if (timestampBefore != AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(editingContext)) {
            throw new ConcurrentAuthorDocModificationException();
        }
        DiffModelStorage leftStorage = new DiffModelStorage(leftDocumentModel.getAuthorAccess().getEditorAccess().getEditingContext());
        DiffModelStorage rightStorage = new DiffModelStorage(rightDocumentModel.getAuthorAccess().getEditorAccess().getEditingContext());
        leftStorage.storeTempDiffModel(diffModel);
        rightStorage.storeTempDiffModel(diffModel);
        ComputeDiffsOperation.DiffResponseStatus status = diffPerformer.computeResposeStatus(leftDocumentModel, rightDocumentModel, baseDocumentOpt, diffModel);
        ComputeDiffsOperation.DiffOperationSuccessResponse toReturn = new ComputeDiffsOperation.DiffOperationSuccessResponse(status, leftDiffs, rightDiffs, diffModel.getDifferencesDescriptors());
        return toReturn;
    }

    protected DiffModelImpl computeDiffModel(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, Optional<DiffDocumentsLinker.DiffBaseData> baseDocumentOpt, DiffPerformer diffPerformer) throws DiffException, IOException, DiffPerformer.DiffNotLicensedException {
        return diffPerformer.computeDiffsModel(leftDocumentModel, rightDocumentModel, baseDocumentOpt);
    }

    protected AllDifferences findParentDiffHighlights(AuthorDocumentModel authorDocumentModel, DiffModelImpl diffModel, IntervalsPair.Side side) {
        List<ParentDiffInterval> left = diffModel.getParentDiffIntervals(side);
        return DiffDescriptorsUtil.getDiffHighlightsInfo(left, authorDocumentModel, side == IntervalsPair.Side.LEFT);
    }
}

