/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.webapp.diff.DiffDocumentsLinker;
import com.oxygenxml.webapp.diff.DiffPerformer;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.model.DiffModelStorage;
import com.oxygenxml.webapp.diff.model.ParentDiffInterval;
import com.oxygenxml.webapp.diff.operations.DiffOperationFailureResponse;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferenceDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.AllDifferences;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.DiffDescriptorsUtil;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.Differences;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@WebappRestSafe
public class ComputeDiffsOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(ComputeDiffsOperation.class);
    public static final String DIFF_INTERVALS_ATTR = "diff_intervals_attr";

    public String doOperation(AuthorDocumentModel leftDocumentModel, ArgumentsMap args) throws AuthorOperationException {
        DiffOperationResponse response = this.doOperationInternal(leftDocumentModel);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)response);
        }
        catch (IOException e) {
            log.warn((Object)e, (Throwable)e);
            throw new AuthorOperationException("Cannot serialize diff result.", (Throwable)e);
        }
    }

    DiffOperationResponse doOperationInternal(AuthorDocumentModel leftDocumentModel) {
        DiffDocumentsLinker documentsLinker = new DiffDocumentsLinker(leftDocumentModel);
        AuthorDocumentModel rightDocumentModel = documentsLinker.getPair();
        Optional<DiffDocumentsLinker.DiffBaseData> baseDocumentOpt = documentsLinker.getBase();
        return this.doOperationInternal(leftDocumentModel, rightDocumentModel, baseDocumentOpt);
    }

    public DiffOperationResponse doOperationInternal(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, Optional<DiffDocumentsLinker.DiffBaseData> baseDocumentOpt) {
        DiffOperationResponse toReturn;
        try {
            DiffPerformer diffPerformer = new DiffPerformer();
            DiffModelImpl diffModel = diffPerformer.computeDiffsModel(leftDocumentModel, rightDocumentModel, baseDocumentOpt);
            new DiffModelStorage(leftDocumentModel.getAuthorAccess().getEditorAccess().getEditingContext()).storeTempDiffModel(diffModel);
            new DiffModelStorage(rightDocumentModel.getAuthorAccess().getEditorAccess().getEditingContext()).storeTempDiffModel(diffModel);
            List<ParentDiffInterval> left = diffModel.getParentDiffIntervals(IntervalsPair.Side.LEFT);
            AllDifferences leftDiffs = DiffDescriptorsUtil.getDiffHighlightsInfo(left, leftDocumentModel, true);
            List<ParentDiffInterval> right = diffModel.getParentDiffIntervals(IntervalsPair.Side.RIGHT);
            AllDifferences rightDiffs = DiffDescriptorsUtil.getDiffHighlightsInfo(right, rightDocumentModel, false);
            DiffResponseStatus status = diffPerformer.computeResposeStatus(leftDocumentModel, rightDocumentModel, baseDocumentOpt, diffModel);
            toReturn = new DiffOperationSuccessResponse(status, leftDiffs, rightDiffs, diffModel.getDifferencesDescriptors());
        }
        catch (IOException | DiffException e) {
            log.warn((Object)e, e);
            toReturn = new DiffOperationFailureResponse("Unable to perform diff.");
        }
        catch (DiffPerformer.DiffNotLicensedException e) {
            toReturn = new DiffOperationFailureResponse(e.getMessage());
        }
        return toReturn;
    }

    public static class DiffOperationResponse {
        private final boolean success;

        public DiffOperationResponse(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    public static enum DiffResponseStatus {
        RESPONSE_FAIL_TO_LOAD_BASE("fail-load-base"),
        RESPONSE_NO_DIFF("no-diff"),
        RESPONSE_NO_AUTHOR_DIFF("no-author-diff"),
        NO_SIGNIFICANT_CHANGES("no-significant-changes"),
        RESPONSE_SUCCESS("success");

        public final String status;

        private DiffResponseStatus(String status) {
            this.status = status;
        }

        @JsonValue
        public String toString() {
            return this.status;
        }
    }

    public static class DiffOperationSuccessResponse
    extends DiffOperationResponse {
        private final DiffResponseStatus status;
        private final Differences leftDiffsDescriptors;
        private final Differences rightDiffsDescriptors;
        private final Map<String, Map<String, List<DifferenceDescriptor>>> differencesDescriptors;

        public DiffOperationSuccessResponse(DiffResponseStatus status, Differences leftDiffsDescriptors, Differences rightDiffsDescriptors, Map<String, Map<String, List<DifferenceDescriptor>>> differencesDescriptors) {
            super(true);
            this.status = status;
            this.leftDiffsDescriptors = leftDiffsDescriptors;
            this.rightDiffsDescriptors = rightDiffsDescriptors;
            this.differencesDescriptors = differencesDescriptors;
        }

        public DiffResponseStatus getStatus() {
            return this.status;
        }

        public Differences getLeftDiffsDescriptors() {
            return this.leftDiffsDescriptors;
        }

        public Differences getRightDiffsDescriptors() {
            return this.rightDiffsDescriptors;
        }

        public Map<String, Map<String, List<DifferenceDescriptor>>> getDifferencesDescriptors() {
            return this.differencesDescriptors;
        }
    }
}

